/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot.exceptions;

import io.github.zhangbinhub.acp.boot.enums.ResponseCode;
import io.github.zhangbinhub.acp.boot.exceptions.ServerException;
import io.github.zhangbinhub.acp.boot.interfaces.LogAdapter;
import io.github.zhangbinhub.acp.boot.tools.PackageTools;
import io.github.zhangbinhub.acp.core.exceptions.EnumValueUndefinedException;
import java.util.List;
import javax.validation.ConstraintViolationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0012J>\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\u0007\u001a\u00060\fj\u0002`\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\u0007\u001a\u00060\fj\u0002`\rH\u0017J.\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/zhangbinhub/acp/boot/exceptions/RestExceptionHandler;", "Lorg/springframework/web/servlet/mvc/method/annotation/ResponseEntityExceptionHandler;", "logAdapter", "Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;", "(Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;)V", "doLog", "", "ex", "", "handleExceptionInternal", "Lorg/springframework/http/ResponseEntity;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "body", "headers", "Lorg/springframework/http/HttpHeaders;", "status", "Lorg/springframework/http/HttpStatus;", "request", "Lorg/springframework/web/context/request/WebRequest;", "handleMethodArgumentNotValid", "Lorg/springframework/web/bind/MethodArgumentNotValidException;", "handleMissingServletRequestParameter", "Lorg/springframework/web/bind/MissingServletRequestParameterException;", "handleServerException", "handleTypeMismatch", "Lorg/springframework/beans/TypeMismatchException;", "acp-spring-boot-starter"})
public class RestExceptionHandler
extends ResponseEntityExceptionHandler {
    @NotNull
    private final LogAdapter logAdapter;

    public RestExceptionHandler(@NotNull LogAdapter logAdapter) {
        Intrinsics.checkNotNullParameter((Object)logAdapter, (String)"logAdapter");
        this.logAdapter = logAdapter;
    }

    private void doLog(Throwable ex) {
        this.logAdapter.error(ex.getMessage(), ex);
    }

    @ExceptionHandler(value={ServerException.class, ConstraintViolationException.class})
    @NotNull
    public ResponseEntity<Object> handleServerException(@NotNull Exception ex) {
        ResponseCode responseCode;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        try {
            ResponseCode responseCode2;
            this.doLog(ex);
            if (ex instanceof ServerException) {
                Integer n = ((ServerException)((Object)ex)).getCode();
                responseCode2 = ResponseCode.Companion.getEnum(n == null ? 99999 : n);
            } else {
                responseCode2 = ex instanceof ConstraintViolationException || ex instanceof MethodArgumentNotValidException ? ResponseCode.InvalidParameter : ResponseCode.OtherError;
            }
            responseCode = responseCode2;
        }
        catch (EnumValueUndefinedException e) {
            responseCode = ResponseCode.OtherError;
        }
        ResponseCode it = responseCode;
        boolean bl = false;
        String[] stringArray = new String[]{"application/json"};
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).header("Content-Type", stringArray)).body((Object)PackageTools.buildErrorResponsePackage(it, ex.getMessage()));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"try {\n            doLog(\u2026t, ex.message))\n        }");
        return responseEntity;
    }

    @NotNull
    protected ResponseEntity<Object> handleMethodArgumentNotValid(@NotNull MethodArgumentNotValidException ex, @NotNull HttpHeaders headers, @NotNull HttpStatus status, @NotNull WebRequest request) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        List it = ex.getBindingResult().getAllErrors();
        boolean bl = false;
        this.doLog((Throwable)ex);
        StringBuilder errorMsg = new StringBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Iterable $this$forEach$iv = it;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObjectError error = (ObjectError)element$iv;
            boolean bl2 = false;
            errorMsg.append(error.getDefaultMessage()).append(";");
        }
        String[] stringArray = new String[]{"application/json"};
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).header("Content-Type", stringArray)).body((Object)PackageTools.buildErrorResponsePackage(ResponseCode.InvalidParameter, errorMsg.toString()));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ex.bindingResult.allErro\u2026sg.toString()))\n        }");
        return responseEntity;
    }

    @NotNull
    protected ResponseEntity<Object> handleMissingServletRequestParameter(@NotNull MissingServletRequestParameterException ex, @NotNull HttpHeaders headers, @NotNull HttpStatus status, @NotNull WebRequest request) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.doLog((Throwable)ex);
        String[] stringArray = new String[]{"application/json"};
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).header("Content-Type", stringArray)).body((Object)PackageTools.buildErrorResponsePackage(ResponseCode.InvalidParameter, ex.getMessage()));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(HttpStatus.INTERN\u2026idParameter, ex.message))");
        return responseEntity;
    }

    @NotNull
    protected ResponseEntity<Object> handleTypeMismatch(@NotNull TypeMismatchException ex, @NotNull HttpHeaders headers, @NotNull HttpStatus status, @NotNull WebRequest request) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.doLog((Throwable)ex);
        String[] stringArray = new String[]{"application/json"};
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).header("Content-Type", stringArray)).body((Object)PackageTools.buildErrorResponsePackage(ResponseCode.InvalidParameter, ex.getMessage()));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(HttpStatus.INTERN\u2026idParameter, ex.message))");
        return responseEntity;
    }

    @NotNull
    protected ResponseEntity<Object> handleExceptionInternal(@NotNull Exception ex, @Nullable Object body, @Nullable HttpHeaders headers, @NotNull HttpStatus status, @NotNull WebRequest request) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.doLog(ex);
        String[] stringArray = new String[]{"application/json"};
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).header("Content-Type", stringArray)).body((Object)PackageTools.buildErrorResponsePackage(ResponseCode.OtherError, ex.getMessage()));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(HttpStatus.INTERN\u2026.OtherError, ex.message))");
        return responseEntity;
    }
}

