/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot.component;

import io.github.zhangbinhub.acp.boot.component.BootLogAdapter;
import io.github.zhangbinhub.acp.core.CommonTools;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/zhangbinhub/acp/boot/component/ServerTools;", "Lorg/springframework/context/ApplicationListener;", "Lorg/springframework/boot/web/context/WebServerInitializedEvent;", "()V", "ip", "", "logAdapter", "Lio/github/zhangbinhub/acp/boot/component/BootLogAdapter;", "port", "Ljava/util/concurrent/atomic/AtomicInteger;", "getServerIp", "getServerPort", "", "onApplicationEvent", "", "event", "acp-spring-boot-starter"})
public final class ServerTools
implements ApplicationListener<WebServerInitializedEvent> {
    @NotNull
    private final BootLogAdapter logAdapter = new BootLogAdapter();
    @Value(value="${server.address:}")
    @Nullable
    private String ip;
    @NotNull
    private final AtomicInteger port = new AtomicInteger(0);

    public void onApplicationEvent(@NotNull WebServerInitializedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        WebServerApplicationContext webServerApplicationContext = event.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)webServerApplicationContext, (String)"event.applicationContext");
        ApplicationContext context = (ApplicationContext)webServerApplicationContext;
        if (context instanceof ConfigurableWebServerApplicationContext && Intrinsics.areEqual((Object)"management", (Object)((ConfigurableWebServerApplicationContext)context).getServerNamespace())) {
            return;
        }
        this.port.compareAndSet(0, event.getWebServer().getPort());
        this.logAdapter.info("Web Server has started, listening to port: " + this.port.get());
    }

    public final int getServerPort() {
        return this.port.get();
    }

    @NotNull
    public final String getServerIp() {
        String string;
        if (CommonTools.isNullStr((String)this.ip)) {
            String string2;
            try {
                string2 = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                string2 = "";
            }
            String string3 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n        try {\n        \u2026       \"\"\n        }\n    }");
            string = string3;
        } else {
            String string4 = this.ip;
            string = string4;
            Intrinsics.checkNotNull((Object)string4);
        }
        return string;
    }
}

