/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot.init.task;

import io.github.zhangbinhub.acp.boot.conf.SocketListenerConfiguration;
import io.github.zhangbinhub.acp.boot.conf.UdpServerConfiguration;
import io.github.zhangbinhub.acp.boot.daemon.DaemonServiceManager;
import io.github.zhangbinhub.acp.boot.init.BaseInitTask;
import io.github.zhangbinhub.acp.boot.interfaces.LogAdapter;
import io.github.zhangbinhub.acp.boot.socket.base.ISocketServerHandle;
import io.github.zhangbinhub.acp.boot.socket.udp.UdpServer;
import io.github.zhangbinhub.acp.core.CommonTools;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/github/zhangbinhub/acp/boot/init/task/InitUdpServer;", "Lio/github/zhangbinhub/acp/boot/init/BaseInitTask;", "logAdapter", "Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;", "udpServerConfiguration", "Lio/github/zhangbinhub/acp/boot/conf/UdpServerConfiguration;", "socketServerHandleList", "", "Lio/github/zhangbinhub/acp/boot/socket/base/ISocketServerHandle;", "(Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;Lio/github/zhangbinhub/acp/boot/conf/UdpServerConfiguration;Ljava/util/List;)V", "startUdpServer", "", "acp-spring-boot-starter"})
public final class InitUdpServer
extends BaseInitTask {
    @NotNull
    private final LogAdapter logAdapter;
    @NotNull
    private final UdpServerConfiguration udpServerConfiguration;
    @NotNull
    private final List<ISocketServerHandle> socketServerHandleList;

    public InitUdpServer(@NotNull LogAdapter logAdapter, @NotNull UdpServerConfiguration udpServerConfiguration, @NotNull List<? extends ISocketServerHandle> socketServerHandleList) {
        Intrinsics.checkNotNullParameter((Object)logAdapter, (String)"logAdapter");
        Intrinsics.checkNotNullParameter((Object)udpServerConfiguration, (String)"udpServerConfiguration");
        Intrinsics.checkNotNullParameter(socketServerHandleList, (String)"socketServerHandleList");
        this.logAdapter = logAdapter;
        this.udpServerConfiguration = udpServerConfiguration;
        this.socketServerHandleList = socketServerHandleList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startUdpServer() {
        this.logAdapter.info("start udp listen service ...");
        if (!((Collection)this.socketServerHandleList).isEmpty()) {
            Iterable $this$forEach$iv = this.socketServerHandleList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ISocketServerHandle socketServerHandle = (ISocketServerHandle)element$iv;
                boolean bl = false;
                this.addServerHandle(socketServerHandle);
            }
        }
        try {
            List<SocketListenerConfiguration> listens = this.udpServerConfiguration.getListeners();
            if (!((Collection)listens).isEmpty()) {
                Iterable $this$forEach$iv = listens;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SocketListenerConfiguration listen = (SocketListenerConfiguration)element$iv;
                    boolean bl = false;
                    InitUdpServer $this$startUdpServer_u24lambda_u2d2_u24lambda_u2d1 = this;
                    boolean bl2 = false;
                    if (listen.getEnabled()) {
                        String beanName = listen.getHandleBean();
                        if (CommonTools.isNullStr((String)beanName)) continue;
                        ISocketServerHandle handle = $this$startUdpServer_u24lambda_u2d2_u24lambda_u2d1.getSocketServerHandle(beanName);
                        if (handle != null) {
                            int port = listen.getPort();
                            UdpServer server = new UdpServer($this$startUdpServer_u24lambda_u2d2_u24lambda_u2d1.logAdapter, port, listen, handle);
                            Thread sub = new Thread(server);
                            sub.setDaemon(true);
                            sub.start();
                            DaemonServiceManager.Companion.addService(server);
                            $this$startUdpServer_u24lambda_u2d2_u24lambda_u2d1.logAdapter.info("start udp listen service Success [" + listen.getName() + "] , port:" + listen.getPort());
                            continue;
                        }
                        $this$startUdpServer_u24lambda_u2d2_u24lambda_u2d1.logAdapter.error("udp handle bean [" + beanName + "] is invalid!");
                        continue;
                    }
                    $this$startUdpServer_u24lambda_u2d2_u24lambda_u2d1.logAdapter.info("udp listen service is disabled [" + listen.getName() + ']');
                }
            } else {
                this.logAdapter.info("No udp listen service was found");
            }
        }
        catch (Exception e) {
            this.logAdapter.error(e.getMessage(), e);
        }
        finally {
            this.logAdapter.info("start udp listen service finished!");
        }
    }
}

