/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot.daemon;

import io.github.zhangbinhub.acp.core.interfaces.IDaemonService;
import io.github.zhangbinhub.acp.core.log.LogFactory;
import io.github.zhangbinhub.acp.core.task.threadpool.ThreadPoolService;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\t"}, d2={"Lio/github/zhangbinhub/acp/boot/daemon/DaemonServiceManager;", "Ljavax/servlet/ServletContextListener;", "()V", "contextDestroyed", "", "servletContextEvent", "Ljavax/servlet/ServletContextEvent;", "contextInitialized", "Companion", "acp-spring-boot-starter"})
public final class DaemonServiceManager
implements ServletContextListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final LogFactory log = LogFactory.Companion.getInstance$default((LogFactory.Companion)LogFactory.Companion, DaemonServiceManager.class, (int)0, (int)2, null);
    @NotNull
    private static final ConcurrentLinkedDeque<IDaemonService> serverDeque = new ConcurrentLinkedDeque();

    public void contextInitialized(@Nullable ServletContextEvent servletContextEvent) {
    }

    public void contextDestroyed(@Nullable ServletContextEvent servletContextEvent) {
        Companion.stopAllService();
    }

    @JvmStatic
    public static final void addService(@NotNull IDaemonService daemonService) {
        Companion.addService(daemonService);
    }

    @JvmStatic
    public static final void addAllService(@NotNull List<? extends IDaemonService> daemonServiceList) {
        Companion.addAllService(daemonServiceList);
    }

    @JvmStatic
    public static final void stopAllService() {
        Companion.stopAllService();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0007J\b\u0010\u000e\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/zhangbinhub/acp/boot/daemon/DaemonServiceManager$Companion;", "", "()V", "log", "Lio/github/zhangbinhub/acp/core/log/LogFactory;", "serverDeque", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lio/github/zhangbinhub/acp/core/interfaces/IDaemonService;", "addAllService", "", "daemonServiceList", "", "addService", "daemonService", "stopAllService", "acp-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void addService(@NotNull IDaemonService daemonService) {
            Intrinsics.checkNotNullParameter((Object)daemonService, (String)"daemonService");
            ConcurrentLinkedDeque concurrentLinkedDeque = serverDeque;
            synchronized (concurrentLinkedDeque) {
                boolean bl = false;
                if (!serverDeque.contains(daemonService)) {
                    serverDeque.push(daemonService);
                    log.info("add daemon service [" + daemonService.getServiceName() + ']');
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void addAllService(@NotNull List<? extends IDaemonService> daemonServiceList) {
            Intrinsics.checkNotNullParameter(daemonServiceList, (String)"daemonServiceList");
            ConcurrentLinkedDeque concurrentLinkedDeque = serverDeque;
            synchronized (concurrentLinkedDeque) {
                boolean bl = false;
                Iterable $this$forEach$iv = daemonServiceList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IDaemonService daemonService = (IDaemonService)element$iv;
                    boolean bl2 = false;
                    Companion $this$addAllService_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1 = Companion;
                    boolean bl3 = false;
                    if (serverDeque.contains(daemonService)) continue;
                    serverDeque.push(daemonService);
                    log.info("add daemon service [" + daemonService.getServiceName() + ']');
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void stopAllService() {
            ThreadPoolService.Companion.destroyAll();
            ConcurrentLinkedDeque concurrentLinkedDeque = serverDeque;
            synchronized (concurrentLinkedDeque) {
                boolean bl = false;
                while (!serverDeque.isEmpty()) {
                    IDaemonService daemonService = (IDaemonService)serverDeque.pop();
                    daemonService.stopService();
                    log.info("destroy daemon service [" + daemonService.getServiceName() + ']');
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

