/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot.tools;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import io.github.zhangbinhub.acp.boot.enums.ResponseCode;
import io.github.zhangbinhub.acp.boot.vo.ErrorVo;
import io.github.zhangbinhub.acp.core.CommonTools;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.core.env.Environment;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lio/github/zhangbinhub/acp/boot/tools/PackageTools;", "", "()V", "buildErrorResponsePackage", "Lio/github/zhangbinhub/acp/boot/vo/ErrorVo;", "responseCode", "Lio/github/zhangbinhub/acp/boot/enums/ResponseCode;", "msg", "", "code", "", "buildJacksonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "jacksonProperties", "Lorg/springframework/boot/autoconfigure/jackson/JacksonProperties;", "environment", "Lorg/springframework/core/env/Environment;", "acp-spring-boot-starter"})
public final class PackageTools {
    @NotNull
    public static final PackageTools INSTANCE = new PackageTools();

    private PackageTools() {
    }

    @JvmStatic
    @NotNull
    public static final ObjectMapper buildJacksonObjectMapper(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        JacksonProperties jacksonProperties = new JacksonProperties();
        jacksonProperties.setPropertyNamingStrategy(environment.getProperty("spring.jackson.property-naming-strategy", ""));
        String string = environment.getProperty("spring.jackson.default-property-inclusion", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"environment.getProperty(\u2026-property-inclusion\", \"\")");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (Intrinsics.areEqual((Object)"non_null", (Object)string2)) {
            jacksonProperties.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
        }
        return PackageTools.buildJacksonObjectMapper(jacksonProperties);
    }

    @JvmStatic
    @NotNull
    public static final ObjectMapper buildJacksonObjectMapper(@NotNull JacksonProperties jacksonProperties) {
        Intrinsics.checkNotNullParameter((Object)jacksonProperties, (String)"jacksonProperties");
        Jackson2ObjectMapperBuilder builder = Jackson2ObjectMapperBuilder.json();
        PropertyNamingStrategy propertyNamingStrategyDefault = new PropertyNamingStrategy();
        String string = jacksonProperties.getPropertyNamingStrategy();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jacksonProperties.propertyNamingStrategy");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        if (Intrinsics.areEqual((Object)"SNAKE_CASE", (Object)string2)) {
            propertyNamingStrategyDefault = (PropertyNamingStrategy)new PropertyNamingStrategies.SnakeCaseStrategy();
        }
        builder.propertyNamingStrategy(propertyNamingStrategyDefault);
        if (jacksonProperties.getDefaultPropertyInclusion() != null) {
            builder.serializationInclusion(jacksonProperties.getDefaultPropertyInclusion());
        }
        string = builder.propertyNamingStrategy(propertyNamingStrategyDefault).build();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.propertyNamingSt\u2026gStrategyDefault).build()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ErrorVo buildErrorResponsePackage(@NotNull ResponseCode responseCode, @Nullable String msg) {
        Intrinsics.checkNotNullParameter((Object)((Object)responseCode), (String)"responseCode");
        String message = msg;
        if (CommonTools.isNullStr((String)message)) {
            message = responseCode.getDescription();
        }
        return PackageTools.buildErrorResponsePackage(responseCode.getValue(), message);
    }

    @JvmStatic
    @NotNull
    public static final ErrorVo buildErrorResponsePackage(int code, @Nullable String msg) {
        ErrorVo errorVO = new ErrorVo(0, null, null, 7, null);
        errorVO.setCode(code);
        errorVO.setError(msg);
        errorVO.setErrorDescription(msg);
        return errorVO;
    }
}

