/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot.socket.tcp;

import io.github.zhangbinhub.acp.boot.conf.SocketListenerConfiguration;
import io.github.zhangbinhub.acp.boot.interfaces.LogAdapter;
import io.github.zhangbinhub.acp.boot.socket.base.ISocketServerHandle;
import io.github.zhangbinhub.acp.boot.socket.tcp.TcpServerHandle;
import io.github.zhangbinhub.acp.core.interfaces.IDaemonService;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/zhangbinhub/acp/boot/socket/tcp/TcpServer;", "Lio/github/zhangbinhub/acp/core/interfaces/IDaemonService;", "Ljava/lang/Runnable;", "logAdapter", "Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;", "port", "", "socketListenerConfiguration", "Lio/github/zhangbinhub/acp/boot/conf/SocketListenerConfiguration;", "socketServerHandle", "Lio/github/zhangbinhub/acp/boot/socket/base/ISocketServerHandle;", "messageDecoder", "Lio/netty/handler/codec/ByteToMessageDecoder;", "(Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;ILio/github/zhangbinhub/acp/boot/conf/SocketListenerConfiguration;Lio/github/zhangbinhub/acp/boot/socket/base/ISocketServerHandle;Lio/netty/handler/codec/ByteToMessageDecoder;)V", "bossGroup", "Lio/netty/channel/EventLoopGroup;", "workerGroup", "getServiceName", "", "run", "", "stopService", "acp-spring-boot-starter"})
public final class TcpServer
implements IDaemonService,
Runnable {
    @NotNull
    private final LogAdapter logAdapter;
    private final int port;
    @NotNull
    private final SocketListenerConfiguration socketListenerConfiguration;
    @Nullable
    private final ISocketServerHandle socketServerHandle;
    @Nullable
    private final ByteToMessageDecoder messageDecoder;
    @NotNull
    private final EventLoopGroup bossGroup;
    @NotNull
    private final EventLoopGroup workerGroup;

    public TcpServer(@NotNull LogAdapter logAdapter, int port, @NotNull SocketListenerConfiguration socketListenerConfiguration, @Nullable ISocketServerHandle socketServerHandle, @Nullable ByteToMessageDecoder messageDecoder) {
        Intrinsics.checkNotNullParameter((Object)logAdapter, (String)"logAdapter");
        Intrinsics.checkNotNullParameter((Object)socketListenerConfiguration, (String)"socketListenerConfiguration");
        this.logAdapter = logAdapter;
        this.port = port;
        this.socketListenerConfiguration = socketListenerConfiguration;
        this.socketServerHandle = socketServerHandle;
        this.messageDecoder = messageDecoder;
        this.bossGroup = (EventLoopGroup)new NioEventLoopGroup();
        this.workerGroup = (EventLoopGroup)new NioEventLoopGroup(this.socketListenerConfiguration.getThreadNumber());
    }

    @Override
    public void run() {
        if (this.socketServerHandle != null) {
            try {
                ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.socketListenerConfiguration.getKeepAlive()).childHandler((ChannelHandler)new ChannelInitializer<Channel>(this){
                    final /* synthetic */ TcpServer this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    protected void initChannel(@NotNull Channel ch) {
                        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                        ChannelHandler[] channelHandlerArray = ch.pipeline();
                        TcpServer tcpServer = this.this$0;
                        ChannelHandler[] $this$initChannel_u24lambda_u2d1 = channelHandlerArray;
                        boolean bl = false;
                        ByteToMessageDecoder byteToMessageDecoder = TcpServer.access$getMessageDecoder$p(tcpServer);
                        if (byteToMessageDecoder != null) {
                            ByteToMessageDecoder it = byteToMessageDecoder;
                            boolean bl2 = false;
                            ChannelHandler[] channelHandlerArray2 = new ChannelHandler[]{(ChannelHandler)it};
                            $this$initChannel_u24lambda_u2d1.addLast(channelHandlerArray2);
                        }
                        if (TcpServer.access$getSocketListenerConfiguration$p(tcpServer).getKeepAlive()) {
                            ChannelHandler[] channelHandlerArray3 = new ChannelHandler[]{(ChannelHandler)new IdleStateHandler(TcpServer.access$getSocketListenerConfiguration$p(tcpServer).getIdletime(), TcpServer.access$getSocketListenerConfiguration$p(tcpServer).getIdletime(), TcpServer.access$getSocketListenerConfiguration$p(tcpServer).getIdletime(), TimeUnit.MILLISECONDS)};
                            $this$initChannel_u24lambda_u2d1.addLast(channelHandlerArray3);
                        }
                        ChannelHandler[] channelHandlerArray4 = channelHandlerArray;
                        channelHandlerArray = new ChannelHandler[]{(ChannelHandler)new TcpServerHandle(TcpServer.access$getLogAdapter$p(this.this$0), TcpServer.access$getSocketListenerConfiguration$p(this.this$0), TcpServer.access$getSocketServerHandle$p(this.this$0))};
                        channelHandlerArray4.addLast(channelHandlerArray);
                    }
                }).bind(this.port).sync().channel().closeFuture().sync();
            }
            catch (Exception e) {
                this.logAdapter.error(e.getMessage(), e);
            }
        } else {
            this.logAdapter.error("tcp listen server is stop,case by:response object is null[BaseSocketHandle]");
        }
    }

    @NotNull
    public String getServiceName() {
        return this.socketListenerConfiguration.getName();
    }

    public void stopService() {
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
    }

    public static final /* synthetic */ LogAdapter access$getLogAdapter$p(TcpServer $this) {
        return $this.logAdapter;
    }

    public static final /* synthetic */ SocketListenerConfiguration access$getSocketListenerConfiguration$p(TcpServer $this) {
        return $this.socketListenerConfiguration;
    }

    public static final /* synthetic */ ISocketServerHandle access$getSocketServerHandle$p(TcpServer $this) {
        return $this.socketServerHandle;
    }

    public static final /* synthetic */ ByteToMessageDecoder access$getMessageDecoder$p(TcpServer $this) {
        return $this.messageDecoder;
    }
}

