/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot.tools;

import io.github.zhangbinhub.acp.core.CommonTools;
import io.github.zhangbinhub.acp.core.log.LogFactory;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/github/zhangbinhub/acp/boot/tools/HttpTools;", "", "()V", "log", "Lio/github/zhangbinhub/acp/core/log/LogFactory;", "getRequestContent", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "getWebRootPath", "isBeIdentifiedUri", "", "uri", "regex", "acp-spring-boot-starter"})
public final class HttpTools {
    @NotNull
    public static final HttpTools INSTANCE = new HttpTools();
    @NotNull
    private static final LogFactory log = LogFactory.Companion.getInstance$default((LogFactory.Companion)LogFactory.Companion, HttpTools.class, (int)0, (int)2, null);

    private HttpTools() {
    }

    @JvmStatic
    @NotNull
    public static final String getWebRootPath(@NotNull HttpServletRequest request) {
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String webRoot = request.getContextPath();
        if (Intrinsics.areEqual((Object)webRoot, (Object)"/")) {
            string = "";
        } else {
            String string2 = webRoot;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            webRoot\n        }");
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final String getRequestContent(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ServletInputStream sis = null;
        try {
            Object object;
            String string;
            int count;
            sis = request.getInputStream();
            int size = request.getContentLength();
            if (size <= 0) {
                String string2 = "";
                return string2;
            }
            byte[] buffer = new byte[size];
            byte[] dataByte = new byte[size];
            int rbyte = 0;
            for (count = 0; count < size; count += rbyte) {
                ServletInputStream servletInputStream = sis;
                Intrinsics.checkNotNull((Object)servletInputStream);
                rbyte = servletInputStream.read(buffer);
                if (rbyte <= 0) break;
                System.arraycopy(buffer, 0, dataByte, count, rbyte);
            }
            if (count <= 0) {
                string = "";
            } else {
                object = request.getCharacterEncoding();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"request.characterEncoding");
                Charset charset = Charset.forName((String)object);
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
                object = charset;
                string = new String(dataByte, (Charset)object);
            }
            object = string;
            return object;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            String buffer = "";
            return buffer;
        }
        finally {
            if (sis != null) {
                try {
                    sis.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @JvmStatic
    public static final boolean isBeIdentifiedUri(@NotNull String uri, @NotNull String regex) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return CommonTools.regexPattern((String)regex, (String)uri);
    }
}

