/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot.socket.base;

import io.github.zhangbinhub.acp.boot.conf.SocketListenerConfiguration;
import io.github.zhangbinhub.acp.boot.interfaces.LogAdapter;
import io.github.zhangbinhub.acp.boot.socket.base.ISocketServerHandle;
import io.github.zhangbinhub.acp.core.CommonTools;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H$J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H$J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH$J\"\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH$J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\"\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020\u001fH\u0004J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lio/github/zhangbinhub/acp/boot/socket/base/SocketServerHandle;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "logAdapter", "Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;", "socketListenerConfiguration", "Lio/github/zhangbinhub/acp/boot/conf/SocketListenerConfiguration;", "socketServerHandle", "Lio/github/zhangbinhub/acp/boot/socket/base/ISocketServerHandle;", "(Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;Lio/github/zhangbinhub/acp/boot/conf/SocketListenerConfiguration;Lio/github/zhangbinhub/acp/boot/socket/base/ISocketServerHandle;)V", "getLogAdapter", "()Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;", "getSocketListenerConfiguration", "()Lio/github/zhangbinhub/acp/boot/conf/SocketListenerConfiguration;", "setSocketListenerConfiguration", "(Lio/github/zhangbinhub/acp/boot/conf/SocketListenerConfiguration;)V", "getSocketServerHandle", "()Lio/github/zhangbinhub/acp/boot/socket/base/ISocketServerHandle;", "setSocketServerHandle", "(Lio/github/zhangbinhub/acp/boot/socket/base/ISocketServerHandle;)V", "afterReadMessage", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "afterSendMessage", "beforeReadMessage", "Lio/netty/buffer/ByteBuf;", "msg", "", "beforeSendMessage", "requestMsg", "sendStr", "", "channelRead", "doResponse", "responseStr", "exceptionCaught", "cause", "", "acp-spring-boot-starter"})
public abstract class SocketServerHandle
extends ChannelInboundHandlerAdapter {
    @NotNull
    private final LogAdapter logAdapter;
    @NotNull
    private SocketListenerConfiguration socketListenerConfiguration;
    @NotNull
    private ISocketServerHandle socketServerHandle;

    public SocketServerHandle(@NotNull LogAdapter logAdapter, @NotNull SocketListenerConfiguration socketListenerConfiguration, @NotNull ISocketServerHandle socketServerHandle) {
        Intrinsics.checkNotNullParameter((Object)logAdapter, (String)"logAdapter");
        Intrinsics.checkNotNullParameter((Object)socketListenerConfiguration, (String)"socketListenerConfiguration");
        Intrinsics.checkNotNullParameter((Object)socketServerHandle, (String)"socketServerHandle");
        this.logAdapter = logAdapter;
        this.socketListenerConfiguration = socketListenerConfiguration;
        this.socketServerHandle = socketServerHandle;
    }

    @NotNull
    protected final LogAdapter getLogAdapter() {
        return this.logAdapter;
    }

    @NotNull
    protected final SocketListenerConfiguration getSocketListenerConfiguration() {
        return this.socketListenerConfiguration;
    }

    protected final void setSocketListenerConfiguration(@NotNull SocketListenerConfiguration socketListenerConfiguration) {
        Intrinsics.checkNotNullParameter((Object)socketListenerConfiguration, (String)"<set-?>");
        this.socketListenerConfiguration = socketListenerConfiguration;
    }

    @NotNull
    protected final ISocketServerHandle getSocketServerHandle() {
        return this.socketServerHandle;
    }

    protected final void setSocketServerHandle(@NotNull ISocketServerHandle iSocketServerHandle) {
        Intrinsics.checkNotNullParameter((Object)iSocketServerHandle, (String)"<set-?>");
        this.socketServerHandle = iSocketServerHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        try {
            String string;
            ByteBuf byteBuf = this.beforeReadMessage(msg);
            if (this.socketListenerConfiguration.getHex()) {
                string = ByteBufUtil.hexDump((ByteBuf)byteBuf);
            } else {
                Charset charset = Charset.forName(this.socketListenerConfiguration.getCharset());
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
                string = byteBuf.toString(charset);
            }
            String recvStr = string;
            this.logAdapter.debug("socket receive:" + recvStr);
            Intrinsics.checkNotNullExpressionValue((Object)recvStr, (String)"recvStr");
            String responseStr = this.socketServerHandle.doResponse(recvStr);
            if (this.socketListenerConfiguration.getResponsable()) {
                responseStr = CommonTools.isNullStr((String)responseStr) ? "" : responseStr;
                try {
                    this.doResponse(ctx, msg, responseStr);
                    this.logAdapter.debug("socket return:" + responseStr);
                }
                catch (Exception e) {
                    this.logAdapter.error(e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            this.logAdapter.error(e.getMessage(), e);
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
            this.afterReadMessage(ctx);
        }
    }

    protected final void doResponse(@NotNull ChannelHandlerContext ctx, @Nullable Object requestMsg, @NotNull String responseStr) throws Exception {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)responseStr, (String)"responseStr");
        String retStr = responseStr;
        if (this.socketListenerConfiguration.getHex()) {
            byte[] bts = ByteBufUtil.decodeHexDump((CharSequence)responseStr);
            Intrinsics.checkNotNullExpressionValue((Object)bts, (String)"bts");
            Charset charset = Charset.forName(this.socketListenerConfiguration.getCharset());
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            retStr = new String(bts, charset);
        }
        Object msgPackage = this.beforeSendMessage(ctx, requestMsg, retStr);
        ctx.writeAndFlush(msgPackage);
        this.afterSendMessage(ctx);
    }

    @NotNull
    protected abstract ByteBuf beforeReadMessage(@NotNull Object var1);

    protected abstract void afterReadMessage(@NotNull ChannelHandlerContext var1);

    @NotNull
    protected abstract Object beforeSendMessage(@NotNull ChannelHandlerContext var1, @Nullable Object var2, @NotNull String var3) throws Exception;

    protected abstract void afterSendMessage(@NotNull ChannelHandlerContext var1);

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.logAdapter.error(cause.getMessage(), cause);
        ctx.close();
    }
}

