/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot.component;

import io.github.zhangbinhub.acp.boot.daemon.DaemonServiceManager;
import io.github.zhangbinhub.acp.boot.interfaces.Listener;
import io.github.zhangbinhub.acp.boot.interfaces.LogAdapter;
import io.github.zhangbinhub.acp.boot.interfaces.TimerTaskScheduler;
import io.github.zhangbinhub.acp.core.interfaces.IDaemonService;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\u0006H\u0016J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\rJ\b\u0010\u0010\u001a\u00020\rH\u0016R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/github/zhangbinhub/acp/boot/component/SystemControl;", "Lio/github/zhangbinhub/acp/core/interfaces/IDaemonService;", "logAdapter", "Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;", "listenerMap", "", "", "Lio/github/zhangbinhub/acp/boot/interfaces/Listener;", "timerTaskScheduler", "Lio/github/zhangbinhub/acp/boot/interfaces/TimerTaskScheduler;", "(Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;Ljava/util/Map;Lio/github/zhangbinhub/acp/boot/interfaces/TimerTaskScheduler;)V", "getServiceName", "initialization", "", "start", "stop", "stopService", "acp-spring-boot-starter"})
public final class SystemControl
implements IDaemonService {
    @NotNull
    private final LogAdapter logAdapter;
    @Nullable
    private final Map<String, Listener> listenerMap;
    @NotNull
    private final TimerTaskScheduler timerTaskScheduler;

    public SystemControl(@NotNull LogAdapter logAdapter, @Nullable Map<String, ? extends Listener> listenerMap, @NotNull TimerTaskScheduler timerTaskScheduler) {
        Intrinsics.checkNotNullParameter((Object)logAdapter, (String)"logAdapter");
        Intrinsics.checkNotNullParameter((Object)timerTaskScheduler, (String)"timerTaskScheduler");
        this.logAdapter = logAdapter;
        this.listenerMap = listenerMap;
        this.timerTaskScheduler = timerTaskScheduler;
    }

    public final void initialization() {
        try {
            this.start();
        }
        catch (Exception e) {
            this.logAdapter.error(e.getMessage(), e);
        }
        DaemonServiceManager.Companion.addService(this);
    }

    public final void start() throws Exception {
        if (this.listenerMap != null && !this.listenerMap.isEmpty()) {
            this.logAdapter.info("start listener begin ...");
            Map<String, Listener> $this$forEach$iv = this.listenerMap;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Listener>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Listener> element$iv;
                Map.Entry<String, Listener> $dstr$key$listener = element$iv = iterator.next();
                boolean bl = false;
                String key = $dstr$key$listener.getKey();
                Listener listener = $dstr$key$listener.getValue();
                this.logAdapter.info("\u5f00\u59cb\u542f\u52a8\u76d1\u542c\uff1a" + key + " \u3010" + listener.getClass().getCanonicalName() + "\u3011");
                listener.startListener();
            }
            this.logAdapter.info("start listener finished!");
        }
        this.timerTaskScheduler.controlSchedule(1);
    }

    public final void stop() {
        try {
            if (this.listenerMap != null && !this.listenerMap.isEmpty()) {
                this.logAdapter.info("stop listener begin ...");
                Map<String, Listener> $this$forEach$iv = this.listenerMap;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, Listener>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Listener> element$iv;
                    Map.Entry<String, Listener> $dstr$key$listener = element$iv = iterator.next();
                    boolean bl = false;
                    String key = $dstr$key$listener.getKey();
                    Listener listener = $dstr$key$listener.getValue();
                    this.logAdapter.info("\u5f00\u59cb\u505c\u6b62\u76d1\u542c\uff1a" + key + " \u3010" + listener.getClass().getCanonicalName() + "\u3011");
                    listener.stopListener();
                }
                this.logAdapter.info("stop listener finished!");
            }
            this.timerTaskScheduler.controlSchedule(0);
        }
        catch (Exception e) {
            this.logAdapter.error(e.getMessage(), e);
        }
    }

    @NotNull
    public String getServiceName() {
        return "\u7cfb\u7edf\u63a7\u5236\u670d\u52a1";
    }

    public void stopService() {
        this.stop();
    }
}

