/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot.aspect;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.zhangbinhub.acp.boot.component.BootLogAdapter;
import io.github.zhangbinhub.acp.boot.conf.ControllerLogConfiguration;
import io.github.zhangbinhub.acp.boot.tools.HttpTools;
import io.github.zhangbinhub.acp.core.CommonTools;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.annotation.Order;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncTask;

@Aspect
@Order(value=0x7FFFFFFF)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/github/zhangbinhub/acp/boot/aspect/RestControllerAspect;", "", "controllerLogConfiguration", "Lio/github/zhangbinhub/acp/boot/conf/ControllerLogConfiguration;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lio/github/zhangbinhub/acp/boot/conf/ControllerLogConfiguration;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "logAdapter", "Lio/github/zhangbinhub/acp/boot/component/BootLogAdapter;", "noLogUriRegular", "", "", "doAround", "pjp", "Lorg/aspectj/lang/ProceedingJoinPoint;", "executeService", "", "needLog", "", "uri", "acp-spring-boot-starter"})
public final class RestControllerAspect {
    @NotNull
    private final ControllerLogConfiguration controllerLogConfiguration;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final BootLogAdapter logAdapter;
    @NotNull
    private final List<String> noLogUriRegular;

    public RestControllerAspect(@NotNull ControllerLogConfiguration controllerLogConfiguration, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)controllerLogConfiguration, (String)"controllerLogConfiguration");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.controllerLogConfiguration = controllerLogConfiguration;
        this.objectMapper = objectMapper;
        this.logAdapter = new BootLogAdapter();
        Object[] objectArray = new String[]{"/error"};
        this.noLogUriRegular = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @Pointcut(value="execution(public * *(..)) && (@within(org.springframework.web.bind.annotation.RestController) || @within(org.springframework.stereotype.Controller)) && ( @annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PatchMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping) || @annotation(org.springframework.web.bind.annotation.Mapping) ) ")
    public final void executeService() {
    }

    @Around(value="executeService()")
    @Nullable
    public final Object doAround(@NotNull ProceedingJoinPoint pjp) throws Throwable {
        Intrinsics.checkNotNullParameter((Object)pjp, (String)"pjp");
        Object response = null;
        long beginTime = System.currentTimeMillis();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            ServletRequestAttributes servletRequestAttributes;
            RequestAttributes it = requestAttributes;
            boolean bl = false;
            ServletRequestAttributes $this$doAround_u24lambda_u2d3_u24lambda_u2d2 = servletRequestAttributes = (ServletRequestAttributes)it;
            boolean bl2 = false;
            HttpServletRequest request = $this$doAround_u24lambda_u2d3_u24lambda_u2d2.getRequest();
            String method = request.getMethod();
            String uri = request.getRequestURI();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
            if (this.needLog(this.controllerLogConfiguration, uri)) {
                Enumeration params;
                StringBuilder startLog = new StringBuilder("========== \u8bf7\u6c42\u5f00\u59cb, method: " + method + ", Content-Type: " + request.getContentType() + ", uri: " + uri + "\n");
                startLog.append("----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n");
                startLog.append("target : ").append(pjp.getSignature().getDeclaringTypeName()).append("\n");
                startLog.append("-----> request: ").append(method).append("\n");
                Enumeration headers = request.getHeaderNames();
                if (headers.hasMoreElements()) {
                    startLog.append("      \u2516---- headers: \n");
                }
                while (headers.hasMoreElements()) {
                    String name = (String)headers.nextElement();
                    startLog.append("           - ").append(name).append("=").append(request.getHeader(name)).append("\n");
                }
                String queryString = request.getQueryString();
                if (!CommonTools.isNullStr((String)queryString)) {
                    startLog.append("      \u2516---- query string: \n").append("           - ").append(queryString).append("\n");
                }
                if ((params = request.getParameterNames()).hasMoreElements()) {
                    startLog.append("      \u2516---- parameter: \n");
                }
                while (params.hasMoreElements()) {
                    String name = (String)params.nextElement();
                    startLog.append("           - ").append(name).append("=").append(request.getParameter(name)).append("\n");
                }
                startLog.append("----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
                this.logAdapter.info(startLog.toString());
                this.logAdapter.info(">>>>>>>>>> \u5904\u7406\u5f00\u59cb...  [method: " + method + ", uri: " + uri + "]");
            }
            long processBegin = System.currentTimeMillis();
            response = pjp.proceed();
            if (!(response instanceof WebAsyncTask || response instanceof Callable || response instanceof DeferredResult)) {
                if (this.needLog(this.controllerLogConfiguration, uri)) {
                    this.logAdapter.info(">>>>>>>>>> \u5904\u7406\u7ed3\u675f! [method: " + method + ", uri: " + uri + ", \u5904\u7406\u8017\u65f6: " + (System.currentTimeMillis() - processBegin) + " \u6beb\u79d2]");
                    Object object = response;
                    if (object != null) {
                        Object object2;
                        Object $this$doAround_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1 = object2 = object;
                        boolean bl3 = false;
                        StringBuilder endLog = new StringBuilder("\n----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n");
                        endLog.append("-----> response: ").append($this$doAround_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.toString()).append("\n");
                        String responseInfo = null;
                        if ($this$doAround_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1 instanceof ResponseEntity) {
                            Object responseBody;
                            Object object3 = responseBody = ((ResponseEntity)$this$doAround_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1).getBody();
                            if (object3 != null) {
                                Object body = object3;
                                boolean bl4 = false;
                                responseInfo = body instanceof String ? (String)body : this.objectMapper.writeValueAsString(body);
                            }
                        } else {
                            responseInfo = this.objectMapper.writeValueAsString($this$doAround_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1);
                        }
                        endLog.append("      \u2516---- body: \n").append(responseInfo).append("\n");
                        endLog.append("----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
                        this.logAdapter.info(endLog.toString());
                    }
                    this.logAdapter.info("========== \u8bf7\u6c42\u7ed3\u675f! [method: " + method + ", uri: " + uri + ", \u603b\u8017\u65f6: " + (System.currentTimeMillis() - beginTime) + " \u6beb\u79d2]");
                }
            } else {
                this.logAdapter.info(">>>>>>>>>> \u8fdb\u884c\u5f02\u6b65\u5904\u7406...  [method: " + method + ", uri: " + uri + "]");
            }
        }
        return response;
    }

    private final boolean needLog(ControllerLogConfiguration controllerLogConfiguration, String uri) {
        if (controllerLogConfiguration.getEnabled()) {
            for (String regex : this.noLogUriRegular) {
                if (!HttpTools.isBeIdentifiedUri(uri, regex)) continue;
                return false;
            }
            List<String> noLogUriRegularConfig = controllerLogConfiguration.getNoLogUriRegular();
            for (String regex : noLogUriRegularConfig) {
                if (!HttpTools.isBeIdentifiedUri(uri, regex)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

