/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhangbinhub.acp.boot.socket.tcp;

import io.github.zhangbinhub.acp.boot.conf.SocketListenerConfiguration;
import io.github.zhangbinhub.acp.boot.interfaces.LogAdapter;
import io.github.zhangbinhub.acp.boot.socket.base.ISocketServerHandle;
import io.github.zhangbinhub.acp.boot.socket.base.SocketServerHandle;
import io.github.zhangbinhub.acp.core.CommonTools;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\"\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0011H\u0016\u00a8\u0006\u0018"}, d2={"Lio/github/zhangbinhub/acp/boot/socket/tcp/TcpServerHandle;", "Lio/github/zhangbinhub/acp/boot/socket/base/SocketServerHandle;", "logAdapter", "Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;", "socketListenerConfiguration", "Lio/github/zhangbinhub/acp/boot/conf/SocketListenerConfiguration;", "socketServerHandle", "Lio/github/zhangbinhub/acp/boot/socket/base/ISocketServerHandle;", "(Lio/github/zhangbinhub/acp/boot/interfaces/LogAdapter;Lio/github/zhangbinhub/acp/boot/conf/SocketListenerConfiguration;Lio/github/zhangbinhub/acp/boot/socket/base/ISocketServerHandle;)V", "afterReadMessage", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "afterSendMessage", "beforeReadMessage", "Lio/netty/buffer/ByteBuf;", "msg", "", "beforeSendMessage", "requestMsg", "sendStr", "", "userEventTriggered", "evt", "acp-spring-boot-starter"})
public final class TcpServerHandle
extends SocketServerHandle {
    public TcpServerHandle(@NotNull LogAdapter logAdapter, @NotNull SocketListenerConfiguration socketListenerConfiguration, @NotNull ISocketServerHandle socketServerHandle) {
        Intrinsics.checkNotNullParameter((Object)logAdapter, (String)"logAdapter");
        Intrinsics.checkNotNullParameter((Object)socketListenerConfiguration, (String)"socketListenerConfiguration");
        Intrinsics.checkNotNullParameter((Object)socketServerHandle, (String)"socketServerHandle");
        super(logAdapter, socketListenerConfiguration, socketServerHandle);
    }

    @Override
    @NotNull
    protected ByteBuf beforeReadMessage(@NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return (ByteBuf)msg;
    }

    @Override
    protected void afterSendMessage(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (!this.getSocketListenerConfiguration().getKeepAlive()) {
            ctx.close();
        }
    }

    @Override
    protected void afterReadMessage(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (!this.getSocketListenerConfiguration().getKeepAlive()) {
            ctx.close();
        }
    }

    @Override
    @NotNull
    protected Object beforeSendMessage(@NotNull ChannelHandlerContext ctx, @Nullable Object requestMsg, @NotNull String sendStr) throws Exception {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)sendStr, (String)"sendStr");
        ByteBufAllocator byteBufAllocator = ctx.alloc();
        CharBuffer charBuffer = CharBuffer.wrap(sendStr);
        Charset charset = Charset.forName(this.getSocketListenerConfiguration().getCharset());
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        ByteBuf byteBuf = ByteBufUtil.encodeString((ByteBufAllocator)byteBufAllocator, (CharBuffer)charBuffer, (Charset)charset);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"encodeString(ctx.alloc()\u2026erConfiguration.charset))");
        return byteBuf;
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) throws Exception {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        IdleStateEvent event = (IdleStateEvent)evt;
        String idleStr = this.getSocketServerHandle().userEventTriggered(event);
        if (!CommonTools.isNullStr((String)idleStr)) {
            String string = idleStr;
            Intrinsics.checkNotNull((Object)string);
            this.doResponse(ctx, null, string);
        }
    }
}

