/*
 * Decompiled with CFR 0.152.
 */
package com.youth.banner.transformer;

import android.view.View;
import androidx.annotation.NonNull;
import com.youth.banner.transformer.BasePageTransformer;

public class ScaleInTransformer
extends BasePageTransformer {
    private static final float DEFAULT_MIN_SCALE = 0.85f;
    private float mMinScale = 0.85f;

    public ScaleInTransformer() {
    }

    public ScaleInTransformer(float minScale) {
        this.mMinScale = minScale;
    }

    public void transformPage(@NonNull View view, float position) {
        int pageWidth = view.getWidth();
        int pageHeight = view.getHeight();
        view.setPivotY((float)(pageHeight / 2));
        view.setPivotX((float)(pageWidth / 2));
        if (position < -1.0f) {
            view.setScaleX(this.mMinScale);
            view.setScaleY(this.mMinScale);
            view.setPivotX((float)pageWidth);
        } else if (position <= 1.0f) {
            if (position < 0.0f) {
                float scaleFactor = (1.0f + position) * (1.0f - this.mMinScale) + this.mMinScale;
                view.setScaleX(scaleFactor);
                view.setScaleY(scaleFactor);
                view.setPivotX((float)pageWidth * (0.5f + 0.5f * -position));
            } else {
                float scaleFactor = (1.0f - position) * (1.0f - this.mMinScale) + this.mMinScale;
                view.setScaleX(scaleFactor);
                view.setScaleY(scaleFactor);
                view.setPivotX((float)pageWidth * ((1.0f - position) * 0.5f));
            }
        } else {
            view.setPivotX(0.0f);
            view.setScaleX(this.mMinScale);
            view.setScaleY(this.mMinScale);
        }
    }
}

