/*
 * Decompiled with CFR 0.152.
 */
package com.youth.banner.transformer;

import android.view.View;
import androidx.annotation.NonNull;
import com.youth.banner.transformer.BasePageTransformer;

public class AlphaPageTransformer
extends BasePageTransformer {
    private static final float DEFAULT_MIN_ALPHA = 0.5f;
    private float mMinAlpha = 0.5f;

    public AlphaPageTransformer() {
    }

    public AlphaPageTransformer(float minAlpha) {
        this.mMinAlpha = minAlpha;
    }

    public void transformPage(@NonNull View view, float position) {
        view.setScaleX(0.999f);
        if (position < -1.0f) {
            view.setAlpha(this.mMinAlpha);
        } else if (position <= 1.0f) {
            if (position < 0.0f) {
                float factor = this.mMinAlpha + (1.0f - this.mMinAlpha) * (1.0f + position);
                view.setAlpha(factor);
            } else {
                float factor = this.mMinAlpha + (1.0f - this.mMinAlpha) * (1.0f - position);
                view.setAlpha(factor);
            }
        } else {
            view.setAlpha(this.mMinAlpha);
        }
    }
}

