/*
 * Decompiled with CFR 0.152.
 */
package com.youth.banner.indicator;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.util.AttributeSet;
import androidx.annotation.DrawableRes;
import com.youth.banner.R;
import com.youth.banner.indicator.BaseIndicator;

public class DrawableIndicator
extends BaseIndicator {
    private Bitmap normalBitmap;
    private Bitmap selectedBitmap;

    public DrawableIndicator(Context context, @DrawableRes int normalResId, @DrawableRes int selectedResId) {
        super(context);
        this.normalBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)normalResId);
        this.selectedBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)selectedResId);
    }

    public DrawableIndicator(Context context) {
        this(context, null);
    }

    public DrawableIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DrawableIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DrawableIndicator);
        if (a != null) {
            BitmapDrawable normal = (BitmapDrawable)a.getDrawable(R.styleable.DrawableIndicator_normal_drawable);
            BitmapDrawable selected = (BitmapDrawable)a.getDrawable(R.styleable.DrawableIndicator_selected_drawable);
            this.normalBitmap = normal.getBitmap();
            this.selectedBitmap = selected.getBitmap();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int count = this.config.getIndicatorSize();
        if (count <= 1) {
            return;
        }
        this.setMeasuredDimension(this.selectedBitmap.getWidth() * (count - 1) + this.selectedBitmap.getWidth() + this.config.getIndicatorSpace() * (count - 1), Math.max(this.normalBitmap.getHeight(), this.selectedBitmap.getHeight()));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int count = this.config.getIndicatorSize();
        if (count <= 1 || this.normalBitmap == null || this.selectedBitmap == null) {
            return;
        }
        float left = 0.0f;
        for (int i = 0; i < count; ++i) {
            canvas.drawBitmap(this.config.getCurrentPosition() == i ? this.selectedBitmap : this.normalBitmap, left, 0.0f, this.mPaint);
            left += (float)(this.normalBitmap.getWidth() + this.config.getIndicatorSpace());
        }
    }
}

