/*
 * Decompiled with CFR 0.152.
 */
package io.github.yavski.fabspeeddial;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.design.internal.NavigationMenu;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorListenerAdapter;
import android.support.v4.view.animation.FastOutLinearInInterpolator;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.support.v7.view.SupportMenuInflater;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.widget.CardView;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.github.yavski.fabmenu.R;
import io.github.yavski.fabspeeddial.FabSpeedDialBehaviour;
import java.util.HashMap;
import java.util.Map;

@CoordinatorLayout.DefaultBehavior(value=FabSpeedDialBehaviour.class)
public class FabSpeedDial
extends LinearLayout
implements View.OnClickListener {
    private static final String TAG = FabSpeedDial.class.getSimpleName();
    private static final int VSYNC_RHYTHM = 16;
    public static final FastOutSlowInInterpolator FAST_OUT_SLOW_IN_INTERPOLATOR = new FastOutSlowInInterpolator();
    public static final int BOTTOM_END = 0;
    public static final int BOTTOM_START = 1;
    public static final int TOP_END = 2;
    public static final int TOP_START = 3;
    private static final int DEFAULT_MENU_POSITION = 0;
    private MenuListener menuListener;
    private NavigationMenu navigationMenu;
    private Map<FloatingActionButton, MenuItem> fabMenuItemMap;
    private Map<CardView, MenuItem> cardViewMenuItemMap;
    private LinearLayout menuItemsLayout;
    FloatingActionButton fab;
    private View touchGuard = null;
    private int menuId;
    private int fabGravity;
    private Drawable fabDrawable;
    private ColorStateList fabDrawableTint;
    private ColorStateList fabBackgroundTint;
    private ColorStateList miniFabDrawableTint;
    private ColorStateList miniFabBackgroundTint;
    private int[] miniFabBackgroundTintArray;
    private ColorStateList miniFabTitleBackgroundTint;
    private boolean miniFabTitlesEnabled;
    private int miniFabTitleTextColor;
    private int[] miniFabTitleTextColorArray;
    private Drawable touchGuardDrawable;
    private boolean useTouchGuard;
    private boolean isAnimating;
    private boolean shouldOpenMenu;

    private FabSpeedDial(Context context) {
        super(context);
    }

    public FabSpeedDial(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    @TargetApi(value=11)
    public FabSpeedDial(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FabSpeedDial, 0, 0);
        this.resolveCompulsoryAttributes(typedArray);
        this.resolveOptionalAttributes(typedArray);
        typedArray.recycle();
        if (this.isGravityBottom()) {
            LayoutInflater.from((Context)context).inflate(R.layout.fab_speed_dial_bottom, (ViewGroup)this, true);
        } else {
            LayoutInflater.from((Context)context).inflate(R.layout.fab_speed_dial_top, (ViewGroup)this, true);
        }
        if (this.isGravityEnd()) {
            this.setGravity(0x800005);
        }
        this.menuItemsLayout = (LinearLayout)this.findViewById(R.id.menu_items_layout);
        this.setOrientation(1);
        this.newNavigationMenu();
        int menuItemCount = this.navigationMenu.size();
        this.fabMenuItemMap = new HashMap<FloatingActionButton, MenuItem>(menuItemCount);
        this.cardViewMenuItemMap = new HashMap<CardView, MenuItem>(menuItemCount);
    }

    private void resolveCompulsoryAttributes(TypedArray typedArray) {
        if (!typedArray.hasValue(R.styleable.FabSpeedDial_fabMenu)) {
            throw new AndroidRuntimeException("You must provide the id of the menu resource.");
        }
        this.menuId = typedArray.getResourceId(R.styleable.FabSpeedDial_fabMenu, 0);
        if (!typedArray.hasValue(R.styleable.FabSpeedDial_fabGravity)) {
            throw new AndroidRuntimeException("You must specify the gravity of the Fab.");
        }
        this.fabGravity = typedArray.getInt(R.styleable.FabSpeedDial_fabGravity, 0);
    }

    private void resolveOptionalAttributes(TypedArray typedArray) {
        int i;
        this.fabDrawable = typedArray.getDrawable(R.styleable.FabSpeedDial_fabDrawable);
        if (this.fabDrawable == null) {
            this.fabDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.fab_add_clear_selector);
        }
        this.fabDrawableTint = typedArray.getColorStateList(R.styleable.FabSpeedDial_fabDrawableTint);
        if (this.fabDrawableTint == null) {
            this.fabDrawableTint = this.getColorStateList(R.color.fab_drawable_tint);
        }
        if (typedArray.hasValue(R.styleable.FabSpeedDial_fabBackgroundTint)) {
            this.fabBackgroundTint = typedArray.getColorStateList(R.styleable.FabSpeedDial_fabBackgroundTint);
        }
        this.miniFabBackgroundTint = typedArray.getColorStateList(R.styleable.FabSpeedDial_miniFabBackgroundTint);
        if (this.miniFabBackgroundTint == null) {
            this.miniFabBackgroundTint = this.getColorStateList(R.color.fab_background_tint);
        }
        if (typedArray.hasValue(R.styleable.FabSpeedDial_miniFabBackgroundTintList)) {
            int miniFabBackgroundTintListId = typedArray.getResourceId(R.styleable.FabSpeedDial_miniFabBackgroundTintList, 0);
            TypedArray miniFabBackgroundTintRes = this.getResources().obtainTypedArray(miniFabBackgroundTintListId);
            this.miniFabBackgroundTintArray = new int[miniFabBackgroundTintRes.length()];
            for (i = 0; i < miniFabBackgroundTintRes.length(); ++i) {
                this.miniFabBackgroundTintArray[i] = miniFabBackgroundTintRes.getResourceId(i, 0);
            }
            miniFabBackgroundTintRes.recycle();
        }
        this.miniFabDrawableTint = typedArray.getColorStateList(R.styleable.FabSpeedDial_miniFabDrawableTint);
        if (this.miniFabDrawableTint == null) {
            this.miniFabDrawableTint = this.getColorStateList(R.color.mini_fab_drawable_tint);
        }
        this.miniFabTitleBackgroundTint = typedArray.getColorStateList(R.styleable.FabSpeedDial_miniFabTitleBackgroundTint);
        if (this.miniFabTitleBackgroundTint == null) {
            this.miniFabTitleBackgroundTint = this.getColorStateList(R.color.mini_fab_title_background_tint);
        }
        this.miniFabTitlesEnabled = typedArray.getBoolean(R.styleable.FabSpeedDial_miniFabTitlesEnabled, true);
        this.miniFabTitleTextColor = typedArray.getColor(R.styleable.FabSpeedDial_miniFabTitleTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.title_text_color));
        if (typedArray.hasValue(R.styleable.FabSpeedDial_miniFabTitleTextColorList)) {
            int miniFabTitleTextColorListId = typedArray.getResourceId(R.styleable.FabSpeedDial_miniFabTitleTextColorList, 0);
            TypedArray miniFabTitleTextColorTa = this.getResources().obtainTypedArray(miniFabTitleTextColorListId);
            this.miniFabTitleTextColorArray = new int[miniFabTitleTextColorTa.length()];
            for (i = 0; i < miniFabTitleTextColorTa.length(); ++i) {
                this.miniFabTitleTextColorArray[i] = miniFabTitleTextColorTa.getResourceId(i, 0);
            }
            miniFabTitleTextColorTa.recycle();
        }
        this.touchGuardDrawable = typedArray.getDrawable(R.styleable.FabSpeedDial_touchGuardDrawable);
        this.useTouchGuard = typedArray.getBoolean(R.styleable.FabSpeedDial_touchGuard, true);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        int coordinatorLayoutOffset = this.getResources().getDimensionPixelSize(R.dimen.coordinator_layout_offset);
        if (this.fabGravity == 0 || this.fabGravity == 2) {
            layoutParams.setMargins(0, 0, coordinatorLayoutOffset, 0);
        } else {
            layoutParams.setMargins(coordinatorLayoutOffset, 0, 0, 0);
        }
        this.menuItemsLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.fab = (FloatingActionButton)this.findViewById(R.id.fab);
        this.fab.setImageDrawable(this.fabDrawable);
        if (Build.VERSION.SDK_INT >= 21) {
            this.fab.setImageTintList(this.fabDrawableTint);
        }
        if (this.fabBackgroundTint != null) {
            this.fab.setBackgroundTintList(this.fabBackgroundTint);
        }
        this.fab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FabSpeedDial.this.isAnimating) {
                    return;
                }
                if (FabSpeedDial.this.isMenuOpen()) {
                    FabSpeedDial.this.closeMenu();
                } else {
                    FabSpeedDial.this.openMenu();
                }
            }
        });
        this.setFocusableInTouchMode(true);
        if (this.useTouchGuard) {
            ViewParent parent = this.getParent();
            this.touchGuard = new View(this.getContext());
            this.touchGuard.setOnClickListener((View.OnClickListener)this);
            this.touchGuard.setWillNotDraw(true);
            this.touchGuard.setVisibility(8);
            if (this.touchGuardDrawable != null) {
                if (Build.VERSION.SDK_INT >= 16) {
                    this.touchGuard.setBackground(this.touchGuardDrawable);
                } else {
                    this.touchGuard.setBackgroundDrawable(this.touchGuardDrawable);
                }
            }
            if (parent instanceof FrameLayout) {
                FrameLayout frameLayout = (FrameLayout)parent;
                frameLayout.addView(this.touchGuard, frameLayout.indexOfChild((View)this));
            } else if (parent instanceof CoordinatorLayout) {
                CoordinatorLayout coordinatorLayout = (CoordinatorLayout)parent;
                coordinatorLayout.addView(this.touchGuard, coordinatorLayout.indexOfChild((View)this));
            } else if (parent instanceof RelativeLayout) {
                ((RelativeLayout)parent).addView(this.touchGuard, ((RelativeLayout)parent).indexOfChild((View)this), (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
            } else {
                Log.d((String)TAG, (String)"touchGuard requires that the parent of this FabSpeedDialer be a FrameLayout or RelativeLayout");
            }
        }
        this.setOnClickListener(this);
        if (this.shouldOpenMenu) {
            this.openMenu();
        }
    }

    private void newNavigationMenu() {
        this.navigationMenu = new NavigationMenu(this.getContext());
        new SupportMenuInflater(this.getContext()).inflate(this.menuId, (Menu)this.navigationMenu);
        this.navigationMenu.setCallback(new MenuBuilder.Callback(){

            public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
                return FabSpeedDial.this.menuListener != null && FabSpeedDial.this.menuListener.onMenuItemSelected(item);
            }

            public void onMenuModeChange(MenuBuilder menu) {
            }
        });
    }

    public void onClick(View v) {
        this.fab.setSelected(false);
        this.removeFabMenuItems();
        if (this.menuListener != null) {
            if (v == this || v == this.touchGuard) {
                this.menuListener.onMenuClosed();
            } else if (v instanceof FloatingActionButton) {
                this.menuListener.onMenuItemSelected(this.fabMenuItemMap.get(v));
            } else if (v instanceof CardView) {
                this.menuListener.onMenuItemSelected(this.cardViewMenuItemMap.get(v));
            }
        } else {
            Log.d((String)TAG, (String)"You haven't provided a MenuListener.");
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.isShowingMenu = this.isMenuOpen();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.shouldOpenMenu = ss.isShowingMenu;
    }

    public void setMenuListener(MenuListener menuListener) {
        this.menuListener = menuListener;
    }

    public boolean isMenuOpen() {
        return this.menuItemsLayout.getChildCount() > 0;
    }

    public void openMenu() {
        if (!ViewCompat.isAttachedToWindow((View)this)) {
            return;
        }
        this.requestFocus();
        boolean showMenu = true;
        if (this.menuListener != null) {
            this.newNavigationMenu();
            showMenu = this.menuListener.onPrepareMenu(this.navigationMenu);
        }
        if (showMenu) {
            this.addMenuItems();
            this.fab.setSelected(true);
        } else {
            this.fab.setSelected(false);
        }
    }

    public void closeMenu() {
        if (!ViewCompat.isAttachedToWindow((View)this)) {
            return;
        }
        if (this.isMenuOpen()) {
            this.fab.setSelected(false);
            this.removeFabMenuItems();
            if (this.menuListener != null) {
                this.menuListener.onMenuClosed();
            }
        }
    }

    public void show() {
        if (!ViewCompat.isAttachedToWindow((View)this)) {
            return;
        }
        this.setVisibility(0);
        this.fab.show();
    }

    public void hide() {
        if (!ViewCompat.isAttachedToWindow((View)this)) {
            return;
        }
        if (this.isMenuOpen()) {
            this.closeMenu();
        }
        this.fab.hide();
    }

    private void addMenuItems() {
        ViewCompat.setAlpha((View)this.menuItemsLayout, (float)1.0f);
        for (int i = 0; i < this.navigationMenu.size(); ++i) {
            MenuItem menuItem = this.navigationMenu.getItem(i);
            if (!menuItem.isVisible()) continue;
            this.menuItemsLayout.addView(this.createFabMenuItem(menuItem));
        }
        this.animateFabMenuItemsIn();
    }

    private View createFabMenuItem(MenuItem menuItem) {
        ViewGroup fabMenuItem = (ViewGroup)LayoutInflater.from((Context)this.getContext()).inflate(this.getMenuItemLayoutId(), (ViewGroup)this, false);
        FloatingActionButton miniFab = (FloatingActionButton)fabMenuItem.findViewById(R.id.mini_fab);
        CardView cardView = (CardView)fabMenuItem.findViewById(R.id.card_view);
        TextView titleView = (TextView)fabMenuItem.findViewById(R.id.title_view);
        this.fabMenuItemMap.put(miniFab, menuItem);
        this.cardViewMenuItemMap.put(cardView, menuItem);
        miniFab.setImageDrawable(menuItem.getIcon());
        miniFab.setOnClickListener((View.OnClickListener)this);
        cardView.setOnClickListener((View.OnClickListener)this);
        ViewCompat.setAlpha((View)miniFab, (float)0.0f);
        ViewCompat.setAlpha((View)cardView, (float)0.0f);
        CharSequence title = menuItem.getTitle();
        if (!TextUtils.isEmpty((CharSequence)title) && this.miniFabTitlesEnabled) {
            cardView.setCardBackgroundColor(this.miniFabTitleBackgroundTint.getDefaultColor());
            titleView.setText(title);
            titleView.setTypeface(null, 1);
            titleView.setTextColor(this.miniFabTitleTextColor);
            if (this.miniFabTitleTextColorArray != null) {
                titleView.setTextColor(ContextCompat.getColorStateList((Context)this.getContext(), (int)this.miniFabTitleTextColorArray[menuItem.getOrder()]));
            }
        } else {
            fabMenuItem.removeView((View)cardView);
        }
        miniFab.setBackgroundTintList(this.miniFabBackgroundTint);
        if (this.miniFabBackgroundTintArray != null) {
            miniFab.setBackgroundTintList(ContextCompat.getColorStateList((Context)this.getContext(), (int)this.miniFabBackgroundTintArray[menuItem.getOrder()]));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            miniFab.setImageTintList(this.miniFabDrawableTint);
        }
        return fabMenuItem;
    }

    private void removeFabMenuItems() {
        if (this.touchGuard != null) {
            this.touchGuard.setVisibility(8);
        }
        ViewCompat.animate((View)this.menuItemsLayout).setDuration((long)this.getResources().getInteger(0x10E0000)).alpha(0.0f).setInterpolator((Interpolator)new FastOutLinearInInterpolator()).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationStart(View view) {
                super.onAnimationStart(view);
                FabSpeedDial.this.isAnimating = true;
            }

            public void onAnimationEnd(View view) {
                super.onAnimationEnd(view);
                FabSpeedDial.this.menuItemsLayout.removeAllViews();
                FabSpeedDial.this.isAnimating = false;
            }
        }).start();
    }

    private void animateFabMenuItemsIn() {
        if (this.touchGuard != null) {
            this.touchGuard.setVisibility(0);
        }
        int count = this.menuItemsLayout.getChildCount();
        if (this.isGravityBottom()) {
            for (int i = count - 1; i >= 0; --i) {
                View fabMenuItem = this.menuItemsLayout.getChildAt(i);
                this.animateViewIn(fabMenuItem.findViewById(R.id.mini_fab), Math.abs(count - 1 - i));
                View cardView = fabMenuItem.findViewById(R.id.card_view);
                if (cardView == null) continue;
                this.animateViewIn(cardView, Math.abs(count - 1 - i));
            }
        } else {
            for (int i = 0; i < count; ++i) {
                View fabMenuItem = this.menuItemsLayout.getChildAt(i);
                this.animateViewIn(fabMenuItem.findViewById(R.id.mini_fab), i);
                View cardView = fabMenuItem.findViewById(R.id.card_view);
                if (cardView == null) continue;
                this.animateViewIn(cardView, i);
            }
        }
    }

    private void animateViewIn(View view, int position) {
        float offsetY = this.getResources().getDimensionPixelSize(R.dimen.keyline_1);
        ViewCompat.setScaleX((View)view, (float)0.25f);
        ViewCompat.setScaleY((View)view, (float)0.25f);
        ViewCompat.setY((View)view, (float)(ViewCompat.getY((View)view) + offsetY));
        ViewCompat.animate((View)view).setDuration((long)this.getResources().getInteger(0x10E0000)).scaleX(1.0f).scaleY(1.0f).translationYBy(-offsetY).alpha(1.0f).setStartDelay((long)(4 * position * 16)).setInterpolator((Interpolator)new FastOutSlowInInterpolator()).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationStart(View view) {
                super.onAnimationStart(view);
                FabSpeedDial.this.isAnimating = true;
            }

            public void onAnimationEnd(View view) {
                super.onAnimationEnd(view);
                FabSpeedDial.this.isAnimating = false;
            }
        }).start();
    }

    private int getMenuItemLayoutId() {
        if (this.isGravityEnd()) {
            return R.layout.fab_menu_item_end;
        }
        return R.layout.fab_menu_item_start;
    }

    private boolean isGravityBottom() {
        return this.fabGravity == 0 || this.fabGravity == 1;
    }

    private boolean isGravityEnd() {
        return this.fabGravity == 0 || this.fabGravity == 2;
    }

    private ColorStateList getColorStateList(int colorRes) {
        int[][] states = new int[][]{{16842910}, {-16842910}, {-16842912}, {16842919}};
        int color2 = ContextCompat.getColor((Context)this.getContext(), (int)colorRes);
        int[] colors = new int[]{color2, color2, color2, color2};
        return new ColorStateList((int[][])states, colors);
    }

    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        if (this.isMenuOpen() && event.getKeyCode() == 4 && event.getAction() == 1 && event.getRepeatCount() == 0) {
            this.closeMenu();
            return true;
        }
        return super.dispatchKeyEventPreIme(event);
    }

    static class SavedState
    extends View.BaseSavedState {
        boolean isShowingMenu;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int i) {
                return new SavedState[i];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.isShowingMenu = source.readInt() == 1;
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.isShowingMenu ? 1 : 0);
        }
    }

    public static interface MenuListener {
        public boolean onPrepareMenu(NavigationMenu var1);

        public boolean onMenuItemSelected(MenuItem var1);

        public void onMenuClosed();
    }
}

