/*
 * Decompiled with CFR 0.152.
 */
package io.github.yavski.fabspeeddial;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import io.github.yavski.fabspeeddial.FabSpeedDial;
import io.github.yavski.fabspeeddial.ViewGroupUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class FabSpeedDialBehaviour
extends CoordinatorLayout.Behavior<FabSpeedDial> {
    private static final boolean SNACKBAR_BEHAVIOR_ENABLED = Build.VERSION.SDK_INT >= 11;
    private ViewPropertyAnimatorCompat mFabTranslationYAnimator;
    private float mFabTranslationY;
    private Rect mTmpRect;

    public FabSpeedDialBehaviour(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, FabSpeedDial child, View dependency) {
        return SNACKBAR_BEHAVIOR_ENABLED && dependency instanceof Snackbar.SnackbarLayout;
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, FabSpeedDial child, View dependency) {
        if (dependency instanceof Snackbar.SnackbarLayout) {
            this.updateFabTranslationForSnackbar(parent, child, dependency);
        } else if (dependency instanceof AppBarLayout) {
            this.updateFabVisibility(parent, (AppBarLayout)dependency, child);
        }
        return false;
    }

    private void updateFabTranslationForSnackbar(CoordinatorLayout parent, FabSpeedDial fab, View snackbar) {
        if (fab.getVisibility() != 0) {
            return;
        }
        float targetTransY = this.getFabTranslationYForSnackbar(parent, fab);
        if (this.mFabTranslationY == targetTransY) {
            return;
        }
        float currentTransY = ViewCompat.getTranslationY((View)fab);
        if (this.mFabTranslationYAnimator != null) {
            this.mFabTranslationYAnimator.cancel();
        }
        if (Math.abs(currentTransY - targetTransY) > (float)fab.getHeight() * 0.667f) {
            this.mFabTranslationYAnimator = ViewCompat.animate((View)fab).setInterpolator((Interpolator)FabSpeedDial.FAST_OUT_SLOW_IN_INTERPOLATOR).translationY(targetTransY);
            this.mFabTranslationYAnimator.start();
        } else {
            ViewCompat.setTranslationY((View)fab, (float)targetTransY);
        }
        this.mFabTranslationY = targetTransY;
    }

    private float getFabTranslationYForSnackbar(CoordinatorLayout parent, FabSpeedDial fab) {
        float minOffset = 0.0f;
        List dependencies = parent.getDependencies((View)fab);
        int z = dependencies.size();
        for (int i = 0; i < z; ++i) {
            View view = (View)dependencies.get(i);
            if (!(view instanceof Snackbar.SnackbarLayout) || !parent.doViewsOverlap((View)fab, view)) continue;
            minOffset = Math.min(minOffset, ViewCompat.getTranslationY((View)view) - (float)view.getHeight());
        }
        return minOffset;
    }

    public boolean onLayoutChild(CoordinatorLayout parent, FabSpeedDial child, int layoutDirection) {
        View dependency;
        List dependencies = parent.getDependencies((View)child);
        int count = dependencies.size();
        for (int i = 0; !(i >= count || (dependency = (View)dependencies.get(i)) instanceof AppBarLayout && this.updateFabVisibility(parent, (AppBarLayout)dependency, child)); ++i) {
        }
        parent.onLayoutChild((View)child, layoutDirection);
        return true;
    }

    private boolean updateFabVisibility(CoordinatorLayout parent, AppBarLayout appBarLayout, FabSpeedDial child) {
        CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
        if (lp.getAnchorId() != appBarLayout.getId()) {
            return false;
        }
        if (this.mTmpRect == null) {
            this.mTmpRect = new Rect();
        }
        Rect rect = this.mTmpRect;
        ViewGroupUtils.getDescendantRect((ViewGroup)parent, (View)appBarLayout, rect);
        int minimumHeightForVisibleOverlappingContent = this.getMinimumHeightForVisibleOverlappingContent(appBarLayout);
        if (minimumHeightForVisibleOverlappingContent == -1) {
            return true;
        }
        if (rect.bottom <= minimumHeightForVisibleOverlappingContent) {
            // empty if block
        }
        return true;
    }

    private int getMinimumHeightForVisibleOverlappingContent(AppBarLayout appBarLayout) {
        try {
            Method method = appBarLayout.getClass().getDeclaredMethod("getMinimumHeightForVisibleOverlappingContent", new Class[0]);
            method.setAccessible(true);
            Object value = method.invoke((Object)appBarLayout, null);
            return (Integer)value;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return -1;
    }
}

