/*
 * Decompiled with CFR 0.152.
 */
package io.github.yangziwen.jacoco.maven;

import io.github.yangziwen.diff.calculate.BlameCalculator;
import io.github.yangziwen.diff.calculate.DiffCalculator;
import io.github.yangziwen.diff.calculate.DiffEntryWrapper;
import io.github.yangziwen.diff.calculate.MergeBaseCalculator;
import io.github.yangziwen.jacoco.filter.DiffFilter;
import io.github.yangziwen.jacoco.filter.PersonFilter;
import io.github.yangziwen.jacoco.util.CollectionUtil;
import io.github.yangziwen.jacoco.util.FilterUtil;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jacoco.maven.AgentMojo;

@Mojo(name="prepare-agent", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class DiffAgentMojo
extends AgentMojo {
    private static final AtomicBoolean DIFF_FILTER_INJECTED = new AtomicBoolean(false);
    private static final String REF_HEAD = "HEAD";
    @Parameter(property="jacoco.diff.oldrev", defaultValue="")
    private String oldRev;
    @Parameter(property="jacoco.diff.newrev", defaultValue="")
    private String newRev;
    @Parameter(property="jacoco.diff.against", defaultValue="")
    private String againstRef;
    @Parameter(property="jacoco.author.name", defaultValue="")
    private String authorName;
    @Parameter(property="jacoco.author.email", defaultValue="")
    private String authorEmail;
    @Parameter(property="jacoco.committer.name", defaultValue="")
    private String committerName;
    @Parameter(property="jacoco.committer.email", defaultValue="")
    private String committerEmail;

    public void executeMojo() {
        try {
            if (StringUtils.isNotBlank((String)this.oldRev) && StringUtils.isNotBlank((String)this.newRev) || StringUtils.isNotBlank((String)this.againstRef)) {
                this.injectDiffFilter();
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("failed to inject diff filter for old rev [" + this.oldRev + "] and new rev [" + this.newRev + "]"));
        }
        super.executeMojo();
    }

    private void injectDiffFilter() throws Exception {
        if (DIFF_FILTER_INJECTED.getAndSet(true)) {
            return;
        }
        File baseDir = this.getProject().getBasedir();
        File gitDir = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(baseDir)).getGitDir();
        gitDir = new File(gitDir.getAbsolutePath().replaceAll("\\.git$", ""));
        if (StringUtils.isNotBlank((String)this.againstRef)) {
            this.oldRev = this.calculateMergeBase(gitDir, this.againstRef, REF_HEAD);
            this.newRev = REF_HEAD;
        }
        DiffCalculator calculator = DiffCalculator.builder().diffAlgorithm((DiffAlgorithm)new HistogramDiff()).build();
        List<DiffEntryWrapper> diffEntryList = calculator.calculateDiff(gitDir, this.oldRev, this.newRev, false).stream().filter(diffEntry -> !diffEntry.isDeleted()).collect(Collectors.toList());
        DiffFilter diffFilter = new DiffFilter(this.getProject(), gitDir, diffEntryList);
        FilterUtil.appendFilter(diffFilter);
        if (CollectionUtil.isEmpty(diffEntryList)) {
            return;
        }
        if (this.needAuthorFilter() || this.needCommitterFilter()) {
            List filePathList = diffEntryList.stream().map(DiffEntryWrapper::getNewPath).collect(Collectors.toList());
            List blameResults = BlameCalculator.builder().build().calculate(gitDir, filePathList, this.newRev);
            if (this.needAuthorFilter()) {
                PersonFilter.PersonInfo author = new PersonFilter.PersonInfo(this.authorName, this.authorEmail, PersonFilter.PersonType.AUTHOR);
                PersonFilter authorFilter = new PersonFilter(this.getProject(), gitDir, author, blameResults);
                FilterUtil.appendFilter(authorFilter);
            }
            if (this.needCommitterFilter()) {
                PersonFilter.PersonInfo committer = new PersonFilter.PersonInfo(this.committerName, this.committerEmail, PersonFilter.PersonType.COMMITTER);
                PersonFilter committerFilter = new PersonFilter(this.getProject(), gitDir, committer, blameResults);
                FilterUtil.appendFilter(committerFilter);
            }
        }
    }

    private String calculateMergeBase(File gitDir, String ref1, String ref2) throws Exception {
        try {
            return new MergeBaseCalculator().calculateMergeBase(gitDir, ref1, ref2);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("failed to find the merge base between [" + ref1 + "] and [" + ref2 + "]"));
            throw e;
        }
    }

    private boolean needAuthorFilter() {
        return StringUtils.isNotBlank((String)this.authorName) || StringUtils.isNotBlank((String)this.authorEmail);
    }

    private boolean needCommitterFilter() {
        return StringUtils.isNotBlank((String)this.committerName) || StringUtils.isNotBlank((String)this.committerEmail);
    }
}

