/*
 * Decompiled with CFR 0.152.
 */
package io.github.yangziwen.jacoco.filter;

import io.github.yangziwen.jacoco.util.CollectionUtil;
import io.github.yangziwen.jacoco.util.FilterUtil;
import io.github.yangziwen.jacoco.util.LineNumberNodeWrapper;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.lib.PersonIdent;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class PersonFilter
implements IFilter {
    private static final String SOURCE_PATH_PREFIX = "/src/main/java/";
    private Map<String, BlameResult> classPathBlameResultMap = new HashMap<String, BlameResult>();
    private PersonInfo personInfo;

    public PersonFilter(MavenProject project, File gitDir, PersonInfo personInfo, List<BlameResult> blameResults) {
        List modules = project.getModules();
        if (project.getParent() != null && CollectionUtil.isNotEmpty(project.getParent().getModules())) {
            modules.addAll(project.getParent().getModules());
        }
        for (BlameResult blameResult : blameResults) {
            String name = blameResult.getResultPath();
            if (CollectionUtil.isNotEmpty(modules)) {
                for (String module : modules) {
                    if (!name.startsWith(module)) continue;
                    name = StringUtils.replaceOnce((String)name, (String)module, (String)"");
                    break;
                }
            }
            if (!name.startsWith(SOURCE_PATH_PREFIX)) continue;
            name = StringUtils.replaceOnce((String)name, (String)SOURCE_PATH_PREFIX, (String)"");
            this.classPathBlameResultMap.put(name, blameResult);
        }
        this.personInfo = personInfo;
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (this.personInfo == null) {
            return;
        }
        String classPath = FilterUtil.getClassPath(context);
        InsnList instructions = methodNode.instructions;
        BlameResult blameResult = this.classPathBlameResultMap.get(classPath);
        if (blameResult == null) {
            output.ignore(instructions.getFirst(), instructions.getLast());
            return;
        }
        List<LineNumberNodeWrapper> nodeWrapperList = FilterUtil.collectLineNumberNodeList(instructions);
        for (LineNumberNodeWrapper nodeWrapper : nodeWrapperList) {
            int line = nodeWrapper.getLine() - 1;
            PersonIdent person = this.personInfo.getType().getPerson(blameResult, line);
            if (!this.personInfo.accept(person)) continue;
            nodeWrapper.setIgnored(false);
        }
        for (LineNumberNodeWrapper nodeWrapper : nodeWrapperList) {
            if (!nodeWrapper.isIgnored()) continue;
            output.ignore((AbstractInsnNode)nodeWrapper.getNode(), nodeWrapper.getNext());
        }
    }

    public static enum PersonType {
        AUTHOR{

            @Override
            public PersonIdent getPerson(BlameResult blameResult, int line) {
                return blameResult.getSourceAuthor(line);
            }
        }
        ,
        COMMITTER{

            @Override
            public PersonIdent getPerson(BlameResult blameResult, int line) {
                return blameResult.getSourceCommitter(line);
            }
        };


        public abstract PersonIdent getPerson(BlameResult var1, int var2);
    }

    public static class PersonInfo {
        private String name;
        private String email;
        private PersonType type;

        public PersonInfo(String name, String email, PersonType type) {
            this.name = name;
            this.email = email;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }

        public PersonType getType() {
            return this.type;
        }

        public boolean accept(PersonIdent person) {
            if (person == null) {
                return false;
            }
            if (StringUtils.isNotBlank((String)this.name) && !this.name.equals(person.getName())) {
                return false;
            }
            return !StringUtils.isNotBlank((String)this.email) || this.email.equals(person.getEmailAddress());
        }
    }
}

