/*
 * Decompiled with CFR 0.152.
 */
package io.github.xyzxqs.libs.xtask;

import android.support.annotation.NonNull;
import io.github.xyzxqs.libs.xtask.Result;
import io.github.xyzxqs.libs.xtask.Xtask;
import io.github.xyzxqs.libs.xtask.XtaskStage;
import io.github.xyzxqs.libs.xtask.func.Action;
import io.github.xyzxqs.libs.xtask.func.BiConsumer;
import io.github.xyzxqs.libs.xtask.func.BiFunction;
import io.github.xyzxqs.libs.xtask.func.Consumer;
import io.github.xyzxqs.libs.xtask.func.Function;
import io.github.xyzxqs.libs.xtask.func.Supplier;
import java.util.concurrent.Executor;

class XtaskStageImpl<T>
implements XtaskStage<T> {
    private final Xtask<T> thisXtask;

    public XtaskStageImpl(Xtask<T> thisXtask) {
        this.thisXtask = thisXtask;
    }

    @Override
    public <U> Xtask<U> thenApplyAsync(@NonNull Function<Result<T>, U> fn) {
        return this.thenApplyAsync(fn, Xtask.ASYNC_POOL);
    }

    @Override
    public <U> Xtask<U> thenApplyAsync(final @NonNull Function<Result<T>, U> fn, final @NonNull Executor exec) {
        final Xtask xtask = new Xtask();
        this.thisXtask.onResult(new Consumer<Result<T>>(){

            @Override
            public void accept(final Result<T> result) throws Exception {
                xtask.worker = Xtask.WORKER_FACTORY.createWorker().supplyAsync(new Supplier<U>(){

                    @Override
                    public U get() throws Exception {
                        return fn.apply(result);
                    }
                }).onResult(new Consumer<Result<U>>(){

                    @Override
                    public void accept(Result<U> uResult) throws Exception {
                        xtask.result(uResult);
                    }
                });
                xtask.execute(Xtask.screenExecutor(exec));
            }
        }).ifCanceled(new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        });
        return xtask;
    }

    @Override
    public Xtask<Void> thenAcceptAsync(@NonNull Consumer<Result<T>> action) {
        return this.thenAcceptAsync(action, Xtask.ASYNC_POOL);
    }

    @Override
    public Xtask<Void> thenAcceptAsync(final @NonNull Consumer<Result<T>> action, final @NonNull Executor exec) {
        final Xtask<Void> xtask = new Xtask<Void>();
        this.thisXtask.onResult(new Consumer<Result<T>>(){

            @Override
            public void accept(final Result<T> result) throws Exception {
                xtask.worker = Xtask.WORKER_FACTORY.createWorker().supplyAsync(new Supplier<Void>(){

                    @Override
                    public Void get() throws Exception {
                        action.accept(result);
                        return null;
                    }
                }).onResult(new Consumer<Result<Void>>(){

                    @Override
                    public void accept(Result<Void> uResult) throws Exception {
                        xtask.result(uResult);
                    }
                });
                xtask.execute(Xtask.screenExecutor(exec));
            }
        }).ifCanceled(new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        });
        return xtask;
    }

    @Override
    public Xtask<Void> thenRunAsync(@NonNull Action action) {
        return this.thenRunAsync(action, Xtask.ASYNC_POOL);
    }

    @Override
    public Xtask<Void> thenRunAsync(final @NonNull Action action, final @NonNull Executor exec) {
        final Xtask<Void> xtask = new Xtask<Void>();
        this.thisXtask.onResult(new Consumer<Result<T>>(){

            @Override
            public void accept(Result<T> result) throws Exception {
                xtask.worker = Xtask.WORKER_FACTORY.createWorker().supplyAsync(new Supplier<Void>(){

                    @Override
                    public Void get() throws Exception {
                        action.run();
                        return null;
                    }
                }).onResult(new Consumer<Result<Void>>(){

                    @Override
                    public void accept(Result<Void> uResult) throws Exception {
                        xtask.result(uResult);
                    }
                });
                xtask.execute(Xtask.screenExecutor(exec));
            }
        }).ifCanceled(new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        });
        return xtask;
    }

    @Override
    public <U, V> Xtask<V> thenCombineAsync(@NonNull Xtask<U> other, @NonNull BiFunction<Result<T>, Result<U>, V> fn) {
        return this.thenCombineAsync(other, fn, Xtask.ASYNC_POOL);
    }

    @Override
    public <U, V> Xtask<V> thenCombineAsync(@NonNull Xtask<U> other, final @NonNull BiFunction<Result<T>, Result<U>, V> fn, final @NonNull Executor exec) {
        final Xtask xtask = new Xtask();
        new TaskBothOperator(this.thisXtask, other, new TaskBothOperator.Callback<T, U>(){

            @Override
            public void onResult(final Result<T> result1, final Result<U> result2) {
                xtask.worker = Xtask.WORKER_FACTORY.createWorker().supplyAsync(new Supplier<V>(){

                    @Override
                    public V get() throws Exception {
                        return fn.apply(result1, result2);
                    }
                }).onResult(new Consumer<Result<V>>(){

                    @Override
                    public void accept(Result<V> vResult) throws Exception {
                        xtask.result(vResult);
                    }
                });
                xtask.execute(Xtask.screenExecutor(exec));
            }
        });
        Action cancelAction = new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        };
        this.thisXtask.ifCanceled(cancelAction);
        other.ifCanceled(cancelAction);
        return xtask;
    }

    @Override
    public <U> Xtask<Void> thenAcceptBothAsync(@NonNull Xtask<U> other, @NonNull BiConsumer<Result<T>, Result<U>> action) {
        return this.thenAcceptBothAsync(other, action, Xtask.ASYNC_POOL);
    }

    @Override
    public <U> Xtask<Void> thenAcceptBothAsync(@NonNull Xtask<U> other, final @NonNull BiConsumer<Result<T>, Result<U>> action, final @NonNull Executor exec) {
        final Xtask<Void> xtask = new Xtask<Void>();
        new TaskBothOperator(this.thisXtask, other, new TaskBothOperator.Callback<T, U>(){

            @Override
            public void onResult(final Result<T> result1, final Result<U> result2) {
                xtask.worker = Xtask.WORKER_FACTORY.createWorker().supplyAsync(new Supplier<Void>(){

                    @Override
                    public Void get() throws Exception {
                        action.accept(result1, result2);
                        return null;
                    }
                }).onResult(new Consumer<Result<Void>>(){

                    @Override
                    public void accept(Result<Void> voidResult) throws Exception {
                        xtask.result(voidResult);
                    }
                });
                xtask.execute(Xtask.screenExecutor(exec));
            }
        });
        Action cancelAction = new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        };
        this.thisXtask.ifCanceled(cancelAction);
        other.ifCanceled(cancelAction);
        return xtask;
    }

    @Override
    public <U> Xtask<Void> runAfterBothAsync(@NonNull Xtask<U> other, @NonNull Action action) {
        return this.runAfterBothAsync(other, action, Xtask.ASYNC_POOL);
    }

    @Override
    public <U> Xtask<Void> runAfterBothAsync(@NonNull Xtask<U> other, final @NonNull Action action, final @NonNull Executor exec) {
        final Xtask<Void> xtask = new Xtask<Void>();
        new TaskBothOperator(this.thisXtask, other, new TaskBothOperator.Callback<T, U>(){

            @Override
            public void onResult(Result<T> result1, Result<U> result2) {
                xtask.worker = Xtask.WORKER_FACTORY.createWorker().supplyAsync(new Supplier<Void>(){

                    @Override
                    public Void get() throws Exception {
                        action.run();
                        return null;
                    }
                }).onResult(new Consumer<Result<Void>>(){

                    @Override
                    public void accept(Result<Void> voidResult) throws Exception {
                        xtask.result(voidResult);
                    }
                });
                xtask.execute(Xtask.screenExecutor(exec));
            }
        });
        Action cancelAction = new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        };
        this.thisXtask.ifCanceled(cancelAction);
        other.ifCanceled(cancelAction);
        return xtask;
    }

    @Override
    public <U> Xtask<U> applyToEitherAsync(@NonNull Xtask<T> other, @NonNull Function<Result<T>, U> fn) {
        return this.applyToEitherAsync(other, fn, Xtask.ASYNC_POOL);
    }

    @Override
    public <U> Xtask<U> applyToEitherAsync(@NonNull Xtask<T> other, final @NonNull Function<Result<T>, U> fn, final @NonNull Executor exec) {
        final Xtask xtask = new Xtask();
        new TaskEitherOperator<T>(this.thisXtask, other, new TaskEitherOperator.Callback<T>(){

            @Override
            public void onResult(final Result<T> result) {
                xtask.worker = Xtask.WORKER_FACTORY.createWorker().supplyAsync(new Supplier<U>(){

                    @Override
                    public U get() throws Exception {
                        return fn.apply(result);
                    }
                }).onResult(new Consumer<Result<U>>(){

                    @Override
                    public void accept(Result<U> uResult) throws Exception {
                        xtask.result(uResult);
                    }
                });
                xtask.execute(Xtask.screenExecutor(exec));
            }
        });
        this.thisXtask.ifCanceled(new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        });
        return xtask;
    }

    @Override
    public Xtask<Void> acceptEitherAsync(@NonNull Xtask<T> other, @NonNull Consumer<Result<T>> action) {
        return this.acceptEitherAsync(other, action, Xtask.ASYNC_POOL);
    }

    @Override
    public Xtask<Void> acceptEitherAsync(@NonNull Xtask<T> other, final @NonNull Consumer<Result<T>> action, final @NonNull Executor exec) {
        final Xtask<Void> xtask = new Xtask<Void>();
        new TaskEitherOperator<T>(this.thisXtask, other, new TaskEitherOperator.Callback<T>(){

            @Override
            public void onResult(final Result<T> result) {
                xtask.worker = Xtask.WORKER_FACTORY.createWorker().supplyAsync(new Supplier<Void>(){

                    @Override
                    public Void get() throws Exception {
                        action.accept(result);
                        return null;
                    }
                }).onResult(new Consumer<Result<Void>>(){

                    @Override
                    public void accept(Result<Void> voidResult) throws Exception {
                        xtask.result(voidResult);
                    }
                });
                xtask.execute(Xtask.screenExecutor(exec));
            }
        });
        this.thisXtask.ifCanceled(new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        });
        return xtask;
    }

    @Override
    public <U> Xtask<Void> runAfterEitherAsync(@NonNull Xtask<U> other, @NonNull Action action) {
        return this.runAfterEitherAsync(other, action, Xtask.ASYNC_POOL);
    }

    @Override
    public <U> Xtask<Void> runAfterEitherAsync(@NonNull Xtask<U> other, final @NonNull Action action, final @NonNull Executor exec) {
        final Xtask<Void> xtask = new Xtask<Void>();
        new TaskEitherOperator2<T, U>(this.thisXtask, other, new TaskEitherOperator2.Callback(){

            @Override
            public void onResult() {
                xtask.worker = Xtask.WORKER_FACTORY.createWorker().supplyAsync(new Supplier<Void>(){

                    @Override
                    public Void get() throws Exception {
                        action.run();
                        return null;
                    }
                }).onResult(new Consumer<Result<Void>>(){

                    @Override
                    public void accept(Result<Void> voidResult) throws Exception {
                        xtask.result(voidResult);
                    }
                });
                xtask.execute(Xtask.screenExecutor(exec));
            }
        });
        this.thisXtask.ifCanceled(new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        });
        return xtask;
    }

    private static class TaskEitherOperator2<T, U> {
        private boolean finish = false;

        TaskEitherOperator2(Xtask<T> xtask1, Xtask<U> xtask2, final Callback callback) {
            xtask1.onResult(new Consumer<Result<T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Result<T> result) throws Exception {
                    TaskEitherOperator2 taskEitherOperator2 = TaskEitherOperator2.this;
                    synchronized (taskEitherOperator2) {
                        if (!TaskEitherOperator2.this.finish) {
                            callback.onResult();
                            TaskEitherOperator2.this.finish = true;
                        }
                    }
                }
            });
            xtask2.onResult(new Consumer<Result<U>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Result<U> result) throws Exception {
                    TaskEitherOperator2 taskEitherOperator2 = TaskEitherOperator2.this;
                    synchronized (taskEitherOperator2) {
                        if (!TaskEitherOperator2.this.finish) {
                            callback.onResult();
                            TaskEitherOperator2.this.finish = true;
                        }
                    }
                }
            });
        }

        public static interface Callback {
            public void onResult();
        }
    }

    private static class TaskEitherOperator<T> {
        private boolean finish = false;

        TaskEitherOperator(Xtask<T> xtask1, Xtask<T> xtask2, final Callback<T> callback) {
            xtask1.onResult(new Consumer<Result<T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Result<T> result) throws Exception {
                    TaskEitherOperator taskEitherOperator = TaskEitherOperator.this;
                    synchronized (taskEitherOperator) {
                        if (!TaskEitherOperator.this.finish) {
                            callback.onResult(result);
                            TaskEitherOperator.this.finish = true;
                        }
                    }
                }
            });
            xtask2.onResult(new Consumer<Result<T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Result<T> result) throws Exception {
                    TaskEitherOperator taskEitherOperator = TaskEitherOperator.this;
                    synchronized (taskEitherOperator) {
                        if (!TaskEitherOperator.this.finish) {
                            callback.onResult(result);
                            TaskEitherOperator.this.finish = true;
                        }
                    }
                }
            });
        }

        public static interface Callback<T> {
            public void onResult(Result<T> var1);
        }
    }

    private static class TaskBothOperator<T1, T2> {
        private Result<T1> result1;
        private Result<T2> result2;

        private TaskBothOperator(Xtask<T1> t1Xtask, Xtask<T2> t2Xtask, final Callback<T1, T2> callback) {
            t1Xtask.onResult(new Consumer<Result<T1>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Result<T1> t1Result) throws Exception {
                    TaskBothOperator taskBothOperator = TaskBothOperator.this;
                    synchronized (taskBothOperator) {
                        if (TaskBothOperator.this.result2 != null) {
                            callback.onResult(t1Result, TaskBothOperator.this.result2);
                        } else {
                            TaskBothOperator.this.result1 = t1Result;
                        }
                    }
                }
            });
            t2Xtask.onResult(new Consumer<Result<T2>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Result<T2> t2Result) throws Exception {
                    TaskBothOperator taskBothOperator = TaskBothOperator.this;
                    synchronized (taskBothOperator) {
                        if (TaskBothOperator.this.result1 != null) {
                            callback.onResult(TaskBothOperator.this.result1, t2Result);
                        } else {
                            TaskBothOperator.this.result2 = t2Result;
                        }
                    }
                }
            });
        }

        public static interface Callback<T1, T2> {
            public void onResult(Result<T1> var1, Result<T2> var2);
        }
    }
}

