/*
 * Decompiled with CFR 0.152.
 */
package io.github.xyzxqs.libs.xtask;

import android.support.annotation.NonNull;
import io.github.xyzxqs.libs.xtask.Cancellable;
import io.github.xyzxqs.libs.xtask.Objects;
import io.github.xyzxqs.libs.xtask.Result;
import io.github.xyzxqs.libs.xtask.Worker;
import io.github.xyzxqs.libs.xtask.WorkerFactory;
import io.github.xyzxqs.libs.xtask.XtaskStage;
import io.github.xyzxqs.libs.xtask.XtaskStageImpl;
import io.github.xyzxqs.libs.xtask.func.Action;
import io.github.xyzxqs.libs.xtask.func.BiConsumer;
import io.github.xyzxqs.libs.xtask.func.BiFunction;
import io.github.xyzxqs.libs.xtask.func.Consumer;
import io.github.xyzxqs.libs.xtask.func.Function;
import io.github.xyzxqs.libs.xtask.func.Supplier;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class Xtask<T>
implements XtaskStage<T>,
Cancellable {
    static final Executor ASYNC_POOL = Executors.newCachedThreadPool();
    static final WorkerFactory WORKER_FACTORY = new WorkerFactory(ASYNC_POOL);
    Worker worker;
    private Result<T> taskResult;
    private boolean canceled = false;
    private final ArrayList<Consumer<Result<T>>> resultConsumers = new ArrayList();
    private final ArrayList<Action> cancelActions = new ArrayList();
    private XtaskStage<T> delegate = new XtaskStageImpl(this);

    static Executor screenExecutor(Executor e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return e;
    }

    public static <T> Xtask<T> supplyAsync(@NonNull Supplier<T> supplier) {
        return Xtask.supplyAsync(supplier, ASYNC_POOL);
    }

    public static <T> Xtask<T> supplyAsync(final @NonNull Supplier<T> supplier, @NonNull Executor exec) {
        final Xtask<T> task = new Xtask<T>();
        task.worker = WORKER_FACTORY.createWorker().supplyAsync(new Supplier<T>(){

            @Override
            public T get() throws Exception {
                return supplier.get();
            }
        }).onResult(new Consumer<Result<T>>(){

            @Override
            public void accept(Result<T> result) throws Exception {
                task.result(result);
            }
        });
        task.execute(Xtask.screenExecutor(exec));
        return task;
    }

    Xtask() {
    }

    void execute() {
        this.execute(ASYNC_POOL);
    }

    void execute(Executor exec) {
        this.canceled = false;
        this.worker.execute(exec);
    }

    void result(@NonNull Result<T> result) {
        if (!this.canceled) {
            this.taskResult = result;
            for (Consumer<Result<Result<T>>> consumer : this.resultConsumers) {
                try {
                    consumer.accept(result);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
        if (this.worker != null) {
            this.worker.cancel();
        }
        for (Action action : this.cancelActions) {
            try {
                action.run();
            }
            catch (Exception exception) {}
        }
    }

    public Xtask<T> onResult(@NonNull Consumer<Result<T>> consumer) {
        Objects.checkNotNull(consumer, "consumer == null");
        this.resultConsumers.add(consumer);
        if (this.taskResult != null) {
            try {
                consumer.accept(this.taskResult);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public Xtask<T> ifCanceled(@NonNull Action action) {
        Objects.checkNotNull(action, "action == null");
        this.cancelActions.add(action);
        if (this.canceled) {
            try {
                action.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public <U> Xtask<U> thenApplyAsync(@NonNull Function<Result<T>, U> fn) {
        return this.delegate.thenApplyAsync(fn);
    }

    @Override
    public <U> Xtask<U> thenApplyAsync(@NonNull Function<Result<T>, U> fn, @NonNull Executor exec) {
        return this.delegate.thenApplyAsync(fn, exec);
    }

    @Override
    public Xtask<Void> thenAcceptAsync(@NonNull Consumer<Result<T>> action) {
        return this.delegate.thenAcceptAsync(action);
    }

    @Override
    public Xtask<Void> thenAcceptAsync(@NonNull Consumer<Result<T>> action, @NonNull Executor exec) {
        return this.delegate.thenAcceptAsync(action, exec);
    }

    @Override
    public Xtask<Void> thenRunAsync(@NonNull Action action) {
        return this.delegate.thenRunAsync(action);
    }

    @Override
    public Xtask<Void> thenRunAsync(@NonNull Action action, @NonNull Executor exec) {
        return this.delegate.thenRunAsync(action, exec);
    }

    @Override
    public <U, V> Xtask<V> thenCombineAsync(@NonNull Xtask<U> other, @NonNull BiFunction<Result<T>, Result<U>, V> fn) {
        return this.delegate.thenCombineAsync(other, fn);
    }

    @Override
    public <U, V> Xtask<V> thenCombineAsync(@NonNull Xtask<U> other, @NonNull BiFunction<Result<T>, Result<U>, V> fn, @NonNull Executor exec) {
        return this.delegate.thenCombineAsync(other, fn, exec);
    }

    @Override
    public <U> Xtask<Void> thenAcceptBothAsync(@NonNull Xtask<U> other, @NonNull BiConsumer<Result<T>, Result<U>> action) {
        return this.delegate.thenAcceptBothAsync(other, action);
    }

    @Override
    public <U> Xtask<Void> thenAcceptBothAsync(@NonNull Xtask<U> other, @NonNull BiConsumer<Result<T>, Result<U>> action, @NonNull Executor exec) {
        return this.delegate.thenAcceptBothAsync(other, action, exec);
    }

    @Override
    public <U> Xtask<Void> runAfterBothAsync(@NonNull Xtask<U> other, @NonNull Action action) {
        return this.delegate.runAfterBothAsync(other, action);
    }

    @Override
    public <U> Xtask<Void> runAfterBothAsync(@NonNull Xtask<U> other, @NonNull Action action, @NonNull Executor exec) {
        return this.delegate.runAfterBothAsync(other, action, exec);
    }

    @Override
    public <U> Xtask<U> applyToEitherAsync(@NonNull Xtask<T> other, @NonNull Function<Result<T>, U> fn) {
        return this.delegate.applyToEitherAsync(other, fn);
    }

    @Override
    public <U> Xtask<U> applyToEitherAsync(@NonNull Xtask<T> other, @NonNull Function<Result<T>, U> fn, @NonNull Executor exec) {
        return this.delegate.applyToEitherAsync(other, fn, exec);
    }

    @Override
    public Xtask<Void> acceptEitherAsync(@NonNull Xtask<T> other, @NonNull Consumer<Result<T>> action) {
        return this.delegate.acceptEitherAsync(other, action);
    }

    @Override
    public Xtask<Void> acceptEitherAsync(@NonNull Xtask<T> other, @NonNull Consumer<Result<T>> action, @NonNull Executor exec) {
        return this.delegate.acceptEitherAsync(other, action, exec);
    }

    @Override
    public <U> Xtask<Void> runAfterEitherAsync(@NonNull Xtask<U> other, @NonNull Action action) {
        return this.delegate.runAfterEitherAsync(other, action);
    }

    @Override
    public <U> Xtask<Void> runAfterEitherAsync(@NonNull Xtask<U> other, @NonNull Action action, @NonNull Executor exec) {
        return this.delegate.runAfterEitherAsync(other, action, exec);
    }
}

