/*
 * Decompiled with CFR 0.152.
 */
package io.github.xyzxqs.libs.xtask;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import io.github.xyzxqs.libs.xtask.Cancellable;
import io.github.xyzxqs.libs.xtask.Objects;
import io.github.xyzxqs.libs.xtask.Result;
import io.github.xyzxqs.libs.xtask.Worker;
import io.github.xyzxqs.libs.xtask.func.Action;
import io.github.xyzxqs.libs.xtask.func.Consumer;
import io.github.xyzxqs.libs.xtask.func.Supplier;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

class WorkerImpl<T>
implements Worker<T> {
    private static final String TAG = "WorkerImpl";
    private static final int MSG_ON_SUCCESS = 63;
    private static final int MSG_ON_FAILURE = 354;
    private static final int MSG_ON_CANCELED = 621;
    private final Executor executor;
    private final Handler handler;
    private WorkerTask workerTask;
    private Supplier<T> tSupplier;
    private Action cancelAction;
    private Consumer<Result<T>> resultConsumer;

    WorkerImpl(Executor executor) {
        this.executor = executor;
        this.handler = new WorkerHandler(this);
    }

    @Override
    public Worker<T> supplyAsync(Supplier<T> supplier) {
        this.tSupplier = Objects.checkNotNull(supplier, "tSupplier == null");
        return this;
    }

    @Override
    public Worker<T> onResult(Consumer<Result<T>> consumer) {
        this.resultConsumer = Objects.checkNotNull(consumer, "consumer == null");
        return this;
    }

    @Override
    public Worker<T> ifCanceled(Action action) {
        this.cancelAction = Objects.checkNotNull(action, "action == null");
        return this;
    }

    @Override
    public void execute() {
        this.execute(this.executor);
    }

    @Override
    public void execute(Executor exec) {
        this.workerTask = new WorkerTask(this.handler, this.tSupplier);
        exec.execute(this.workerTask);
    }

    @Override
    public void cancel() {
        if (this.workerTask != null) {
            this.workerTask.cancel();
        }
    }

    private void canceled() {
        if (this.cancelAction != null) {
            try {
                this.cancelAction.run();
            }
            catch (Exception e) {
                this.loge(e);
            }
        }
    }

    private void failure(Throwable throwable) {
        if (this.resultConsumer != null) {
            try {
                this.resultConsumer.accept(Result.error(throwable));
            }
            catch (Exception e) {
                this.loge(e);
            }
        }
    }

    private void success(T t) {
        if (this.resultConsumer != null) {
            try {
                this.resultConsumer.accept(Result.result(t));
            }
            catch (Exception e) {
                this.loge(e);
            }
        }
    }

    private void loge(Exception e) {
        Log.e((String)TAG, (String)"An error occurred: ", (Throwable)e);
    }

    private static class WorkerTask<U>
    implements Runnable,
    Cancellable {
        private final Handler handler;
        private final Supplier<U> function;
        private final AtomicBoolean canceled;

        private WorkerTask(Handler handler, Supplier<U> function) {
            this.handler = handler;
            this.function = function;
            this.canceled = new AtomicBoolean(false);
        }

        @Override
        public void cancel() {
            this.canceled.set(true);
        }

        @Override
        public void run() {
            U u;
            if (this.canceled.get()) {
                this.handler.sendEmptyMessage(621);
                return;
            }
            try {
                u = this.function.get();
            }
            catch (Exception e) {
                this.handler.obtainMessage(354, (Object)e).sendToTarget();
                return;
            }
            if (u != null) {
                if (this.canceled.get()) {
                    this.handler.sendEmptyMessage(621);
                } else {
                    this.handler.obtainMessage(63, u).sendToTarget();
                }
            }
        }
    }

    private static class WorkerHandler<U>
    extends Handler {
        private final WorkerImpl<U> worker;

        private WorkerHandler(WorkerImpl<U> worker) {
            super(Looper.getMainLooper());
            this.worker = worker;
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 621: {
                    ((WorkerImpl)this.worker).canceled();
                    break;
                }
                case 354: {
                    ((WorkerImpl)this.worker).failure((Throwable)msg.obj);
                    break;
                }
                case 63: {
                    ((WorkerImpl)this.worker).success(msg.obj);
                }
            }
        }
    }
}

