/*
 * Decompiled with CFR 0.152.
 */
package io.github.xyzxqs.libs.xtask;

public final class Result<T> {
    private final T result;
    private final Throwable error;

    public static <T> Result<T> error(Throwable error) {
        if (error == null) {
            throw new NullPointerException("error == null");
        }
        return new Result<Object>(null, error);
    }

    public static <T> Result<T> result(T response) {
        if (response == null) {
            throw new NullPointerException("result == null");
        }
        return new Result<T>(response, null);
    }

    private Result(T result, Throwable error) {
        this.result = result;
        this.error = error;
    }

    public T result() {
        return this.result;
    }

    public Throwable error() {
        return this.error;
    }

    public boolean isError() {
        return this.error != null;
    }

    public String toString() {
        return this.isError() ? this.error.toString() : this.result.toString();
    }
}

