/*
 * Decompiled with CFR 0.152.
 */
package io.github.xyzxqs.libs.xtask;

import android.support.annotation.NonNull;
import io.github.xyzxqs.libs.xtask.Cancellable;
import io.github.xyzxqs.libs.xtask.Objects;
import io.github.xyzxqs.libs.xtask.Result;
import io.github.xyzxqs.libs.xtask.Worker;
import io.github.xyzxqs.libs.xtask.WorkerFactory;
import io.github.xyzxqs.libs.xtask.func.Action;
import io.github.xyzxqs.libs.xtask.func.BiConsumer;
import io.github.xyzxqs.libs.xtask.func.BiFunction;
import io.github.xyzxqs.libs.xtask.func.Consumer;
import io.github.xyzxqs.libs.xtask.func.Function;
import io.github.xyzxqs.libs.xtask.func.Supplier;
import java.util.ArrayList;
import java.util.concurrent.Executor;

public class Xtask<T>
implements Cancellable {
    private Worker worker;
    private Result<T> taskResult;
    private boolean canceled = false;
    private final ArrayList<Consumer<Result<T>>> resultConsumers = new ArrayList();
    private final ArrayList<Action> cancelActions = new ArrayList();

    private Xtask() {
    }

    public static <T> Xtask<T> supplyAsync(@NonNull Supplier<T> supplier) {
        return Xtask.supplyAsync(supplier, WorkerFactory.instance().getDefaultExecutor());
    }

    public static <T> Xtask<T> supplyAsync(final @NonNull Supplier<T> supplier, @NonNull Executor exec) {
        final Xtask<T> task = new Xtask<T>();
        task.worker = WorkerFactory.instance().createWorker().supplyAsync(new Supplier<T>(){

            @Override
            public T get() throws Exception {
                return supplier.get();
            }
        }).onResult(new Consumer<Result<T>>(){

            @Override
            public void accept(Result<T> result) throws Exception {
                task.result(result);
            }
        });
        super.execute(exec);
        return task;
    }

    private void execute() {
        this.execute(WorkerFactory.instance().getDefaultExecutor());
    }

    private void execute(Executor exec) {
        this.canceled = false;
        this.worker.execute(exec);
    }

    private void result(@NonNull Result<T> result) {
        if (!this.canceled) {
            this.taskResult = result;
            for (Consumer<Result<Result<T>>> consumer : this.resultConsumers) {
                try {
                    consumer.accept(result);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
        if (this.worker != null) {
            this.worker.cancel();
        }
        for (Action action : this.cancelActions) {
            try {
                action.run();
            }
            catch (Exception exception) {}
        }
    }

    public Xtask<T> onResult(@NonNull Consumer<Result<T>> consumer) {
        Objects.checkNotNull(consumer, "consumer == null");
        this.resultConsumers.add(consumer);
        if (this.taskResult != null) {
            try {
                consumer.accept(this.taskResult);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public Xtask<T> ifCanceled(@NonNull Action action) {
        Objects.checkNotNull(action, "action == null");
        this.cancelActions.add(action);
        if (this.canceled) {
            try {
                action.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public <U> Xtask<U> thenApplyAsync(@NonNull Function<Result<T>, ? extends U> fn) {
        return this.thenApplyAsync(fn, WorkerFactory.instance().getDefaultExecutor());
    }

    public <U> Xtask<U> thenApplyAsync(final @NonNull Function<Result<T>, ? extends U> fn, final @NonNull Executor exec) {
        final Xtask<T> xtask = new Xtask<T>();
        this.onResult(new Consumer<Result<T>>(){

            @Override
            public void accept(final Result<T> result) throws Exception {
                xtask.worker = WorkerFactory.instance().createWorker().supplyAsync(new Supplier<U>(){

                    @Override
                    public U get() throws Exception {
                        return fn.apply(result);
                    }
                }).onResult(new Consumer<Result<U>>(){

                    @Override
                    public void accept(Result<U> uResult) throws Exception {
                        xtask.result(uResult);
                    }
                });
                xtask.execute(exec);
            }
        }).ifCanceled(new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        });
        return xtask;
    }

    public Xtask<Void> thenAcceptAsync(@NonNull Consumer<Result<T>> action) {
        return this.thenAcceptAsync(action, WorkerFactory.instance().getDefaultExecutor());
    }

    public Xtask<Void> thenAcceptAsync(final @NonNull Consumer<Result<T>> action, final @NonNull Executor exec) {
        final Xtask<Void> xtask = new Xtask<Void>();
        this.onResult(new Consumer<Result<T>>(){

            @Override
            public void accept(final Result<T> result) throws Exception {
                xtask.worker = WorkerFactory.instance().createWorker().supplyAsync(new Supplier<Void>(){

                    @Override
                    public Void get() throws Exception {
                        action.accept(result);
                        return null;
                    }
                }).onResult(new Consumer<Result<Void>>(){

                    @Override
                    public void accept(Result<Void> uResult) throws Exception {
                        xtask.result(uResult);
                    }
                });
                xtask.execute(exec);
            }
        }).ifCanceled(new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        });
        return xtask;
    }

    public Xtask<Void> thenRunAsync(@NonNull Action action) {
        return this.thenRunAsync(action, WorkerFactory.instance().getDefaultExecutor());
    }

    public Xtask<Void> thenRunAsync(final @NonNull Action action, final @NonNull Executor exec) {
        final Xtask<Void> xtask = new Xtask<Void>();
        this.onResult(new Consumer<Result<T>>(){

            @Override
            public void accept(Result<T> result) throws Exception {
                xtask.worker = WorkerFactory.instance().createWorker().supplyAsync(new Supplier<Void>(){

                    @Override
                    public Void get() throws Exception {
                        action.run();
                        return null;
                    }
                }).onResult(new Consumer<Result<Void>>(){

                    @Override
                    public void accept(Result<Void> uResult) throws Exception {
                        xtask.result(uResult);
                    }
                });
                xtask.execute(exec);
            }
        }).ifCanceled(new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        });
        return xtask;
    }

    public <U, V> Xtask<V> thenCombineAsync(@NonNull Xtask<U> other, @NonNull BiFunction<Result<T>, Result<U>, ? extends V> fn) {
        return this.thenCombineAsync(other, fn, WorkerFactory.instance().getDefaultExecutor());
    }

    public <U, V> Xtask<V> thenCombineAsync(@NonNull Xtask<U> other, final @NonNull BiFunction<Result<T>, Result<U>, ? extends V> fn, final @NonNull Executor exec) {
        final Xtask<T> xtask = new Xtask<T>();
        new TaskBothOperator(this, other, new TaskBothOperator.Callback<T, U>(){

            @Override
            public void onResult(final Result<T> result1, final Result<U> result2) {
                xtask.worker = WorkerFactory.instance().createWorker().supplyAsync(new Supplier<V>(){

                    @Override
                    public V get() throws Exception {
                        return fn.apply(result1, result2);
                    }
                }).onResult(new Consumer<Result<V>>(){

                    @Override
                    public void accept(Result<V> vResult) throws Exception {
                        xtask.result(vResult);
                    }
                });
                xtask.execute(exec);
            }
        });
        Action cancelAction = new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        };
        this.ifCanceled(cancelAction);
        other.ifCanceled(cancelAction);
        return xtask;
    }

    public <U> Xtask<Void> thenAcceptBothAsync(@NonNull Xtask<U> other, @NonNull BiConsumer<Result<T>, Result<U>> action) {
        return this.thenAcceptBothAsync(other, action, WorkerFactory.instance().getDefaultExecutor());
    }

    public <U> Xtask<Void> thenAcceptBothAsync(@NonNull Xtask<U> other, final @NonNull BiConsumer<Result<T>, Result<U>> action, final @NonNull Executor exec) {
        final Xtask<Void> xtask = new Xtask<Void>();
        new TaskBothOperator(this, other, new TaskBothOperator.Callback<T, U>(){

            @Override
            public void onResult(final Result<T> result1, final Result<U> result2) {
                xtask.worker = WorkerFactory.instance().createWorker().supplyAsync(new Supplier<Void>(){

                    @Override
                    public Void get() throws Exception {
                        action.accept(result1, result2);
                        return null;
                    }
                }).onResult(new Consumer<Result<Void>>(){

                    @Override
                    public void accept(Result<Void> voidResult) throws Exception {
                        xtask.result(voidResult);
                    }
                });
                xtask.execute(exec);
            }
        });
        Action cancelAction = new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        };
        this.ifCanceled(cancelAction);
        other.ifCanceled(cancelAction);
        return xtask;
    }

    public <U> Xtask<Void> runAfterBothAsync(@NonNull Xtask<U> other, @NonNull Action action) {
        return this.runAfterBothAsync(other, action, WorkerFactory.instance().getDefaultExecutor());
    }

    public <U> Xtask<Void> runAfterBothAsync(@NonNull Xtask<U> other, final @NonNull Action action, final @NonNull Executor exec) {
        final Xtask<Void> xtask = new Xtask<Void>();
        new TaskBothOperator(this, other, new TaskBothOperator.Callback<T, U>(){

            @Override
            public void onResult(Result<T> result1, Result<U> result2) {
                xtask.worker = WorkerFactory.instance().createWorker().supplyAsync(new Supplier<Void>(){

                    @Override
                    public Void get() throws Exception {
                        action.run();
                        return null;
                    }
                }).onResult(new Consumer<Result<Void>>(){

                    @Override
                    public void accept(Result<Void> voidResult) throws Exception {
                        xtask.result(voidResult);
                    }
                });
                xtask.execute(exec);
            }
        });
        Action cancelAction = new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        };
        this.ifCanceled(cancelAction);
        other.ifCanceled(cancelAction);
        return xtask;
    }

    public <U> Xtask<U> applyToEitherAsync(@NonNull Xtask<T> other, @NonNull Function<Result<T>, U> fn) {
        return this.applyToEitherAsync(other, fn, WorkerFactory.instance().getDefaultExecutor());
    }

    public <U> Xtask<U> applyToEitherAsync(@NonNull Xtask<T> other, final @NonNull Function<Result<T>, U> fn, final @NonNull Executor exec) {
        final Xtask<T> xtask = new Xtask<T>();
        new TaskEitherOperator<T>(this, other, new TaskEitherOperator.Callback<T>(){

            @Override
            public void onResult(final Result<T> result) {
                xtask.worker = WorkerFactory.instance().createWorker().supplyAsync(new Supplier<U>(){

                    @Override
                    public U get() throws Exception {
                        return fn.apply(result);
                    }
                }).onResult(new Consumer<Result<U>>(){

                    @Override
                    public void accept(Result<U> uResult) throws Exception {
                        xtask.result(uResult);
                    }
                });
                xtask.execute(exec);
            }
        });
        this.ifCanceled(new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        });
        return xtask;
    }

    public Xtask<Void> acceptEitherAsync(@NonNull Xtask<T> other, @NonNull Consumer<Result<T>> action) {
        return this.acceptEitherAsync(other, action, WorkerFactory.instance().getDefaultExecutor());
    }

    public Xtask<Void> acceptEitherAsync(@NonNull Xtask<T> other, final @NonNull Consumer<Result<T>> action, final @NonNull Executor exec) {
        final Xtask<Void> xtask = new Xtask<Void>();
        new TaskEitherOperator<T>(this, other, new TaskEitherOperator.Callback<T>(){

            @Override
            public void onResult(final Result<T> result) {
                xtask.worker = WorkerFactory.instance().createWorker().supplyAsync(new Supplier<Void>(){

                    @Override
                    public Void get() throws Exception {
                        action.accept(result);
                        return null;
                    }
                }).onResult(new Consumer<Result<Void>>(){

                    @Override
                    public void accept(Result<Void> voidResult) throws Exception {
                        xtask.result(voidResult);
                    }
                });
                xtask.execute(exec);
            }
        });
        this.ifCanceled(new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        });
        return xtask;
    }

    public <U> Xtask<Void> runAfterEitherAsync(@NonNull Xtask<U> other, @NonNull Action action) {
        return this.runAfterEitherAsync(other, action, WorkerFactory.instance().getDefaultExecutor());
    }

    public <U> Xtask<Void> runAfterEitherAsync(@NonNull Xtask<U> other, final @NonNull Action action, final @NonNull Executor exec) {
        final Xtask<Void> xtask = new Xtask<Void>();
        new TaskEitherOperator2(this, other, new TaskEitherOperator2.Callback(){

            @Override
            public void onResult() {
                xtask.worker = WorkerFactory.instance().createWorker().supplyAsync(new Supplier<Void>(){

                    @Override
                    public Void get() throws Exception {
                        action.run();
                        return null;
                    }
                }).onResult(new Consumer<Result<Void>>(){

                    @Override
                    public void accept(Result<Void> voidResult) throws Exception {
                        xtask.result(voidResult);
                    }
                });
                xtask.execute(exec);
            }
        });
        this.ifCanceled(new Action(){

            @Override
            public void run() throws Exception {
                xtask.cancel();
            }
        });
        return xtask;
    }

    private static class TaskEitherOperator2<T, U> {
        private boolean finish = false;

        TaskEitherOperator2(Xtask<T> xtask1, Xtask<U> xtask2, final Callback callback) {
            xtask1.onResult(new Consumer<Result<T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Result<T> result) throws Exception {
                    TaskEitherOperator2 taskEitherOperator2 = TaskEitherOperator2.this;
                    synchronized (taskEitherOperator2) {
                        if (!TaskEitherOperator2.this.finish) {
                            callback.onResult();
                            TaskEitherOperator2.this.finish = true;
                        }
                    }
                }
            });
            xtask2.onResult(new Consumer<Result<U>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Result<U> result) throws Exception {
                    TaskEitherOperator2 taskEitherOperator2 = TaskEitherOperator2.this;
                    synchronized (taskEitherOperator2) {
                        if (!TaskEitherOperator2.this.finish) {
                            callback.onResult();
                            TaskEitherOperator2.this.finish = true;
                        }
                    }
                }
            });
        }

        public static interface Callback {
            public void onResult();
        }
    }

    private static class TaskEitherOperator<T> {
        private boolean finish = false;

        TaskEitherOperator(Xtask<T> xtask1, Xtask<T> xtask2, final Callback<T> callback) {
            xtask1.onResult(new Consumer<Result<T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Result<T> result) throws Exception {
                    TaskEitherOperator taskEitherOperator = TaskEitherOperator.this;
                    synchronized (taskEitherOperator) {
                        if (!TaskEitherOperator.this.finish) {
                            callback.onResult(result);
                            TaskEitherOperator.this.finish = true;
                        }
                    }
                }
            });
            xtask2.onResult(new Consumer<Result<T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Result<T> result) throws Exception {
                    TaskEitherOperator taskEitherOperator = TaskEitherOperator.this;
                    synchronized (taskEitherOperator) {
                        if (!TaskEitherOperator.this.finish) {
                            callback.onResult(result);
                            TaskEitherOperator.this.finish = true;
                        }
                    }
                }
            });
        }

        public static interface Callback<T> {
            public void onResult(Result<T> var1);
        }
    }

    private static class TaskBothOperator<T1, T2> {
        private Result<T1> result1;
        private Result<T2> result2;

        private TaskBothOperator(Xtask<T1> t1Xtask, Xtask<T2> t2Xtask, final Callback<T1, T2> callback) {
            t1Xtask.onResult(new Consumer<Result<T1>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Result<T1> t1Result) throws Exception {
                    TaskBothOperator taskBothOperator = TaskBothOperator.this;
                    synchronized (taskBothOperator) {
                        if (TaskBothOperator.this.result2 != null) {
                            callback.onResult(t1Result, TaskBothOperator.this.result2);
                        } else {
                            TaskBothOperator.this.result1 = t1Result;
                        }
                    }
                }
            });
            t2Xtask.onResult(new Consumer<Result<T2>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Result<T2> t2Result) throws Exception {
                    TaskBothOperator taskBothOperator = TaskBothOperator.this;
                    synchronized (taskBothOperator) {
                        if (TaskBothOperator.this.result1 != null) {
                            callback.onResult(TaskBothOperator.this.result1, t2Result);
                        } else {
                            TaskBothOperator.this.result2 = t2Result;
                        }
                    }
                }
            });
        }

        public static interface Callback<T1, T2> {
            public void onResult(Result<T1> var1, Result<T2> var2);
        }
    }
}

