/*
 * Decompiled with CFR 0.152.
 */
package io.github.xyzxqs.libs.xtask.retrofit2;

import io.github.xyzxqs.libs.xtask.Xtask;
import io.github.xyzxqs.libs.xtask.func.Action;
import io.github.xyzxqs.libs.xtask.func.Supplier;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.HttpException;
import retrofit2.Response;
import retrofit2.Retrofit;

public class XtaskCallAdapterFactory
extends CallAdapter.Factory {
    public static XtaskCallAdapterFactory create() {
        return new XtaskCallAdapterFactory();
    }

    private XtaskCallAdapterFactory() {
    }

    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (XtaskCallAdapterFactory.getRawType((Type)returnType) != Xtask.class) {
            return null;
        }
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalStateException("Xtask return type must be parameterized as Xtask<Foo> or Xtask<? extends Foo>");
        }
        Type innerType = XtaskCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)returnType));
        if (XtaskCallAdapterFactory.getRawType((Type)innerType) != Response.class) {
            return new BodyCallAdapter(innerType);
        }
        if (!(innerType instanceof ParameterizedType)) {
            throw new IllegalStateException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
        }
        Type responseType = XtaskCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)innerType));
        return new ResponseCallAdapter(responseType);
    }

    private static final class ResponseCallAdapter<R>
    implements CallAdapter<R, Xtask<Response<R>>> {
        private final Type responseType;

        ResponseCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        public Type responseType() {
            return this.responseType;
        }

        public Xtask<Response<R>> adapt(final Call<R> call) {
            return Xtask.supplyAsync((Supplier)new Supplier<Response<R>>(){

                public Response<R> get() throws Exception {
                    return call.execute();
                }
            }).ifCanceled(new Action(){

                public void run() throws Exception {
                    call.cancel();
                }
            });
        }
    }

    private static final class BodyCallAdapter<R>
    implements CallAdapter<R, Xtask<R>> {
        private final Type responseType;

        BodyCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        public Type responseType() {
            return this.responseType;
        }

        public Xtask<R> adapt(final Call<R> call) {
            return Xtask.supplyAsync((Supplier)new Supplier<R>(){

                public R get() throws Exception {
                    Response response = call.execute();
                    if (response.isSuccessful()) {
                        return response.body();
                    }
                    throw new HttpException(response);
                }
            }).ifCanceled(new Action(){

                public void run() throws Exception {
                    call.cancel();
                }
            });
        }
    }
}

