/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.searchbar.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.xm.uilibrary.R;
import java.util.List;

public class AreaCodeSearchBarAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<Bundle> dataList;
    private String currentContent;
    private int colorId = R.color.theme_color;
    private boolean isAreaCode = false;
    private OnSearchBarClickListener listener;

    public AreaCodeSearchBarAdapter(boolean isAreaCodeSearch) {
        this.isAreaCode = isAreaCodeSearch;
    }

    public AreaCodeSearchBarAdapter() {
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.xm_ui_area_code_adapter_search_bar, null));
    }

    @SuppressLint(value={"ResourceAsColor"})
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        Bundle bundle = this.dataList.get(position);
        if (bundle != null) {
            String title = bundle.getString("title");
            String content = bundle.getString("content");
            String areaCode = bundle.getString("areaCode");
            if (TextUtils.isEmpty((CharSequence)title)) {
                holder.tvTitle.setText((CharSequence)"");
                holder.tvTitle.setVisibility(8);
            } else {
                holder.tvTitle.setText((CharSequence)title);
                holder.tvTitle.setVisibility(0);
            }
            if (this.isAreaCode && areaCode != null) {
                holder.tvAreaCode.setVisibility(0);
                holder.tvAreaCode.setText((CharSequence)areaCode);
            } else {
                holder.tvAreaCode.setVisibility(8);
            }
            if (content != null) {
                if (content.equals(this.currentContent)) {
                    holder.tvContent.setTextColor(this.colorId);
                    if (holder.tvAreaCode.getVisibility() == 0) {
                        holder.tvAreaCode.setTextColor(this.colorId);
                    } else {
                        holder.ivCheck.setVisibility(0);
                    }
                } else {
                    holder.tvContent.setTextColor(R.color.black);
                    holder.tvAreaCode.setTextColor(R.color.black);
                    holder.ivCheck.setVisibility(8);
                }
                holder.tvContent.setText((CharSequence)content);
            }
        }
    }

    public int getItemCount() {
        return this.dataList == null ? 0 : this.dataList.size();
    }

    public void setDataList(List<Bundle> dataList) {
        this.dataList = dataList;
        this.notifyDataSetChanged();
    }

    public void setCurrentContent(String content) {
        this.currentContent = content;
    }

    public void setOnSearchBarClickListener(OnSearchBarClickListener listener) {
        this.listener = listener;
    }

    public void setColorId(int colorId) {
        this.colorId = colorId;
    }

    public static interface OnSearchBarClickListener {
        public void onClick(Bundle var1);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvTitle;
        TextView tvContent;
        ImageView ivCheck;
        TextView tvAreaCode;

        public ViewHolder(View itemView) {
            super(itemView);
            this.tvTitle = (TextView)itemView.findViewById(R.id.tv_title);
            this.tvContent = (TextView)itemView.findViewById(R.id.tv_content);
            this.ivCheck = (ImageView)itemView.findViewById(R.id.iv_check);
            this.tvAreaCode = (TextView)itemView.findViewById(R.id.tv_area_code);
            this.tvContent.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ViewHolder.this.getAdapterPosition() < AreaCodeSearchBarAdapter.this.dataList.size()) {
                        Bundle bundle = (Bundle)AreaCodeSearchBarAdapter.this.dataList.get(ViewHolder.this.getAdapterPosition());
                        if (AreaCodeSearchBarAdapter.this.listener != null) {
                            AreaCodeSearchBarAdapter.this.listener.onClick(bundle);
                        }
                    }
                }
            });
        }
    }
}

