/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.rotateloadingview.animcontroller;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import com.xm.ui.widget.dialog.IAnimController;
import com.xm.ui.widget.rotateloadingview.LoadingView;

public class RotateAnimController
implements IAnimController<LoadingView> {
    private static final int ANIMATION_DURATION = 300;
    private AnimatorSet mAnimatorSet = null;
    private static float mDistance = 1.0f;
    boolean isAnimRunning = false;
    LoadingView mLoadingView;
    Runnable rotateRunnable = new Runnable(){

        @Override
        public void run() {
            RotateAnimController.this.startRotate();
        }
    };

    @Override
    public void createAnim(LoadingView view) {
        this.mLoadingView = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAnim() {
        Runnable runnable = this.rotateRunnable;
        synchronized (runnable) {
            if (this.mLoadingView != null) {
                this.mLoadingView.removeCallbacks(this.rotateRunnable);
                this.mLoadingView.post(this.rotateRunnable);
                this.isAnimRunning = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRotate() {
        Runnable runnable = this.rotateRunnable;
        synchronized (runnable) {
            if (!this.isAnimRunning) {
                return;
            }
        }
        ObjectAnimator objectAnimator = new ObjectAnimator();
        objectAnimator.setDuration(300L);
        ObjectAnimator objectAnimator1 = null;
        switch (this.mLoadingView.getShape()) {
            case SHAPE_ONE: {
                objectAnimator1 = ObjectAnimator.ofFloat((Object)((Object)this.mLoadingView), (String)"translationY", (float[])new float[]{0.0f, mDistance});
                break;
            }
            case SHAPE_TWO: {
                objectAnimator1 = ObjectAnimator.ofFloat((Object)((Object)this.mLoadingView), (String)"translationX", (float[])new float[]{mDistance, 0.0f});
                break;
            }
            case SHAPE_THREE: {
                objectAnimator1 = ObjectAnimator.ofFloat((Object)((Object)this.mLoadingView), (String)"translationY", (float[])new float[]{mDistance, 0.0f});
                break;
            }
            case SHAPE_FOUR: {
                objectAnimator1 = ObjectAnimator.ofFloat((Object)((Object)this.mLoadingView), (String)"translationX", (float[])new float[]{0.0f, mDistance});
                break;
            }
            case SHAPE_FIVE: {
                objectAnimator1 = ObjectAnimator.ofFloat((Object)((Object)this.mLoadingView), (String)"translationX", (float[])new float[]{0.0f, mDistance});
            }
        }
        objectAnimator1.setDuration(300L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setDuration(300L);
        animatorSet.play((Animator)objectAnimator1);
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                RotateAnimController.this.mLoadingView.changeShape();
                RotateAnimController.this.startRotate();
            }

            public void onAnimationCancel(Animator animation) {
            }
        });
        animatorSet.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAnim() {
        Runnable runnable = this.rotateRunnable;
        synchronized (runnable) {
            if (this.mLoadingView != null) {
                this.mLoadingView.removeCallbacks(this.rotateRunnable);
            }
            this.isAnimRunning = false;
        }
    }

    @Override
    public LoadingView getLoadingView() {
        return this.mLoadingView;
    }
}

