/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.rectloadingview.animcontroller;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.LinearInterpolator;
import com.xm.ui.widget.dialog.IAnimController;
import com.xm.ui.widget.rectloadingview.RectLoadingView;

public class RandomAnimController
implements IAnimController<RectLoadingView> {
    private ValueAnimator[] animators;
    private RectLoadingView view;

    @Override
    public void createAnim(final RectLoadingView view) {
        this.view = view;
        this.animators = new ValueAnimator[view.getFractions().length];
        for (int i = 0; i < this.animators.length; ++i) {
            float min = (float)(0.1 + 0.2 * Math.random());
            float max = (float)(0.8 + 0.2 * Math.random());
            this.animators[i] = ValueAnimator.ofFloat((float[])new float[]{min, max});
            this.animators[i].setRepeatCount(-1);
            this.animators[i].setRepeatMode(2);
            this.animators[i].setDuration((long)((double)view.getDuration() * (0.7 + 0.6 * Math.random())));
            this.animators[i].setInterpolator((TimeInterpolator)new LinearInterpolator());
            final int finalI = i;
            this.animators[i].addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    view.setFraction(finalI, ((Float)animation.getAnimatedValue()).floatValue());
                }
            });
        }
    }

    @Override
    public void startAnim() {
        if (this.animators != null) {
            for (int i = 0; i < this.animators.length; ++i) {
                if (this.animators[i] == null) continue;
                this.animators[i].start();
            }
        }
    }

    @Override
    public void stopAnim() {
        if (this.animators != null) {
            for (int i = 0; i < this.animators.length; ++i) {
                if (this.animators[i] == null) continue;
                this.animators[i].cancel();
            }
        }
    }

    @Override
    public RectLoadingView getLoadingView() {
        return this.view;
    }
}

