/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.listselectitem.extra.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.xm.ui.widget.ListSelectItem;
import com.xm.ui.widget.listselectitem.extra.data.ItemData;
import com.xm.uilibrary.R;
import java.util.List;

public class ExtraSpinnerAdapter<T>
extends RecyclerView.Adapter<ViewHolder> {
    private List<ItemData<T>> dataList;
    private OnExtraSpinnerItemListener listener;
    private int selectedPos;
    private int adapterLayoutId = R.layout.xm_ui_item_extraspinner;
    private boolean mIsDarkMode;

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(this.adapterLayoutId, parent, false));
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        ItemData<T> itemData = this.dataList.get(position);
        if (itemData != null) {
            holder.lsiItem.setTitle(itemData.getKey());
        }
        if (this.selectedPos == position) {
            holder.lsiItem.setRightImage(1);
        } else {
            holder.lsiItem.setRightImage(0);
        }
        if (this.mIsDarkMode) {
            holder.lsiItem.setBackground(null);
            holder.lsiItem.setTitleColor(holder.lsiItem.getContext().getResources().getColor(R.color.white));
        } else {
            holder.lsiItem.setBackgroundColor(holder.lsiItem.getContext().getResources().getColor(R.color.white));
            holder.lsiItem.setTitleColor(holder.lsiItem.getContext().getResources().getColor(R.color.default_normal_text_color));
        }
    }

    public int getItemCount() {
        return this.dataList == null ? 0 : this.dataList.size();
    }

    public void setData(List<ItemData<T>> dataList) {
        this.dataList = dataList;
        this.notifyDataSetChanged();
    }

    public void setAdapterLayoutId(int adapterLayoutId) {
        if (adapterLayoutId != 0) {
            this.adapterLayoutId = adapterLayoutId;
        }
    }

    public void setSelectedPos(T value) {
        if (this.dataList != null && value != null) {
            for (int i = 0; i < this.dataList.size(); ++i) {
                ItemData<T> itemData = this.dataList.get(i);
                if (itemData == null || !value.equals(itemData.getValue())) continue;
                this.selectedPos = i;
                return;
            }
        }
    }

    public T getSelectedValue() {
        ItemData<T> itemData;
        if (this.dataList != null && this.selectedPos < this.dataList.size() && (itemData = this.dataList.get(this.selectedPos)) != null) {
            return itemData.getValue();
        }
        return null;
    }

    public String getSelectedName() {
        ItemData<T> itemData;
        if (this.dataList != null && this.selectedPos < this.dataList.size() && (itemData = this.dataList.get(this.selectedPos)) != null) {
            return itemData.getKey();
        }
        return "";
    }

    public void setIsDarkMode(boolean isDarkMode) {
        this.mIsDarkMode = isDarkMode;
        this.notifyDataSetChanged();
    }

    public void setOnExtraSpinnerItemListener(OnExtraSpinnerItemListener listener) {
        this.listener = listener;
    }

    public static interface OnExtraSpinnerItemListener<T> {
        public void onItemClick(int var1, String var2, T var3);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        ListSelectItem lsiItem;

        public ViewHolder(View itemView) {
            super(itemView);
            this.lsiItem = (ListSelectItem)itemView.findViewById(R.id.lsi_extra_spinner);
            this.lsiItem.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ItemData itemData;
                    ExtraSpinnerAdapter.this.selectedPos = ViewHolder.this.getAdapterPosition();
                    ExtraSpinnerAdapter.this.notifyDataSetChanged();
                    if (ExtraSpinnerAdapter.this.selectedPos >= 0 && ExtraSpinnerAdapter.this.dataList.size() > ExtraSpinnerAdapter.this.selectedPos && (itemData = (ItemData)ExtraSpinnerAdapter.this.dataList.get(ExtraSpinnerAdapter.this.selectedPos)) != null && ExtraSpinnerAdapter.this.listener != null) {
                        ExtraSpinnerAdapter.this.listener.onItemClick(ExtraSpinnerAdapter.this.selectedPos, itemData.getKey(), itemData.getValue());
                    }
                }
            });
        }
    }
}

