/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.drawgeometry.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.xm.ui.widget.drawgeometry.listener.GeometryInterface;
import com.xm.ui.widget.drawgeometry.listener.RevokeStateListener;
import com.xm.ui.widget.drawgeometry.model.GeometryInfo;
import com.xm.ui.widget.drawgeometry.model.GeometryPoints;
import com.xm.uilibrary.R;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class DrawGeometry
extends SurfaceView
implements View.OnTouchListener,
GeometryInterface {
    private static final int OPERATION_MOVE = 0;
    private static final int OPERATION_CHANGE_ONE_POINTS = 1;
    private static final int OPERATION_MERGE = 2;
    private static final int OPERATION_ROTATE = 3;
    private Paint mPaint;
    private GeometryInfo mGeometryInfo;
    private SurfaceHolder mHolder;
    private GeometryPoints mPoint;
    private int mOperationType = 0;
    private float mRotate;
    private float mScale = 1.0f;
    private int mRoateIco;
    private int mLineColorId;
    private int mGeometryType;
    private boolean mInit;
    private boolean mIsShowPoint = true;
    private boolean mIsShowRotate = true;
    private boolean mIsSupportOperation = true;
    private RevokeStateListener mRevokeStateListener;
    private int mDirection;
    private GeometryPoints[] mDefaultPoints;
    private int mDefaultDirection;
    private static final float MAX_SCALE = 2.0f;
    private static final float MIN_SCALE = 0.8f;
    private static final float MIN_SPCE = 10.0f;
    private static final int MIN_DISTANCE = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private float preScale;
    private float oldDist = 1.0f;
    private int mode = 0;
    private static final int TWINKLE_TIME = 200;
    private static final int MAX_TWINKLECOUNT = 20;
    private Timer mTimer;
    private int mTwinkleCount;

    public DrawGeometry(Context context) {
        super(context);
        this.init(null, 0);
    }

    public DrawGeometry(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public DrawGeometry(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        this.initAttributes(attrs, defStyleAttr);
        this.mHolder = this.getHolder();
        this.mGeometryInfo = new GeometryInfo();
        this.mPaint = new Paint();
        this.mPaint.setAlpha(100);
        this.mPaint.setColor(this.mLineColorId);
        this.mPaint.setStrokeWidth(3.0f);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        this.setFocusable(true);
        this.setOnTouchListener(this);
        this.setZOrderOnTop(true);
        this.mHolder.setFormat(-3);
    }

    private void initAttributes(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.DrawGeometry, defStyle, 0);
        this.mRoateIco = typedArray.getResourceId(R.styleable.DrawGeometry_rotate_ico, R.mipmap.ic_xm_ui_rotate);
        this.mLineColorId = typedArray.getColor(R.styleable.DrawGeometry_line_color, -65536);
        this.mGeometryType = typedArray.getInteger(R.styleable.DrawGeometry_geometry_type, 0);
        typedArray.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mGeometryInfo != null) {
            this.mGeometryInfo.setGeometryType(this.mGeometryType);
        }
    }

    private void initAreaLineDirection(int direction) {
        this.mDirection = direction;
    }

    private void initView() {
        if (this.mGeometryInfo.getGeometryType() != 0) {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mRoateIco);
            this.mGeometryInfo.createGeometry(this.mDefaultPoints, this.getWidth(), this.getHeight(), bitmap.getWidth(), bitmap.getHeight());
            this.drawGeometry();
            bitmap.recycle();
            bitmap = null;
            this.mInit = true;
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    private void drawGeometry() {
        Path linePath;
        Canvas canvas = this.mHolder.lockCanvas();
        if (null == canvas) {
            return;
        }
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        canvas.drawPaint(this.mPaint);
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
        Path path = this.mGeometryInfo.createGeometryPath();
        if (null != path) {
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setAlpha(50);
            canvas.drawPath(path, this.mPaint);
            this.mPaint.setStyle(Paint.Style.STROKE);
            if (this.mIsSupportOperation) {
                this.mPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{4.0f, 8.0f}, 1.0f));
            }
            this.mPaint.setAlpha(200);
            canvas.drawPath(path, this.mPaint);
        }
        if (this.mIsShowPoint && this.mIsSupportOperation) {
            for (int i = 0; i < this.mGeometryInfo.getPointsCount(); ++i) {
                GeometryPoints points = this.mGeometryInfo.getPoints(i);
                if (i == 0 && !this.mGeometryInfo.isClosed() && this.mGeometryInfo.getGeometryType() == 9) {
                    this.mPaint.setStyle(Paint.Style.STROKE);
                } else {
                    if (this.mGeometryInfo.getGeometryType() == 2 && (this.mGeometryInfo.getDirection() == 1 || this.mGeometryInfo.getDirection() == 2)) {
                        if (i == 0) {
                            this.mPaint.setColor(-16711936);
                        } else {
                            this.mPaint.setColor(this.mLineColorId);
                        }
                    }
                    this.mPaint.setStyle(Paint.Style.FILL);
                }
                this.mPaint.setPathEffect(null);
                canvas.drawCircle(points.x, points.y, 10.0f, this.mPaint);
            }
        }
        if (this.mGeometryInfo.getDirection() != 0 && null != (linePath = this.mGeometryInfo.getDirectionPath())) {
            this.mPaint.setStyle(Paint.Style.STROKE);
            canvas.drawPath(linePath, this.mPaint);
        }
        if (this.mIsSupportOperation && this.mIsShowRotate && this.mGeometryInfo.isSupportRotate()) {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mRoateIco);
            canvas.drawBitmap(bitmap, this.mGeometryInfo.getOperationPoints().x - (float)(bitmap.getWidth() / 2), this.mGeometryInfo.getOperationPoints().y - (float)(bitmap.getWidth() / 2), this.mPaint);
        }
        this.mHolder.unlockCanvasAndPost(canvas);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus && !this.mInit) {
            this.initView();
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (!this.mIsSupportOperation) {
            return false;
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                return this.touchDown(event);
            }
            case 2: {
                return this.touchMove(event);
            }
            case 1: 
            case 3: {
                this.touchUp(event);
                break;
            }
            case 6: {
                this.mode = 0;
                break;
            }
            case 5: {
                this.oldDist = this.spacing(event);
                if (!(this.oldDist > 10.0f)) break;
                this.mode = 2;
                break;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean touchDown(MotionEvent event) {
        this.mode = 1;
        this.mPoint = new GeometryPoints(event.getX(), event.getY());
        if (this.mGeometryInfo.pointIsIntersection(this.mPoint)) {
            this.mOperationType = this.mGeometryInfo.getGeometryType() == 9 ? (this.mGeometryInfo.isSelectedFirstItem() && this.mGeometryInfo.getPointsCount() >= 3 && !this.mGeometryInfo.isClosed() ? 2 : 1) : 1;
        } else if (!this.mGeometryInfo.pointInside(this.mPoint)) {
            if (this.mGeometryInfo.getGeometryType() == 9 && !this.mGeometryInfo.isClosed()) {
                this.mGeometryInfo.addCustomAllPoints(this.mPoint);
                this.drawGeometry();
            } else {
                if (!this.mGeometryInfo.isRotate(this.mPoint)) return false;
                this.mOperationType = 3;
            }
        } else {
            this.mOperationType = 0;
        }
        if (!this.mGeometryInfo.addOperationPointsToHistory() || this.mRevokeStateListener == null) return true;
        this.mRevokeStateListener.onRevokeEnable(true);
        return true;
    }

    private boolean touchMove(MotionEvent event) {
        if (this.mode == 2) {
            float newDist = this.spacing(event);
            if (newDist > 10.0f) {
                this.mScale = (float)Math.sqrt(newDist / this.oldDist);
                if (this.mGeometryInfo.setScale(this.mScale)) {
                    this.drawGeometry();
                }
            }
        } else if (this.mode == 1) {
            if (this.mOperationType == 0) {
                float moveX = event.getX() - this.mPoint.x;
                float moveY = event.getY() - this.mPoint.y;
                this.mGeometryInfo.moveAllPoints(moveX, moveY);
            } else if (this.mOperationType == 1) {
                this.mGeometryInfo.changeGeometry(this.mPoint);
            }
            if (this.mOperationType != 2) {
                this.drawGeometry();
                this.mPoint.x = event.getX();
                this.mPoint.y = event.getY();
                if (this.mOperationType == 3) {
                    this.mGeometryInfo.rotateCenterOfGeometry(this.mPoint);
                }
            }
        }
        return true;
    }

    private void touchUp(MotionEvent event) {
        if (!this.mGeometryInfo.isClosed() && this.mGeometryInfo.pointIsIntersection(this.mPoint) && this.mGeometryInfo.getGeometryType() == 9 && this.mGeometryInfo.isSelectedFirstItem() && this.mGeometryInfo.getPointsCount() >= 3) {
            this.mGeometryInfo.setClosed(true);
            this.mGeometryInfo.changeGeometry(this.mGeometryInfo.getPointsCount(), this.mGeometryInfo.getPoints(0));
            this.drawGeometry();
        }
        this.mPoint = null;
    }

    public int getGeometryType() {
        if (this.mGeometryInfo != null) {
            return this.mGeometryInfo.getGeometryType();
        }
        return -1;
    }

    private float spacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    public void setGeometryType(int type) {
        this.setGeometryType(type, null);
    }

    public boolean setGeometryType(int type, GeometryPoints[] points) {
        if (this.getWidth() != 0) {
            if (this.mGeometryInfo.addOperationPointsToHistory() && this.mRevokeStateListener != null) {
                this.mRevokeStateListener.onRevokeEnable(true);
            }
            this.mGeometryInfo.setGeometryType(type);
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mRoateIco);
            this.mGeometryInfo.createGeometry(points, this.getWidth(), this.getHeight(), bitmap.getWidth(), bitmap.getHeight());
            this.drawGeometry();
            if (!bitmap.isRecycled()) {
                bitmap.recycle();
                bitmap = null;
            }
            return true;
        }
        return false;
    }

    public void retreatToPreviousOperationPoints() {
        if (this.mGeometryInfo.retreatToPreviousOperationPoints()) {
            this.drawGeometry();
        }
        if (!this.mGeometryInfo.hasOperationHistoryPoints() && this.mRevokeStateListener != null) {
            this.mRevokeStateListener.onRevokeEnable(false);
        }
    }

    public void revertToDefaultPoints() {
        if (null != this.mDefaultPoints) {
            this.mGeometryInfo.clearOperationHistory(this.mDefaultPoints);
            GeometryPoints[] points = new GeometryPoints[this.mDefaultPoints.length];
            for (int i = 0; i < points.length; ++i) {
                try {
                    points[i] = this.mDefaultPoints[i].clone();
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            this.mDirection = this.mDefaultDirection;
            this.mGeometryInfo.setGeometryType(points.length);
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mRoateIco);
            this.mGeometryInfo.createGeometry(points, this.getWidth(), this.getHeight(), bitmap.getWidth(), bitmap.getHeight());
            this.mGeometryInfo.setDirection(this.mDirection);
            this.drawGeometry();
            bitmap.recycle();
            Object var2_3 = null;
        }
        if (this.mRevokeStateListener != null) {
            this.mRevokeStateListener.onRevokeEnable(false);
        }
    }

    public void initDirection(int direction) {
        this.mDefaultDirection = direction;
        this.setDirection(direction);
    }

    public void setDirection(int direction) {
        this.mDirection = direction;
        if (this.mGeometryInfo.setDirection(direction)) {
            this.drawGeometry();
        }
    }

    public int getDirection() {
        if (this.mGeometryInfo != null) {
            return this.mGeometryInfo.getDirection();
        }
        return -1;
    }

    public void setOnRevokeStateListener(RevokeStateListener revokeStateListener) {
        this.mRevokeStateListener = revokeStateListener;
    }

    public void setShowPoint(boolean isShowPoint) {
        this.mIsShowPoint = isShowPoint;
    }

    public void setShowRotate(boolean isShowRotate) {
        this.mIsShowRotate = isShowRotate;
    }

    public void rotateCenterOfPoints(float rotateAngle) {
        if (rotateAngle != 0.0f) {
            this.mGeometryInfo.rotateCenterOfPoints(new GeometryPoints(this.getWidth() / 2, this.getHeight() / 2), rotateAngle);
            this.drawGeometry();
        }
        this.drawGeometry();
    }

    public void setSupportOperation(boolean isSupportOperation) {
        this.mIsSupportOperation = isSupportOperation;
    }

    @Override
    public GeometryPoints[] getAllPoints() {
        if (null != this.mGeometryInfo) {
            return this.mGeometryInfo.getAllPoints();
        }
        return null;
    }

    @Override
    public List<GeometryPoints> getVertex() {
        return this.mGeometryInfo.getAllPoint();
    }

    @Override
    public void setGeometryPoints(GeometryPoints[] points) {
        if (points != null) {
            this.mDefaultPoints = new GeometryPoints[points.length];
            for (int i = 0; i < points.length; ++i) {
                try {
                    this.mDefaultPoints[i] = points[i].clone();
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            this.setGeometryType(points.length, points);
        }
    }

    public void setLineColor(int colorId) {
        this.mLineColorId = colorId;
        this.mPaint.setColor(this.mLineColorId);
    }

    public void setTwinkle(final int colorId) {
        if (null != this.mTimer) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (DrawGeometry.this.mTwinkleCount % 2 == 0) {
                    DrawGeometry.this.mPaint.setColor(colorId);
                } else {
                    DrawGeometry.this.mPaint.setColor(DrawGeometry.this.mLineColorId);
                }
                if (++DrawGeometry.this.mTwinkleCount >= 20) {
                    if (null != DrawGeometry.this.mTimer) {
                        DrawGeometry.this.mTimer.cancel();
                        DrawGeometry.this.mTimer = null;
                    }
                    DrawGeometry.this.mTwinkleCount = 0;
                    DrawGeometry.this.mPaint.setColor(DrawGeometry.this.mLineColorId);
                }
                DrawGeometry.this.drawGeometry();
            }
        }, 100L, 200L);
    }
}

