/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.DialogInterface;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.TextView;
import com.xm.uilibrary.R;

public class EditDialog
implements DialogInterface.OnDismissListener {
    private Dialog mDlg;
    private EditText mContentEdit;
    private TextView mConfirmButton;
    private TextView mCancelButton;
    private TextView mTitle;
    private static EditDialog mInstance;
    private boolean mIsPositive;
    private OnDismissListener mDismissLs;

    public static EditDialog getInstance(Context context) {
        if (null == mInstance || ((ContextWrapper)EditDialog.mInstance.mDlg.getContext()).getBaseContext() != context) {
            mInstance = new EditDialog(context);
        }
        return mInstance;
    }

    private EditDialog(Context context) {
        this.mDlg = new Dialog(context, R.style.custom_dialog);
        View layout2 = LayoutInflater.from((Context)context).inflate(R.layout.xm_ui_dialog_edit, null);
        this.mDlg.setContentView(layout2);
        this.mDlg.setCanceledOnTouchOutside(false);
        this.initView(layout2);
        Window window = this.mDlg.getWindow();
        WindowManager.LayoutParams p = window.getAttributes();
        DisplayMetrics dm = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(dm);
        p.width = (int)((double)dm.widthPixels * 0.8);
        window.setAttributes(p);
    }

    private void initView(View layout2) {
        this.mTitle = (TextView)layout2.findViewById(R.id.txtDigTitle);
        this.mCancelButton = (TextView)layout2.findViewById(R.id.btnDigCancel);
        this.mConfirmButton = (TextView)layout2.findViewById(R.id.btnDigOk);
        this.mContentEdit = (EditText)layout2.findViewById(R.id.editInputPass);
        this.mContentEdit.requestFocus();
    }

    public void setTitle(String title) {
        this.mTitle.setText((CharSequence)title);
        this.mContentEdit.setHint((CharSequence)title);
    }

    public String getInputText() {
        return this.mContentEdit.getText().toString();
    }

    public void setInputText(String s) {
        this.mContentEdit.setText((CharSequence)s);
        this.mContentEdit.setSelection(s.length());
    }

    public EditDialog setCancelable(boolean cancelable) {
        this.mDlg.setCancelable(cancelable);
        return this;
    }

    public EditDialog setPositiveButton(View.OnClickListener listener) {
        this.mConfirmButton.setOnClickListener(listener);
        return this;
    }

    public EditDialog setNegativeButton(View.OnClickListener listener) {
        this.mCancelButton.setOnClickListener(listener);
        return this;
    }

    public EditDialog setOnDismissListener(OnDismissListener listener) {
        this.mDismissLs = listener;
        this.mDlg.setOnDismissListener((DialogInterface.OnDismissListener)this);
        return this;
    }

    public void dismiss(boolean isPositive) {
        this.mIsPositive = isPositive;
        this.mDlg.dismiss();
    }

    public boolean isShowing() {
        return this.mDlg.isShowing();
    }

    public void show() {
        if (!this.mDlg.isShowing()) {
            this.mDlg.show();
        }
    }

    public void onDismiss(DialogInterface arg0) {
        if (null != this.mDismissLs) {
            this.mDismissLs.onDismiss(arg0, this.mIsPositive);
        }
    }

    public void setButtonTextColor(int cancelColor, int okColor) {
        if (cancelColor != 0) {
            this.mCancelButton.setTextColor(cancelColor);
        }
        if (okColor != 0) {
            this.mConfirmButton.setTextColor(okColor);
        }
    }

    public void setContentTextColor(int contentTextColor) {
        if (contentTextColor != 0) {
            this.mTitle.setTextColor(contentTextColor);
        }
    }

    public static interface OnEditContentListener {
        public void onResult(String var1);
    }

    public static interface OnDismissListener {
        public void onDismiss(DialogInterface var1, boolean var2);
    }
}

