/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.LinearInterpolator;
import androidx.annotation.Nullable;
import com.xm.uilibrary.R;

public class MoreSelectSwitch
extends View
implements View.OnTouchListener {
    private static final int SWITCH_DEFAULT_COUNT = 3;
    private Paint paint;
    private int switchCount = 3;
    private int openColorId;
    private int closeColorId;
    private int switchState = 0;
    private int animationWidth;
    private int animationAlpha;
    private int animationDuration;
    private int itemWidth;
    private int height;
    private int width;
    private int xPad;
    private int yPad;
    private ValueAnimator animators;
    private boolean isSupportGradient;
    private OnMoreSelSwitchClickListener onMoreSelSwitchClickListener;

    public MoreSelectSwitch(Context context) {
        this(context, null);
    }

    public MoreSelectSwitch(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MoreSelectSwitch(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.MoreSelectSwitch);
        if (params != null) {
            this.switchCount = params.getInteger(R.styleable.MoreSelectSwitch_SwitchCount, 3);
            this.openColorId = params.getResourceId(R.styleable.MoreSelectSwitch_OpenColor, context.getResources().getColor(R.color.theme_color));
            this.closeColorId = params.getResourceId(R.styleable.MoreSelectSwitch_CloseColor, context.getResources().getColor(R.color.btn_unselected));
            this.isSupportGradient = params.getBoolean(R.styleable.MoreSelectSwitch_SupportGradient, true);
            this.animationDuration = params.getInteger(R.styleable.MoreSelectSwitch_Duration, 200);
            params.recycle();
        }
        this.paint = new Paint();
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
        this.setClickable(true);
        this.setOnTouchListener(this);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.paint.setColor(this.closeColorId);
        canvas.drawArc(new RectF(0.0f, 0.0f, (float)this.itemWidth, (float)this.itemWidth), 90.0f, 180.0f, false, this.paint);
        canvas.drawRect(new RectF((float)(this.itemWidth / 2), 0.0f, (float)(this.width - this.itemWidth / 2), (float)this.itemWidth), this.paint);
        canvas.drawArc(new RectF((float)(this.width - this.itemWidth), 0.0f, (float)this.width, (float)this.itemWidth), 270.0f, 180.0f, false, this.paint);
        if (this.switchState >= 0) {
            this.paint.setColor(this.openColorId);
            if (this.isSupportGradient || this.switchState == 0) {
                this.paint.setAlpha(this.animationAlpha);
            } else {
                this.paint.setAlpha(255);
            }
            canvas.drawArc(new RectF(0.0f, 0.0f, (float)this.itemWidth, (float)this.itemWidth), 90.0f, 180.0f, false, this.paint);
            canvas.drawRect(new RectF((float)(this.itemWidth / 2), 0.0f, (float)(this.animationWidth + this.itemWidth / 2 + 1), (float)this.itemWidth), this.paint);
            canvas.drawArc(new RectF((float)this.animationWidth, 0.0f, (float)(this.animationWidth + this.itemWidth), (float)this.itemWidth), 270.0f, 180.0f, false, this.paint);
        }
        this.paint.setColor(-1);
        canvas.drawCircle((float)(this.animationWidth + this.itemWidth / 2), (float)(this.itemWidth / 2), (float)(this.itemWidth / 2 - 5), this.paint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.xPad = this.getPaddingLeft() + this.getPaddingRight();
        this.yPad = this.getPaddingTop() + this.getPaddingBottom();
        this.height = this.getMeasuredHeight();
        this.width = (this.height - this.yPad) * this.switchCount + this.xPad;
        this.itemWidth = this.width / this.switchCount;
        this.setMeasuredDimension(this.width, this.height);
        if (this.itemWidth > 0) {
            this.animationWidth = this.itemWidth * this.switchState;
            this.animationAlpha = this.animationWidth / (this.itemWidth * (this.switchCount - 1)) * 255;
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public int getSwitchCount() {
        return this.switchCount;
    }

    public void setSwitchCount(int switchCount) {
        if (this.switchCount == switchCount) {
            return;
        }
        this.switchCount = switchCount;
        this.width = (this.height - this.yPad) * switchCount + this.xPad;
        this.itemWidth = this.width / switchCount;
        if (this.width > 0) {
            this.getLayoutParams().width = this.width;
            this.requestLayout();
        }
        this.postInvalidate();
    }

    public int getSwitchState() {
        return this.switchState;
    }

    public void setSwitchState(int switchState, boolean isAnimator) {
        this.stopAnimator();
        int beforeSwitchState = this.switchState;
        this.switchState = switchState % this.switchCount;
        if (this.switchCount <= 1 || this.itemWidth <= 0) {
            return;
        }
        if (isAnimator) {
            this.startAnimator(beforeSwitchState, switchState);
        } else {
            this.animationWidth = switchState * this.itemWidth;
            this.animationAlpha = this.animationWidth / (this.itemWidth * (this.switchCount - 1)) * 255;
            this.postInvalidate();
        }
    }

    public void setOpenColorId(int colorId) {
        if (colorId != 0) {
            this.openColorId = colorId;
        }
    }

    public void setCloseColorId(int colorId) {
        if (colorId != 0) {
            this.closeColorId = colorId;
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (!this.isClickable()) {
            return false;
        }
        if (motionEvent.getAction() == 0) {
            this.stopAnimator();
            if (this.switchCount > 1 && this.itemWidth > 0) {
                this.animationWidth = this.switchState * this.itemWidth;
                this.animationAlpha = this.animationWidth / (this.itemWidth * (this.switchCount - 1)) * 255;
                this.postInvalidate();
            }
            int beforeSwitchState = this.switchState++;
            this.switchState = this.switchCount >= 3 ? (int)(motionEvent.getX() / (float)this.itemWidth) : (this.switchState %= this.switchCount);
            this.startAnimator(beforeSwitchState, this.switchState);
            if (this.onMoreSelSwitchClickListener != null) {
                this.onMoreSelSwitchClickListener.onMoreClick(this, this.switchCount, beforeSwitchState, this.switchState);
            }
        }
        return false;
    }

    private void startAnimator(int beforeSwitchState, int afterSwitchState) {
        if (this.itemWidth <= 0) {
            return;
        }
        if (beforeSwitchState == afterSwitchState) {
            return;
        }
        int startValue = beforeSwitchState * this.itemWidth;
        int endValue = afterSwitchState * this.itemWidth;
        this.animators = ValueAnimator.ofInt((int[])new int[]{startValue, endValue});
        this.animators.setDuration((long)this.animationDuration);
        this.animators.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.animators.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                MoreSelectSwitch.this.animationWidth = (Integer)animation.getAnimatedValue();
                MoreSelectSwitch.this.animationAlpha = (int)((float)MoreSelectSwitch.this.animationWidth * 1.0f / ((float)(MoreSelectSwitch.this.itemWidth * (MoreSelectSwitch.this.switchCount - 1)) * 1.0f) * 255.0f);
                MoreSelectSwitch.this.postInvalidate();
            }
        });
        this.animators.start();
    }

    private void stopAnimator() {
        if (this.animators != null) {
            this.animators.cancel();
            this.animators = null;
        }
    }

    public void setAnimationDuration(int animationDuration) {
        if (animationDuration > 0) {
            this.animationDuration = animationDuration;
        }
    }

    public int getAnimationDuration() {
        return this.animationDuration;
    }

    public void setOnMoreSelSwitchClickListener(OnMoreSelSwitchClickListener listener) {
        this.onMoreSelSwitchClickListener = listener;
    }

    public static interface OnMoreSelSwitchClickListener {
        public void onMoreClick(View var1, int var2, int var3, int var4);
    }
}

