/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.xm.MoreClickManager;
import com.xm.ui.widget.MoreSelectSwitch;
import com.xm.ui.widget.XCRoundRectImageView;
import com.xm.ui.widget.XTitleBar;
import com.xm.ui.widget.listselectitem.extra.adapter.ExtraSpinnerAdapter;
import com.xm.ui.widget.listselectitem.extra.view.ExtraSpinner;
import com.xm.ui.widget.rollerradiogroup.RollerRadioGroup;
import com.xm.uilibrary.R;
import java.util.HashMap;

public class ListSelectItem<T extends View, M>
extends LinearLayout
implements View.OnClickListener {
    private static final int EXTRA_MODE_NONE = 0;
    private static final int EXTRA_MODE_SEEKBAR = 1;
    private static final int EXTRA_MODE_ROLLER = 2;
    private static final int EXTRA_MODE_SPINNER = 3;
    private static final int EXTRA_MODE_FRAME_LAYOUT = 4;
    private XCRoundRectImageView _imageLeft = null;
    private ImageView _imageRight = null;
    private MoreSelectSwitch btnSwitch;
    private View mLine1;
    private View mLine2;
    private String _text;
    private String _tip;
    private String _right;
    private Boolean showClickRipper;
    private int _textColor;
    private int _tipColor;
    private int _rightColor;
    private int _rightValue;
    private int _lineColor;
    private int extraMode = 0;
    private int rightExViewId;
    private int tipExViewId;
    private int titleTextStyle;
    private float leftImgRadius;
    private int[] _imgLeftId = new int[2];
    private int[] _imgRightId = new int[2];
    private float leftImageWidth;
    private float leftImageHeight;
    private float rightImageWidth;
    private float rightImageHeight;
    private float contentPaddingTop;
    private float contentPaddingBottom;
    private float contentPaddingStart;
    private float contentPaddingEnd;
    private float rightTextRightPadding;
    private float _textSize;
    private float _tipSize;
    private float _rightSize;
    private float _lineMargin;
    private float leftMargin;
    private float tipPaddingTop;
    private boolean isShowTopLine;
    private boolean isShowBottomLine;
    private boolean rightClickable;
    private boolean mEnableFlag = true;
    private boolean isTitleTextSingleLine;
    private boolean isSingleClick;
    private int switchCount;
    private int switchOpenColorId;
    private int switchCloseColorId;
    private boolean isShowSwitch;
    private HashMap<Integer, Boolean> isViewVisibleMap;
    private ViewStub extraViewStub;
    private FrameLayout extraFrame;
    private SeekBar extraSeekbar;
    private RollerRadioGroup extraRoller;
    private LinearLayout leftContent;
    private LinearLayout contentLayout;
    private FrameLayout rightExtraViewLayout;
    private FrameLayout tipExtraViewLayout;
    private ExtraSpinner<M> extraSpinner;
    private OnLeftImageClickListener mOnLeftImageClickListener;
    private OnRightImageClickListener mOnRightImageClickListener;
    private View.OnClickListener mItemClickListener;
    private ExtraSpinnerAdapter.OnExtraSpinnerItemListener mOnExSpinnerItemLs;
    private T rightExView;
    private ViewGroup tipExView;

    public ListSelectItem(Context context) {
        this(context, null);
    }

    public ListSelectItem(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ListSelectItem(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        LayoutInflater.from((Context)context).inflate(R.layout.xm_ui_list_select_item, (ViewGroup)this, true);
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.ListSelectItem);
        this._imgLeftId[0] = params.getResourceId(R.styleable.ListSelectItem_ImageLeft1, 0);
        this._imgLeftId[1] = params.getResourceId(R.styleable.ListSelectItem_ImageLeft2, 0);
        this._imgRightId[0] = params.getResourceId(R.styleable.ListSelectItem_ImageRight1, 0);
        this._imgRightId[1] = params.getResourceId(R.styleable.ListSelectItem_ImageRight2, 0);
        this._rightValue = params.getResourceId(R.styleable.ListSelectItem_IconValue, 0);
        this.showClickRipper = params.getBoolean(R.styleable.ListSelectItem_ShowClickRipper, true);
        this._text = params.getString(R.styleable.ListSelectItem_Title);
        this._textColor = params.getColor(R.styleable.ListSelectItem_ItemTitleColor, 0);
        this._textSize = params.getDimension(R.styleable.ListSelectItem_ItemTitleSize, this.getResources().getDimension(R.dimen.normal_text_size));
        this.isTitleTextSingleLine = params.getBoolean(R.styleable.ListSelectItem_ItemTitleSingleLine, false);
        this._tipColor = params.getColor(R.styleable.ListSelectItem_ItemTipColor, this.getResources().getColor(R.color.hint_color));
        this._tip = params.getString(R.styleable.ListSelectItem_Tip);
        this.tipPaddingTop = params.getDimension(R.styleable.ListSelectItem_TipPaddingTop, 0.0f);
        this.rightImageWidth = params.getDimension(R.styleable.ListSelectItem_ImageRightWidth, 0.0f);
        this.rightImageHeight = params.getDimension(R.styleable.ListSelectItem_ImageRightHeight, 0.0f);
        this._tipSize = params.getDimension(R.styleable.ListSelectItem_ItemTipSize, this.getResources().getDimension(R.dimen.bottom_tip_text_size));
        this._right = params.getString(R.styleable.ListSelectItem_Cap);
        this._rightColor = params.getColor(R.styleable.ListSelectItem_CapColor, 0);
        this._rightSize = params.getDimension(R.styleable.ListSelectItem_CapSize, this.getResources().getDimension(R.dimen.item_right_cap_size));
        this._lineColor = params.getColor(R.styleable.ListSelectItem_LineColor, 0);
        this._lineMargin = params.getDimension(R.styleable.ListSelectItem_LineMargin, 0.0f);
        this.extraMode = params.getInt(R.styleable.ListSelectItem_ExtraMode, 0);
        this.leftMargin = params.getDimension(R.styleable.ListSelectItem_leftMargin, (float)this.dp2px(8));
        this.rightExViewId = params.getResourceId(R.styleable.ListSelectItem_RightExtraViewLayout, 0);
        this.tipExViewId = params.getResourceId(R.styleable.ListSelectItem_TipExtraViewLayout, 0);
        this.rightClickable = params.getBoolean(R.styleable.ListSelectItem_RightClickable, true);
        this.isShowTopLine = params.getBoolean(R.styleable.ListSelectItem_ShowTopLine, true);
        this.isShowBottomLine = params.getBoolean(R.styleable.ListSelectItem_ShowBottomLine, false);
        this.contentPaddingStart = params.getDimension(R.styleable.ListSelectItem_android_paddingStart, (float)this.dp2px(15));
        this.contentPaddingEnd = params.getDimension(R.styleable.ListSelectItem_android_paddingEnd, (float)this.dp2px(15));
        this.contentPaddingTop = params.getDimension(R.styleable.ListSelectItem_contentPaddingTop, (float)this.dp2px(0));
        this.contentPaddingBottom = params.getDimension(R.styleable.ListSelectItem_contentPaddingBottom, (float)this.dp2px(0));
        this.rightTextRightPadding = params.getDimension(R.styleable.ListSelectItem_rightTextRightPadding, (float)this.dp2px(0));
        this.leftImageWidth = params.getDimension(R.styleable.ListSelectItem_ImageLeftWidth, 0.0f);
        this.leftImageHeight = params.getDimension(R.styleable.ListSelectItem_ImageLeftHeight, 0.0f);
        this.isSingleClick = params.getBoolean(R.styleable.ListSelectItem_singleClick, false);
        this.titleTextStyle = params.getInt(R.styleable.ListSelectItem_android_textStyle, 0);
        this.switchCount = params.getInt(R.styleable.ListSelectItem_SwitchCount, 2);
        this.switchOpenColorId = params.getColor(R.styleable.ListSelectItem_OpenColor, context.getResources().getColor(R.color.theme_color));
        this.switchCloseColorId = params.getResourceId(R.styleable.ListSelectItem_OpenColor, context.getResources().getColor(R.color.btn_unselected));
        this.isShowSwitch = params.getBoolean(R.styleable.ListSelectItem_ShowSwitch, false);
        params.recycle();
    }

    protected void onFinishInflate() {
        ViewGroup.LayoutParams layoutParams;
        TextView tvRight;
        TextView tvTip;
        TextView tv;
        super.onFinishInflate();
        if (this.extraMode != 0) {
            this.extraViewStub = (ViewStub)this.findViewById(R.id.extra_view_stub);
            this.extraViewStub.setPadding((int)this.contentPaddingStart, 0, (int)this.contentPaddingEnd, 0);
            this.extraViewStub.inflate();
            this.extraFrame = (FrameLayout)this.findViewById(R.id.extra_content);
            this.extraSeekbar = (SeekBar)this.findViewById(R.id.extra_seekbar);
            this.extraRoller = (RollerRadioGroup)this.findViewById(R.id.extra_roller);
            this.extraSpinner = (ExtraSpinner)this.findViewById(R.id.extra_spinner);
            this.extraSeekbar.setVisibility(this.extraMode == 1 ? 0 : 8);
            this.extraRoller.setVisibility(this.extraMode == 2 ? 0 : 8);
            this.extraSpinner.setVisibility(this.extraMode == 3 ? 0 : 8);
            this.setupExtraView();
        }
        this.contentLayout = (LinearLayout)this.findViewById(R.id.ll_content);
        this.contentLayout.setPadding((int)this.contentPaddingStart, (int)this.contentPaddingTop, (int)this.contentPaddingEnd, (int)this.contentPaddingBottom);
        this.leftContent = (LinearLayout)this.findViewById(R.id.left_content);
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.leftContent.getLayoutParams();
        params.leftMargin = (int)this.leftMargin;
        this._imageLeft = (XCRoundRectImageView)this.findViewById(R.id.icon);
        if (this._imageLeft != null) {
            this._imageLeft.setImageResource(this._imgLeftId[this._rightValue]);
        }
        this._imageRight = (ImageView)this.findViewById(R.id.icon2);
        if (this._imageRight != null) {
            if (this._imgRightId[0] == 0 && this._imgRightId[1] == 0) {
                this._imageRight.setVisibility(8);
            } else {
                this._imageRight.setVisibility(0);
                this._imageRight.setImageResource(this._imgRightId[this._rightValue]);
                this._imageRight.setClickable(this.rightClickable);
            }
        }
        this.btnSwitch = (MoreSelectSwitch)this.findViewById(R.id.btn_switch);
        if (this.btnSwitch != null) {
            this.btnSwitch.setSwitchCount(this.switchCount);
            this.btnSwitch.setOpenColorId(this.switchOpenColorId);
            this.btnSwitch.setCloseColorId(this.switchCloseColorId);
            this.btnSwitch.setClickable(this.rightClickable);
        }
        if (this.isShowSwitch) {
            this._imageRight.setVisibility(8);
            this.btnSwitch.setVisibility(0);
        } else {
            this.btnSwitch.setVisibility(8);
        }
        this.rightExtraViewLayout = (FrameLayout)this.findViewById(R.id.right_ex_view_layout);
        if (this.rightExViewId != 0) {
            LayoutInflater.from((Context)this.getContext()).inflate(this.rightExViewId, (ViewGroup)this.rightExtraViewLayout, true);
            this.rightExView = this.rightExtraViewLayout.getChildAt(0);
            this.rightExtraViewLayout.setVisibility(0);
            this._imageRight.setVisibility(8);
        }
        this.tipExtraViewLayout = (FrameLayout)this.findViewById(R.id.tip_ex_view_layout);
        if (this.tipExViewId != 0) {
            LayoutInflater.from((Context)this.getContext()).inflate(this.tipExViewId, (ViewGroup)this.tipExtraViewLayout, true);
            this.tipExView = (ViewGroup)this.tipExtraViewLayout.getChildAt(0);
            this.tipExtraViewLayout.setVisibility(0);
        }
        if ((tv = (TextView)this.findViewById(R.id.tv)) != null) {
            if (this._text != null) {
                tv.setText((CharSequence)this._text);
            }
            tv.setTextColor(this._textColor);
            tv.setTextSize(0, this._textSize);
            tv.setSingleLine(this.isTitleTextSingleLine);
            tv.setTypeface(Typeface.defaultFromStyle((int)this.titleTextStyle));
        }
        if ((tvTip = (TextView)this.findViewById(R.id.tv_tip)) != null) {
            String text = this._tip;
            if (TextUtils.isEmpty((CharSequence)text)) {
                tvTip.setVisibility(8);
            } else {
                tvTip.setVisibility(0);
                tvTip.setText((CharSequence)text);
                if (this.tipPaddingTop != 0.0f) {
                    tvTip.setPadding(0, (int)this.tipPaddingTop, 0, 0);
                }
            }
            tvTip.setTextColor(this._tipColor);
            tvTip.setTextSize(0, this._tipSize);
        }
        if ((tvRight = (TextView)this.findViewById(R.id.tv_right)) != null) {
            if (this._right == null) {
                tvRight.setVisibility(8);
            } else {
                tvRight.setVisibility(0);
                tvRight.setText((CharSequence)this._right);
            }
            tvRight.setTextColor(this._rightColor);
            tvRight.setTextSize(0, this._rightSize);
            tvRight.setPadding(0, 0, (int)this.rightTextRightPadding, 0);
        }
        this.mLine1 = this.findViewById(R.id.line1);
        if (this.isShowTopLine && this._lineColor != 0 && this.mLine1 != null) {
            this.mLine1.setBackgroundColor(this._lineColor);
        }
        this.mLine2 = this.findViewById(R.id.line2);
        if (this.isShowBottomLine && this._lineColor != 0 && this.mLine2 != null) {
            this.mLine2.setBackgroundColor(this._lineColor);
        }
        if (this._lineMargin != 0.0f) {
            if (this.mLine1 != null) {
                ((ViewGroup.MarginLayoutParams)this.mLine1.getLayoutParams()).leftMargin = (int)this._lineMargin;
                ((ViewGroup.MarginLayoutParams)this.mLine1.getLayoutParams()).rightMargin = (int)this._lineMargin;
            }
            if (this.mLine2 != null) {
                ((ViewGroup.MarginLayoutParams)this.mLine2.getLayoutParams()).leftMargin = (int)this._lineMargin;
                ((ViewGroup.MarginLayoutParams)this.mLine2.getLayoutParams()).rightMargin = (int)this._lineMargin;
            }
        }
        if (this.rightClickable) {
            this._imageRight.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ListSelectItem.this.mEnableFlag) {
                        ListSelectItem.this._rightValue = ListSelectItem.this._rightValue == 0 ? 1 : 0;
                        ListSelectItem.this._imageRight.setImageResource(ListSelectItem.this._imgRightId[ListSelectItem.this._rightValue]);
                        ListSelectItem.this.toggleExtraView(ListSelectItem.this._rightValue == 0);
                        if (ListSelectItem.this.mOnRightImageClickListener != null) {
                            ListSelectItem.this.mOnRightImageClickListener.onClick(ListSelectItem.this, v);
                        }
                    }
                }
            });
        }
        if (this.leftImageWidth != 0.0f && (layoutParams = this._imageLeft.getLayoutParams()) != null) {
            layoutParams.width = (int)this.leftImageWidth;
        }
        if (this.leftImageHeight != 0.0f && (layoutParams = this._imageLeft.getLayoutParams()) != null) {
            layoutParams.height = (int)this.leftImageHeight;
        }
        if (this.rightImageWidth != 0.0f) {
            layoutParams = this._imageLeft.getLayoutParams();
            layoutParams = this._imageRight.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.width = (int)this.rightImageWidth;
            }
        }
        if (this.rightImageHeight != 0.0f) {
            layoutParams = this._imageLeft.getLayoutParams();
            layoutParams = this._imageRight.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.height = (int)this.rightImageHeight;
            }
        }
        if (this.leftImgRadius > 0.0f) {
            this._imageLeft.setImageRadius(this.leftImgRadius);
        }
    }

    public void setLeftImageBackgroundColor(String colorValue) {
        this._imageLeft.setBackgroundColor(Color.parseColor((String)colorValue));
    }

    private void setupExtraView() {
        if (this.extraMode == 1) {
            this.extraSeekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

                public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                    TextView tvRight = (TextView)ListSelectItem.this.findViewById(R.id.tv_right);
                    if (tvRight != null) {
                        tvRight.setText((CharSequence)("" + progress));
                    }
                }

                public void onStartTrackingTouch(SeekBar seekBar) {
                }

                public void onStopTrackingTouch(SeekBar seekBar) {
                }
            });
        } else if (this.extraMode == 2) {
            this.extraRoller.setOnRollerListener(new RollerRadioGroup.OnRollerListener(){

                @Override
                public void onItemSelected(RollerRadioGroup v, int selectedId, int lastSelectedId) {
                    String s = v.getData().get(selectedId);
                    TextView tvRight = (TextView)ListSelectItem.this.findViewById(R.id.tv_right);
                    if (tvRight != null) {
                        tvRight.setText((CharSequence)("" + s));
                    }
                }
            });
        } else if (this.extraMode == 3) {
            this.extraSpinner.setOnExtraSpinnerItemListener(new ExtraSpinnerAdapter.OnExtraSpinnerItemListener(){

                public void onItemClick(int position, String key, Object value) {
                    TextView tvRight = (TextView)ListSelectItem.this.findViewById(R.id.tv_right);
                    if (tvRight != null) {
                        tvRight.setText((CharSequence)key);
                    }
                    ListSelectItem.this.toggleExtraView(true);
                    if (ListSelectItem.this.mOnExSpinnerItemLs != null) {
                        ListSelectItem.this.mOnExSpinnerItemLs.onItemClick(position, key, value);
                    }
                }
            });
        }
    }

    public void toggleExtraView(boolean close) {
        this.toggleExtraView(close, this.getRootView());
    }

    public void toggleExtraView(boolean close, View rootLayout) {
        if (this.extraMode != 0) {
            this.extraFrame.setVisibility(close ? 8 : 0);
            this._rightValue = close ? 0 : 1;
            this._imageRight.setImageResource(this._imgRightId[this._rightValue]);
            if (close) {
                this.setShowBottomLine(this.isShowBottomLine);
            } else {
                if (this._lineColor != 0 && this.mLine2 != null) {
                    this.mLine2.setBackgroundColor(this._lineColor);
                }
                this.mLine2.setVisibility(0);
            }
            if (this.isViewVisibleMap == null) {
                this.isViewVisibleMap = new HashMap();
            }
            this.dealWithHideShowExtraView(close, rootLayout, (ViewGroup)this);
        }
    }

    public void toggleExtraView() {
        if (this.extraMode != 0) {
            boolean close = this.extraFrame.getVisibility() == 0;
            this.toggleExtraView(close);
        }
    }

    public void toggleExtraView(View rootLayout) {
        if (this.extraMode != 0) {
            boolean close = this.extraFrame.getVisibility() == 0;
            this.toggleExtraView(close, rootLayout);
        }
    }

    public boolean isExtraViewShow() {
        if (this.extraFrame == null) {
            return false;
        }
        return this.extraFrame.getVisibility() == 0;
    }

    private void dealWithHideShowExtraView(boolean isClose, View rootLayout, ViewGroup layout2) {
        ViewGroup parentLayout;
        if (layout2 != null && (parentLayout = (ViewGroup)layout2.getParent()) != null && parentLayout != rootLayout) {
            int childCount = parentLayout.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View childView = parentLayout.getChildAt(i);
                if (childView == null || childView == this || childView == layout2) continue;
                if (XTitleBar.class.getSimpleName().equals(childView.getClass().getSimpleName())) {
                    if (!this.isShowTopLine) continue;
                    if (isClose) {
                        Boolean isShow;
                        if (!this.isViewVisibleMap.containsKey(childView.hashCode()) || (isShow = this.isViewVisibleMap.get(childView.hashCode())) == null) continue;
                        ((XTitleBar)childView).setShowBottomLine(isShow);
                        continue;
                    }
                    this.isViewVisibleMap.put(childView.hashCode(), ((XTitleBar)childView).isShowBottomLine());
                    ((XTitleBar)childView).setShowBottomLine(false);
                    continue;
                }
                if (isClose) {
                    if (!this.isViewVisibleMap.containsKey(childView.hashCode())) continue;
                    childView.setVisibility(0);
                    childView.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.show));
                    this.isViewVisibleMap.remove(childView.hashCode());
                    continue;
                }
                if (childView.getVisibility() == 0) {
                    this.isViewVisibleMap.put(childView.hashCode(), true);
                }
                childView.setVisibility(8);
            }
            this.dealWithHideShowExtraView(isClose, rootLayout, parentLayout);
        }
    }

    public ViewGroup getExtraFrameLayout() {
        return this.extraFrame;
    }

    public int getRightValue() {
        return this._rightValue;
    }

    public void setLeftImage(int i) {
        this._rightValue = i;
        this._imageLeft.setImageResource(this._imgLeftId[i]);
    }

    public void setLeftImageResource(int resId) {
        if (resId != 0) {
            this._imgLeftId[0] = resId;
            this._imgLeftId[1] = resId;
            if (this._imageLeft == null) {
                this._imageLeft = (XCRoundRectImageView)this.findViewById(R.id.icon);
            }
            this._imageLeft.setImageResource(resId);
        }
    }

    public void setRightImageResource(int resId) {
        if (resId != 0) {
            this._imgRightId[0] = resId;
            this._imgRightId[1] = resId;
            if (this._imageRight == null) {
                this._imageRight = (ImageView)this.findViewById(R.id.icon2);
            }
            this._imageRight.setImageResource(resId);
        }
    }

    public ImageView getImageLeft() {
        return this._imageLeft;
    }

    public void setRightImage(int rightValue) {
        this._rightValue = rightValue;
        this._imageRight.setImageResource(this._imgRightId[rightValue]);
    }

    public ImageView getRightImageView() {
        return this._imageRight;
    }

    public void setRightImageVisibility(int visiable) {
        this._imageRight.setVisibility(visiable);
    }

    public void setRightClickEnable(boolean enable) {
        this._imageRight.setEnabled(enable);
        this._imageRight.setClickable(enable);
    }

    public void setOnLeftClick(OnLeftImageClickListener mOnLeftClickListener) {
        this.mOnLeftImageClickListener = mOnLeftClickListener;
    }

    public void setOnRightClick(OnRightImageClickListener mOnRightClickListener) {
        this.mOnRightImageClickListener = mOnRightClickListener;
    }

    public void onClick(View v) {
        boolean isMoreClick;
        if (this.isSingleClick && (isMoreClick = MoreClickManager.getInstance().isMoreClick(v.hashCode()))) {
            return;
        }
        if (this.mItemClickListener != null) {
            this.mItemClickListener.onClick(v);
        }
    }

    public String getRightText() {
        TextView tv_r = (TextView)this.findViewById(R.id.tv_right);
        if (tv_r != null) {
            return tv_r.getText().toString();
        }
        return null;
    }

    public View getRightView() {
        return (TextView)this.findViewById(R.id.tv_right);
    }

    public void setRightText(CharSequence right) {
        try {
            TextView tv_r = (TextView)this.findViewById(R.id.tv_right);
            if (right != null && tv_r != null) {
                tv_r.setText(right);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEnable(Boolean flag) {
        this.mEnableFlag = flag;
    }

    public void setTitle(String title) {
        if (title != null) {
            TextView tv = (TextView)this.findViewById(R.id.tv);
            tv.setText((CharSequence)title);
        }
    }

    public String getTitle() {
        TextView tv = (TextView)this.findViewById(R.id.tv);
        return tv.getText().toString();
    }

    public void setTitleColor(int color2) {
        TextView tv = (TextView)this.findViewById(R.id.tv);
        tv.setTextColor(color2);
    }

    public void setTip(String tip) {
        TextView tvTip = (TextView)this.findViewById(R.id.tv_tip);
        if (tip != null) {
            tvTip.setTextColor(this._tipColor);
            tvTip.setTextSize(0, this._tipSize);
            tvTip.setText((CharSequence)tip);
            if (!TextUtils.isEmpty((CharSequence)tip)) {
                tvTip.setVisibility(0);
            } else {
                tvTip.setVisibility(8);
            }
        } else {
            tvTip.setVisibility(8);
        }
    }

    public String getTip() {
        TextView tvTip = (TextView)this.findViewById(R.id.tv_tip);
        return tvTip.getText().toString();
    }

    public void setTipColor(int colorId) {
        this._tipColor = colorId;
        TextView tvTip = (TextView)this.findViewById(R.id.tv_tip);
        if (tvTip != null) {
            tvTip.setTextColor(colorId);
        }
    }

    public void setRightImage(Bitmap bmp) {
        this._imageRight.setImageBitmap(bmp);
    }

    public void setRightTextColor(int color2) {
        TextView tv_r = (TextView)this.findViewById(R.id.tv_right);
        tv_r.setTextColor(color2);
    }

    public SeekBar getExtraSeekbar() {
        if (this.extraMode != 1) {
            throw new RuntimeException("extraMode = " + this.extraMode + " \uff0c\u4e0d\u5e94\u8be5\u83b7\u53d6ExtraSeekbar");
        }
        return this.extraSeekbar;
    }

    public RollerRadioGroup getExtraRoller() {
        if (this.extraMode != 2) {
            throw new RuntimeException("extraMode = " + this.extraMode + "\uff0c\u4e0d\u5e94\u8be5\u83b7\u53d6ExtraRoller");
        }
        return this.extraRoller;
    }

    public ExtraSpinner<M> getExtraSpinner() {
        if (this.extraMode != 3) {
            throw new RuntimeException("extraMode = " + this.extraMode + "\uff0c\u4e0d\u5e94\u8be5\u83b7\u53d6ExtraSpinner");
        }
        return this.extraSpinner;
    }

    public M getExtraRightValue() {
        if (this.extraSpinner != null) {
            return this.extraSpinner.getSelectedValue();
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        this._imageRight = (ImageView)this.findViewById(R.id.icon2);
        this._imageRight.setEnabled(enabled);
        this._imageLeft = (XCRoundRectImageView)this.findViewById(R.id.icon);
        this._imageLeft.setEnabled(enabled);
        TextView tv = (TextView)this.findViewById(R.id.tv);
        tv.setEnabled(enabled);
        if (tv != null) {
            tv.setTextColor(enabled ? this._textColor : this.getResources().getColor(R.color.line_color));
        }
        TextView tvTip = (TextView)this.findViewById(R.id.tv_tip);
        tvTip.setEnabled(enabled);
        if (tvTip != null) {
            tvTip.setTextColor(enabled ? this._tipColor : this.getResources().getColor(R.color.line_color));
        }
        TextView tvRight = (TextView)this.findViewById(R.id.tv_right);
        tvRight.setEnabled(enabled);
        if (tvRight != null) {
            tvRight.setTextColor(enabled ? this._rightColor : this.getResources().getColor(R.color.line_color));
        }
        if (this.rightExView != null) {
            this.rightExView.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public T getRightExtraView() {
        return this.rightExView;
    }

    public ViewGroup getTipExView() {
        return this.tipExView;
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setRightViewPaddings(int left, int top, int right, int bottom) {
        if (this._imageRight != null) {
            this._imageRight.setPadding(left, top, right, bottom);
        }
    }

    public void setLeftImgRadius(float radius) {
        this.leftImgRadius = radius;
        if (this._imageLeft != null) {
            this._imageLeft.setImageRadius(radius);
        }
    }

    public void setOnClickListener(@Nullable View.OnClickListener listener) {
        if (this.showClickRipper.booleanValue()) {
            try {
                if (this.getBackground() == null) {
                    TypedValue typedValue = new TypedValue();
                    this.getContext().getTheme().resolveAttribute(16843534, typedValue, true);
                    int[] attribute = new int[]{16843534};
                    TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(typedValue.resourceId, attribute);
                    Drawable drawable2 = typedArray.getDrawable(0);
                    this.setBackground(drawable2);
                    typedArray.recycle();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mItemClickListener = listener;
        super.setOnClickListener((View.OnClickListener)this);
    }

    public void setShowBottomLine(boolean isShowBottomLine) {
        this.isShowBottomLine = isShowBottomLine;
        if (this._lineColor != 0 && this.mLine2 != null) {
            this.mLine2.setBackgroundColor(this._lineColor);
        }
        this.mLine2.setVisibility(isShowBottomLine ? 0 : 8);
    }

    public void setShowTopLine(boolean isShowTopLine) {
        this.isShowTopLine = isShowTopLine;
        if (this._lineColor != 0 && this.mLine1 != null) {
            this.mLine1.setBackgroundColor(this._lineColor);
        }
        this.mLine1.setVisibility(isShowTopLine ? 0 : 8);
    }

    public void setSwitchState(int switchState) {
        this.setSwitchState(switchState, true);
    }

    public void setSwitchState(int switchState, boolean isAnimator) {
        if (this.isShowSwitch && this.btnSwitch != null) {
            this.btnSwitch.setSwitchState(switchState, isAnimator);
        }
    }

    public int getSwitchState() {
        if (this.isShowSwitch && this.btnSwitch != null) {
            return this.btnSwitch.getSwitchState();
        }
        return 0;
    }

    public void setOnMoreSelSwitchClickListener(MoreSelectSwitch.OnMoreSelSwitchClickListener onMoreSelSwitchClickListener) {
        if (this.isShowSwitch && this.btnSwitch != null) {
            this.btnSwitch.setOnMoreSelSwitchClickListener(onMoreSelSwitchClickListener);
        }
    }

    public void setOnExtraSpinnerItemListener(ExtraSpinnerAdapter.OnExtraSpinnerItemListener onExtraSpinnerItemListener) {
        this.mOnExSpinnerItemLs = onExtraSpinnerItemListener;
    }

    public void setTitleMaxLines(int lines) {
        TextView tv = (TextView)this.findViewById(R.id.tv);
        tv.setMaxLines(lines);
    }

    public void setTipsMaxLines(int lines) {
        TextView tvTip = (TextView)this.findViewById(R.id.tv_tip);
        tvTip.setMaxLines(lines);
    }

    public void setRightTextMaxLines(int lines) {
        TextView tvRight = (TextView)this.findViewById(R.id.tv_right);
        tvRight.setMaxLines(lines);
    }

    public void setTitleTextStyle(int style) {
        this.titleTextStyle = style;
        TextView tvTitle = (TextView)this.findViewById(R.id.tv);
        if (tvTitle != null) {
            tvTitle.setTypeface(Typeface.defaultFromStyle((int)this.titleTextStyle));
            tvTitle.requestLayout();
        }
    }

    public static interface OnRightImageClickListener {
        public void onClick(ListSelectItem var1, View var2);
    }

    public static interface OnLeftImageClickListener {
        public void onClick(ListSelectItem var1, View var2);
    }
}

