/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xm.uilibrary.R;

public class ItemSetLayout
extends RelativeLayout {
    private int leftTitleSrcId;
    private ImageView leftTitleIv;
    private TextView leftTitleTv;
    private RelativeLayout mainLayout;
    private LinearLayout contentLayout;
    private int mainLayoutId;
    private float leftTitleSize;
    private int leftTitleColorId;
    private String leftTitleText;
    private boolean isShowLeftLine;
    private int contentPaddingStart;
    private int contentPaddingEnd;
    private int contentPaddingTop;
    private int contentPaddingBottom;

    public ItemSetLayout(Context context) {
        this(context, null);
    }

    public ItemSetLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ItemSetLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.xm_ui_layout_item_set, (ViewGroup)this, true);
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.ItemSetLayout);
        this.leftTitleSrcId = params.getResourceId(R.styleable.ItemSetLayout_left_src, R.mipmap.line);
        this.mainLayoutId = params.getResourceId(R.styleable.ItemSetLayout_main_layout, 0);
        this.leftTitleSize = params.getDimension(R.styleable.ItemSetLayout_android_textSize, 0.0f);
        this.leftTitleColorId = params.getColor(R.styleable.ItemSetLayout_android_textColor, -16777216);
        this.leftTitleText = params.getString(R.styleable.ItemSetLayout_left_title_text);
        this.isShowLeftLine = params.getBoolean(R.styleable.ItemSetLayout_show_left_line, true);
        this.contentPaddingStart = (int)params.getDimension(R.styleable.ItemSetLayout_contentPaddingStart, this.getResources().getDimension(R.dimen.half_of_normal_padding));
        this.contentPaddingEnd = (int)params.getDimension(R.styleable.ItemSetLayout_contentPaddingEnd, this.getResources().getDimension(R.dimen.half_of_normal_padding));
        this.contentPaddingTop = (int)params.getDimension(R.styleable.ItemSetLayout_contentPaddingTop, this.getResources().getDimension(R.dimen.half_of_normal_padding));
        this.contentPaddingBottom = (int)params.getDimension(R.styleable.ItemSetLayout_contentPaddingBottom, this.getResources().getDimension(R.dimen.half_of_normal_padding));
        params.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.leftTitleIv = (ImageView)this.findViewById(R.id.ver_line);
        this.leftTitleTv = (TextView)this.findViewById(R.id.left_title_tv);
        this.leftTitleIv.setImageResource(this.leftTitleSrcId);
        this.mainLayout = (RelativeLayout)this.findViewById(R.id.main_layout);
        this.contentLayout = (LinearLayout)this.findViewById(R.id.ll_content);
        if (this.mainLayoutId != 0) {
            LayoutInflater.from((Context)this.getContext()).inflate(this.mainLayoutId, (ViewGroup)this.mainLayout, true);
        }
        if (this.leftTitleColorId != 0) {
            this.leftTitleTv.setTextColor(this.leftTitleColorId);
        }
        if (this.leftTitleSize != 0.0f) {
            this.leftTitleTv.setTextSize(0, this.leftTitleSize);
        }
        if (this.leftTitleText != null) {
            this.leftTitleTv.setText((CharSequence)this.leftTitleText);
        }
        if (this.isShowLeftLine) {
            this.leftTitleIv.setVisibility(0);
        } else {
            this.leftTitleIv.setVisibility(8);
        }
        if (this.contentLayout != null) {
            this.contentLayout.setPadding(this.contentPaddingStart, this.contentPaddingTop, this.contentPaddingEnd, this.contentPaddingBottom);
        }
    }

    public void setLeftTitle(String title) {
        this.leftTitleText = title;
        if (title != null) {
            this.leftTitleTv.setText((CharSequence)this.leftTitleText);
        }
    }

    public View getMainLayout() {
        return this.mainLayout;
    }
}

