/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.PathInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.xm.uilibrary.R;
import java.util.List;

public class FeederAnimationView
extends FrameLayout {
    private static final int DEFAULT_DURATION = 1500;
    private static final int DEFAULT_SCALE_DURATION = 300;
    private static final int DEFAULT_ICON_SIZE = 100;
    private static final long ANIMATION_DELAY = 80L;
    private ImageView[] imageViews;
    int imageSize;
    PointF startPoint;
    PointF endPoint;
    PointF bezierPoint;
    boolean isPlaying = false;
    int duration;
    int scaleDuration;
    int topPix = 0;

    public FeederAnimationView(@NonNull Context context) {
        this(context, null);
    }

    public FeederAnimationView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FeederAnimationView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public FeederAnimationView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FeederAnimationView, defStyleAttr, defStyleRes);
        this.duration = a.getInt(R.styleable.FeederAnimationView_duration, 1500);
        this.imageSize = a.getDimensionPixelSize(R.styleable.FeederAnimationView_iconSize, 100);
        this.scaleDuration = a.getInt(R.styleable.FeederAnimationView_scaleDuration, 300);
        a.recycle();
    }

    private void initView(List<Integer> imageIds) {
        if (this.getContext() instanceof Activity) {
            View contentParent = ((Activity)this.getContext()).findViewById(0x1020002);
            this.post(() -> {
                int[] location = new int[2];
                contentParent.getLocationInWindow(location);
                this.topPix = location[1];
            });
        }
        this.imageViews = new ImageView[imageIds.size()];
        Drawable[] images = new Drawable[imageIds.size()];
        for (int i = 0; i < imageIds.size(); ++i) {
            images[i] = ContextCompat.getDrawable((Context)this.getContext(), (int)imageIds.get(i));
        }
        this.addImages(images);
    }

    private void addImages(Drawable[] images) {
        for (int i = 0; i < images.length; ++i) {
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(this.imageSize, this.imageSize);
            lp.gravity = 0x800005;
            ImageView imageView = new ImageView(this.getContext());
            imageView.setImageDrawable(images[i]);
            imageView.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.imageViews[i] = imageView;
        }
    }

    private void bzPoint() {
        if (this.startPoint == null || this.endPoint == null) {
            return;
        }
        if (this.bezierPoint != null) {
            return;
        }
        PointF point = new PointF();
        float x = (this.startPoint.x - this.endPoint.x) / 2.0f + this.endPoint.x - 200.0f;
        float y = (this.endPoint.y - this.startPoint.y) / 2.0f + this.startPoint.y - 200.0f;
        point.set(x, y);
        this.bezierPoint = point;
    }

    private AnimatorSet getInitAnimationSet(ImageView image, int index) {
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)image, (String)"scaleX", (float[])new float[]{0.4f, 0.8f, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)image, (String)"scaleY", (float[])new float[]{0.4f, 0.8f, 1.0f});
        scaleX.setDuration((long)this.scaleDuration);
        scaleY.setDuration((long)this.scaleDuration);
        ObjectAnimator rotation = index % 2 == 1 ? ObjectAnimator.ofFloat((Object)image, (String)"rotation", (float[])new float[]{0.0f, 0.0f, 0.0f, -45.0f, 0.0f, -45.0f, 0.0f, -45.0f, -90.0f}) : ObjectAnimator.ofFloat((Object)image, (String)"rotation", (float[])new float[]{0.0f, 0.0f, 0.0f, -45.0f, 0.0f, -45.0f, -90.0f});
        rotation.setDuration(index % 2 == 1 ? (long)(this.duration - 200) : (long)this.duration);
        AnimatorSet animate = new AnimatorSet();
        animate.playTogether(new Animator[]{scaleX, scaleY, rotation});
        return animate;
    }

    private AnimatorSet getRunAnimatorSet(ImageView image) {
        AnimatorSet runSet = new AnimatorSet();
        BezierEvaluator evaluator = new BezierEvaluator(this.bezierPoint);
        ValueAnimator bezier = ValueAnimator.ofObject((TypeEvaluator)evaluator, (Object[])new Object[]{this.startPoint, this.endPoint});
        bezier.setInterpolator((TimeInterpolator)new PathInterpolator(0.1f, 0.2f, 0.5f, 1.0f));
        bezier.addUpdateListener(animation -> {
            PointF pointF = (PointF)animation.getAnimatedValue();
            image.setX(pointF.x - (float)this.imageSize / 2.0f);
            image.setY(pointF.y - (float)this.imageSize / 2.0f - (float)this.topPix);
        });
        runSet.play((Animator)bezier);
        runSet.setDuration((long)this.duration);
        return runSet;
    }

    private void start(final ImageView imageView, final int index, final FeederAnimationListener animationListener) {
        imageView.setX(this.startPoint.x - (float)this.imageSize / 2.0f);
        imageView.setY(this.startPoint.y - (float)this.imageSize / 2.0f);
        this.addView((View)imageView);
        AnimatorSet finalSet = new AnimatorSet();
        finalSet.playTogether(new Animator[]{this.getRunAnimatorSet(imageView), this.getInitAnimationSet(imageView, index)});
        finalSet.setTarget((Object)imageView);
        finalSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                if (index == 0 && animationListener != null) {
                    animationListener.onAnimatorStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                FeederAnimationView.this.removeView((View)imageView);
                if (index == FeederAnimationView.this.imageViews.length - 1) {
                    FeederAnimationView.this.isPlaying = false;
                    if (animationListener != null) {
                        animationListener.onAnimatorEnd();
                    }
                }
            }
        });
        finalSet.start();
    }

    public void setAnimationPositionAndResource(final View startView, final View endView, List<Integer> imageIds) {
        startView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                int[] location = new int[2];
                startView.getLocationInWindow(location);
                int x = location[0];
                int y = location[1];
                FeederAnimationView.this.startPoint = new PointF((float)x + (float)startView.getWidth() / 2.0f, (float)y + (float)startView.getHeight() / 2.0f);
                FeederAnimationView.this.bzPoint();
                startView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
        endView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                int[] location = new int[2];
                endView.getLocationInWindow(location);
                int x = location[0];
                int y = location[1];
                FeederAnimationView.this.endPoint = new PointF((float)x + (float)endView.getWidth() / 2.0f, (float)y + (float)endView.getHeight() / 2.0f);
                FeederAnimationView.this.bzPoint();
                endView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
        this.initView(imageIds);
    }

    public void animate(FeederAnimationListener animationListener) {
        if (this.startPoint == null || this.endPoint == null || this.imageViews == null) {
            throw new RuntimeException("call setAnimationPosition after setContentView or initView...");
        }
        if (this.isPlaying) {
            return;
        }
        this.isPlaying = true;
        int i = 0;
        while (i < this.imageViews.length) {
            int finalI = i++;
            this.postDelayed(() -> this.start(this.imageViews[finalI], finalI, animationListener), 80L * (long)finalI);
        }
    }

    public static interface FeederAnimationListener {
        public void onAnimatorStart();

        public void onAnimatorEnd();
    }

    public static class BezierEvaluator
    implements TypeEvaluator<PointF> {
        private final PointF point1;

        public BezierEvaluator(PointF point1) {
            this.point1 = point1;
        }

        public PointF evaluate(float t, PointF point0, PointF point3) {
            PointF point = new PointF();
            point.x = point0.x * (1.0f - t) * (1.0f - t) + 2.0f * this.point1.x * t * (1.0f - t) + point3.x * t * t;
            point.y = point0.y * (1.0f - t) * (1.0f - t) + 2.0f * this.point1.y * t * (1.0f - t) + point3.y * t * t;
            return point;
        }
    }
}

