/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.xm.UIUtils;
import com.xm.uilibrary.R;

public class ButtonCheck
extends LinearLayout {
    private static final float TITLE_TEXT_DEFAULT_SIZE = 14.0f;
    private static final float TIP_TEXT_DEFAULT_SIZE = 12.0f;
    private static final float RIGHT_TEXT_DEFAULT_SIZE = 14.0f;
    public static final int STATE_DEFAULT = 0;
    public static final int STATE_CHECKED = 1;
    private LinearLayout mTab;
    private LinearLayout mLlContent;
    private ImageView mCoverImage;
    private ImageView mImage = null;
    private TextView[] mTexts = new TextView[3];
    private String[] _texts = new String[3];
    private int _btnValue = 0;
    private int[] _imageID = new int[3];
    private int[] _textID = new int[2];
    private float rightTextLeftPadding;
    private float leftTextRightPadding;
    private float bottomTextTopPadding;
    private float contentPaddingTop;
    private float contentPaddingBottom;
    private float contentPaddingStart;
    private float contentPaddingEnd;
    private float _textSize;
    private int bottomLines;
    private int position;
    private OnButtonClickListener mOnBtnClickLs;
    private boolean isClickedBefore;
    private boolean isDefaultClickable;
    private boolean isRippleBtnEnable;
    private float imageWidth;
    private float imageHeight;

    public ButtonCheck(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.xm_ui_bottom_tab_btn, (ViewGroup)this, true);
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.ButtonCheck);
        this._btnValue = params.getInteger(R.styleable.ButtonCheck_BtnValue, 0);
        this._imageID[0] = params.getResourceId(R.styleable.ButtonCheck_NormalBkg, 0);
        this._imageID[1] = params.getResourceId(R.styleable.ButtonCheck_SelectedBkg, 0);
        this._imageID[2] = params.getResourceId(R.styleable.ButtonCheck_DisableBkg, 0);
        this._textID[0] = params.getColor(R.styleable.ButtonCheck_TextNormalColor, this.getResources().getColor(R.color.default_normal_text_color));
        this._textID[1] = params.getColor(R.styleable.ButtonCheck_TextSelectedColor, this.getResources().getColor(R.color.default_selected_text_color));
        this._textSize = params.getDimension(R.styleable.ButtonCheck_TextSize, (float)UIUtils.sp2px(this.getContext(), 12.0f));
        this._texts[0] = params.getString(R.styleable.ButtonCheck_Text);
        this._texts[1] = params.getString(R.styleable.ButtonCheck_rightText);
        this._texts[2] = params.getString(R.styleable.ButtonCheck_leftText);
        this.bottomLines = params.getInteger(R.styleable.ButtonCheck_android_lines, 0);
        this.rightTextLeftPadding = params.getDimension(R.styleable.ButtonCheck_rightTextLeftPadding, 5.0f);
        this.leftTextRightPadding = params.getDimension(R.styleable.ButtonCheck_leftTextRightPadding, 5.0f);
        this.bottomTextTopPadding = params.getDimension(R.styleable.ButtonCheck_bottomTextTopPadding, 0.0f);
        this.isDefaultClickable = params.getBoolean(R.styleable.ButtonCheck_DefaultClickable, true);
        this.contentPaddingTop = params.getDimension(R.styleable.ButtonCheck_contentPaddingTop, 0.0f);
        this.contentPaddingBottom = params.getDimension(R.styleable.ButtonCheck_contentPaddingBottom, 0.0f);
        this.contentPaddingStart = params.getDimension(R.styleable.ButtonCheck_contentPaddingStart, 0.0f);
        this.contentPaddingEnd = params.getDimension(R.styleable.ButtonCheck_contentPaddingEnd, 0.0f);
        this.isRippleBtnEnable = params.getBoolean(R.styleable.ButtonCheck_RippleBtnEnable, false);
        this.imageWidth = params.getDimension(R.styleable.ButtonCheck_imageWidth, 0.0f);
        this.imageHeight = params.getDimension(R.styleable.ButtonCheck_imageHeight, 0.0f);
        params.recycle();
    }

    public void setBackgroundResource(int resId) {
        this.mImage.setImageResource(resId);
    }

    public void setBackgroundBitmap(Bitmap bitmap) {
        this.mImage.setImageBitmap(bitmap);
    }

    public void setNormalBg(int resId) {
        this._imageID[0] = resId;
        if (this._btnValue == 0) {
            this.mImage.setImageResource(resId);
        }
    }

    public void setSelectedBg(int resId) {
        this._imageID[1] = resId;
        if (this._btnValue == 1) {
            this.mImage.setImageResource(resId);
        }
    }

    public void setDisabledBg(int resId) {
        this._imageID[2] = resId;
        if (!this.isEnabled()) {
            this.mCoverImage.setImageResource(resId);
        }
    }

    public void setBtnValue(int value) {
        this._btnValue = value;
        this.mImage.setImageResource(this._imageID[this._btnValue != 0 ? 1 : 0]);
        this.mImage.requestLayout();
        for (TextView textView : this.mTexts) {
            if (textView == null) continue;
            textView.setTextColor(this._textID[this._btnValue]);
        }
    }

    public int getBtnValue() {
        return this._btnValue;
    }

    public ImageView getImageView() {
        return this.mImage;
    }

    public void Checked(boolean bChecked) {
        this.setBtnValue(bChecked ? 1 : 0);
    }

    public boolean IsChecked() {
        return this._btnValue == 1;
    }

    public void setBottomText(String msg) {
        this._texts[0] = msg;
        this.mTexts[0].setText((CharSequence)msg);
    }

    public void setBottomTextVisible(int visible) {
        this.mTexts[0].setVisibility(visible);
    }

    public void setRightText(String msg) {
        this._texts[1] = msg;
        this.mTexts[1].setText((CharSequence)msg);
    }

    public String getRightText() {
        if (this.mTexts[1] != null) {
            return this.mTexts[1].getText().toString();
        }
        return "";
    }

    public void setLeftText(String msg) {
        this._texts[2] = msg;
        this.mTexts[2].setText((CharSequence)msg);
    }

    public String getLeftText() {
        if (this.mTexts[2] != null) {
            return this.mTexts[2].getText().toString();
        }
        return "";
    }

    protected void onFinishInflate() {
        ViewGroup.LayoutParams layoutParam;
        ViewGroup.LayoutParams layoutParams;
        super.onFinishInflate();
        this.mTab = (LinearLayout)this.findViewById(R.id.tab);
        this.mLlContent = (LinearLayout)this.findViewById(R.id.ll_content);
        this.mImage = (ImageView)this.findViewById(R.id.tab_image);
        this.mCoverImage = (ImageView)this.findViewById(R.id.tab_image_cover);
        this.mCoverImage.setImageResource(this._imageID[2]);
        this.mTexts[0] = (TextView)this.findViewById(R.id.tab_tv_bottom);
        this.mTexts[1] = (TextView)this.findViewById(R.id.tab_tv_right);
        this.mTexts[2] = (TextView)this.findViewById(R.id.tab_tv_left);
        for (int i = 0; i < this.mTexts.length; ++i) {
            if (this._texts[i] != null) {
                this.mTexts[i].setText((CharSequence)this._texts[i]);
                this.mTexts[i].setTextSize(0, this._textSize);
                this.mTexts[i].setTextColor(this._textID[this._btnValue]);
                continue;
            }
            this.mTexts[i].setVisibility(8);
        }
        if (this.mTexts[0] != null && this.bottomTextTopPadding > 0.0f) {
            this.mTexts[0].setPadding(0, (int)this.bottomTextTopPadding, 0, 0);
        }
        if (this.mTexts[1] != null && this.rightTextLeftPadding > 0.0f) {
            this.mTexts[1].setPadding((int)this.rightTextLeftPadding, 0, 0, 0);
        }
        if (this.mTexts[2] != null && this.leftTextRightPadding > 0.0f) {
            this.mTexts[2].setPadding(0, 0, (int)this.leftTextRightPadding, 0);
        }
        this.mImage.setImageResource(this._imageID[this._btnValue]);
        if (this.bottomLines > 0 && this.mTexts[0] != null) {
            this.mTexts[0].setMaxLines(this.bottomLines);
            this.mTexts[0].setEllipsize(TextUtils.TruncateAt.END);
        }
        this.mTab.setPadding((int)this.contentPaddingStart, (int)this.contentPaddingTop, (int)this.contentPaddingEnd, (int)this.contentPaddingBottom);
        if (this.isRippleBtnEnable) {
            this.mTab.setBackgroundResource(R.drawable.ripple_btn_selector);
        }
        if ((layoutParams = this.mImage.getLayoutParams()) != null && this.imageWidth > 0.0f && this.imageHeight > 0.0f) {
            layoutParams.width = (int)this.imageWidth;
            layoutParams.height = (int)this.imageHeight;
        }
        if ((layoutParam = this.mCoverImage.getLayoutParams()) != null && this.imageWidth > 0.0f && this.imageHeight > 0.0f) {
            layoutParam.width = (int)this.imageWidth;
            layoutParam.height = (int)this.imageHeight;
        }
        this.setClickable(this.isDefaultClickable);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isClickable()) {
            this.mTab.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ButtonCheck.this.isClickedBefore = true;
                    if (ButtonCheck.this.mOnBtnClickLs != null && ButtonCheck.this.mOnBtnClickLs.onButtonClick(ButtonCheck.this, ButtonCheck.this._btnValue == 1)) {
                        ButtonCheck.this._btnValue = ButtonCheck.this._btnValue == 0 ? 1 : 0;
                    }
                    ButtonCheck.this.mImage.setImageResource(ButtonCheck.this._imageID[ButtonCheck.this._btnValue]);
                    if (ButtonCheck.this._textID != null) {
                        for (TextView textView : ButtonCheck.this.mTexts) {
                            if (textView == null) continue;
                            textView.setTextColor(ButtonCheck.this._textID[ButtonCheck.this._btnValue]);
                        }
                    }
                }
            });
        }
    }

    public void setOnButtonClick(OnButtonClickListener onBtnClickLs) {
        this.mOnBtnClickLs = onBtnClickLs;
    }

    public boolean isClickedBefore() {
        return this.isClickedBefore;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            if (this.mImage != null) {
                this.mCoverImage.setVisibility(0);
            }
        } else if (this.mImage != null) {
            this.mCoverImage.setVisibility(8);
        }
        if (this.mImage != null) {
            this.mImage.setEnabled(enabled);
            this.mTab.setEnabled(enabled);
        }
        for (TextView textView : this.mTexts) {
            if (textView == null) continue;
            textView.setEnabled(enabled);
        }
    }

    private void dealWithAllViewCompleteDisplay() {
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.dealWithAllViewCompleteDisplay();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setMaxWidth(int width) {
    }

    public void setMaxHeight(int height) {
        Paint paint = new Paint();
        paint.setTextSize(this._textSize);
        Paint.FontMetrics fm = paint.getFontMetrics();
        int textHeight = (int)(fm.bottom - fm.top) * 2;
        ViewGroup.LayoutParams layoutParams = this.mLlContent.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.height = height > 0 ? height - textHeight - this.mTexts[0].getPaddingTop() - this.mTexts[0].getPaddingBottom() : -2;
        }
        this.mLlContent.requestLayout();
    }

    public void setRippleBtnEnable(boolean isEnable) {
        this.isRippleBtnEnable = isEnable;
        if (isEnable) {
            this.mTab.setBackgroundResource(R.drawable.ripple_btn_selector);
        } else {
            this.mTab.setBackgroundResource(-1);
        }
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public static interface OnButtonClickListener {
        public boolean onButtonClick(ButtonCheck var1, boolean var2);
    }
}

