/*
 * Decompiled with CFR 0.152.
 */
package com.lib.encoder;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Log;
import com.lib.FunSDK;
import com.lib.decoder.DecoderManaer;
import java.nio.ByteBuffer;
import java.util.Arrays;

@SuppressLint(value={"NewApi"})
public class AVCEncoder {
    MediaCodec _mediaCodec;
    int _width;
    int _height;
    byte[] _spsbuffer = null;
    int _framerate;
    long _generateIndex = 0L;
    int _supportColorFormat = -1;
    byte[] _output = null;
    static int s_supportFormat = -1;
    ByteBuffer[] _inputBuffers = null;
    ByteBuffer[] _outputBuffers = null;
    static final int N_MAX_ENCODER_SIZE = 16;
    static AVCEncoder[] s_Encoder = new AVCEncoder[16];
    static final int EFormatYUV420Planar = 1;
    static final int EFormatYUV420SemiPlanar = 2;
    static final int EFormatYUV420PackedSemiPlanar = 3;
    static final int EFormatYUV420PackedPlanar = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public static int NewEncoder(int width, int height, int framerate, int bitrate, int iFrameInterval, int[] ret) {
        if (!DecoderManaer.IsEnableHDec()) {
            FunSDK.Log("CHardEncoder DecoderManaer.IsEnableHDec[FALSE]\r\n");
            return -1;
        }
        AVCEncoder[] aVCEncoderArray = s_Encoder;
        synchronized (s_Encoder) {
            int nId = -1;
            int i = 0;
            while (i < 16) {
                if (s_Encoder[i] == null) {
                    AVCEncoder enc = new AVCEncoder();
                    if (enc.Start(width, height, framerate, bitrate, iFrameInterval, ret)) {
                        AVCEncoder.s_Encoder[i] = enc;
                        nId = i;
                        break;
                    }
                    enc = null;
                    break;
                }
                ++i;
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return nId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DestoryEncoder(int nId) {
        AVCEncoder[] aVCEncoderArray = s_Encoder;
        synchronized (s_Encoder) {
            if (nId >= 0 && nId < 16 && s_Encoder[nId] != null) {
                s_Encoder[nId].close();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int GetSupportColorFormat() {
        AVCEncoder[] aVCEncoderArray = s_Encoder;
        synchronized (s_Encoder) {
            if (s_supportFormat != -1) {
                System.out.println("AVCEncoder GetSupportColorFormat=" + s_supportFormat);
                // ** MonitorExit[var0] (shouldn't be in output)
                return s_supportFormat;
            }
            int numCodecs = MediaCodecList.getCodecCount();
            MediaCodecInfo codecInfo = null;
            int i = 0;
            while (i < numCodecs && codecInfo == null) {
                MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
                if (info.isEncoder()) {
                    String[] types = info.getSupportedTypes();
                    boolean found = false;
                    int j = 0;
                    while (j < types.length && !found) {
                        if (types[j].equals("video/avc")) {
                            found = true;
                        }
                        ++j;
                    }
                    if (found) {
                        codecInfo = info;
                    }
                }
                ++i;
            }
            Log.e((String)"AvcEncoder", (String)("Found " + codecInfo.getName() + " supporting " + "video/avc"));
            int nRetFormat = 0;
            MediaCodecInfo.CodecCapabilities capabilities = codecInfo.getCapabilitiesForType("video/avc");
            Log.e((String)"AvcEncoder", (String)("length-" + capabilities.colorFormats.length + "==" + Arrays.toString(capabilities.colorFormats)));
            int i2 = 0;
            while (i2 < capabilities.colorFormats.length) {
                Log.e((String)"AvcEncoder", (String)("supported color format::" + capabilities.colorFormats[i2]));
                switch (capabilities.colorFormats[i2]) {
                    case 21: {
                        nRetFormat |= 4;
                        break;
                    }
                    case 19: {
                        nRetFormat |= 2;
                        break;
                    }
                    case 39: {
                        nRetFormat |= 8;
                        break;
                    }
                    case 2130706688: 
                    case 2141391872: {
                        break;
                    }
                }
                ++i2;
            }
            s_supportFormat = nRetFormat;
            // ** MonitorExit[var0] (shouldn't be in output)
            return nRetFormat;
        }
    }

    public static int JavaColorFormatToJni(int nJavaForamte) {
        switch (nJavaForamte) {
            case 21: {
                return 2;
            }
            case 19: {
                return 1;
            }
            case 39: {
                return 3;
            }
            case 20: {
                return 4;
            }
            case 2130706688: 
            case 2141391872: {
                break;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] Encode(int nId, byte[] pBuffer, int[] nEncoderRet) {
        AVCEncoder[] aVCEncoderArray = s_Encoder;
        synchronized (s_Encoder) {
            if (nId >= 0 && nId < 16 && s_Encoder[nId] != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return s_Encoder[nId].Encoder(pBuffer, nEncoderRet);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return null;
        }
    }

    public boolean Start(int width, int height, int framerate, int bitrate, int iFrameInterval, int[] ret) {
        boolean bResult = false;
        this._width = width;
        this._height = height;
        this._framerate = framerate;
        this._supportColorFormat = AVCEncoder.GetSupportColorFormat();
        if (this._supportColorFormat == -1) {
            FunSDK.Log("CHardEncoder GetSupportColorFormat=" + this._supportColorFormat);
            return bResult;
        }
        try {
            this._mediaCodec = MediaCodec.createEncoderByType((String)"video/avc");
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)width, (int)height);
            bitrate = (int)((float)(width * height) * 1.5f);
            mediaFormat.setInteger("bitrate", bitrate);
            mediaFormat.setInteger("frame-rate", framerate);
            int nInputFormat = -1;
            if ((this._supportColorFormat & 4) != 0) {
                nInputFormat = 21;
            } else if ((this._supportColorFormat & 2) != 0) {
                nInputFormat = 19;
            } else if ((this._supportColorFormat & 8) != 0) {
                nInputFormat = 39;
            } else if ((this._supportColorFormat & 0x10) != 0) {
                nInputFormat = 20;
            }
            if (nInputFormat != -1) {
                mediaFormat.setInteger("color-format", nInputFormat);
            }
            mediaFormat.setInteger("i-frame-interval", 1);
            this._mediaCodec.configure(mediaFormat, null, null, 1);
            this._output = new byte[this._width * this._height * 3];
            this._mediaCodec.start();
            this._inputBuffers = this._mediaCodec.getInputBuffers();
            this._outputBuffers = this._mediaCodec.getOutputBuffers();
            this._generateIndex = 0L;
            MediaFormat inputFormat = this._mediaCodec.getInputFormat();
            int nInput = inputFormat.getInteger("color-format");
            ret[0] = AVCEncoder.JavaColorFormatToJni(nInput);
            System.out.println("AVCEncoder MediaFormat_Input:" + ret[0]);
            bResult = true;
        }
        catch (Exception ex) {
            this._mediaCodec = null;
            FunSDK.Log("CHardEncoder Start_Error" + ex.toString());
        }
        return bResult;
    }

    @SuppressLint(value={"NewApi"})
    private static int getSupportColorFormat() {
        int numCodecs = MediaCodecList.getCodecCount();
        MediaCodecInfo codecInfo = null;
        int i = 0;
        while (i < numCodecs && codecInfo == null) {
            MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
            if (info.isEncoder()) {
                String[] types = info.getSupportedTypes();
                int j = 0;
                while (j < types.length) {
                    if (types[j].equals("video/avc")) {
                        codecInfo = info;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (codecInfo == null) {
            return -1;
        }
        MediaCodecInfo.CodecCapabilities capabilities = codecInfo.getCapabilitiesForType("video/avc");
        int i2 = 0;
        while (i2 < capabilities.colorFormats.length) {
            switch (capabilities.colorFormats[i2]) {
                case 19: 
                case 20: 
                case 21: 
                case 39: 
                case 2130706688: 
                case 2141391872: {
                    Log.e((String)"AvcEncoder", (String)("supported color format::" + capabilities.colorFormats[i2]));
                    return capabilities.colorFormats[i2];
                }
            }
            ++i2;
        }
        return -1;
    }

    @SuppressLint(value={"NewApi"})
    public void close() {
        try {
            this._mediaCodec.stop();
            this._mediaCodec.release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long computePresentationTime(long frameIndex) {
        return 132L + frameIndex * 1000000L / (long)this._framerate;
    }

    @SuppressLint(value={"NewApi"})
    public byte[] Encoder(byte[] input, int[] nEncoderRet) {
        long pts = 0L;
        nEncoderRet[0] = 0;
        try {
            int inIndex = this._mediaCodec.dequeueInputBuffer(100000L);
            if (inIndex >= 0) {
                if (input == null || input.length == 0) {
                    this._mediaCodec.queueInputBuffer(inIndex, 0, 0, 0L, 4);
                } else {
                    pts = this.computePresentationTime(this._generateIndex);
                    ++this._generateIndex;
                    ByteBuffer inputBuffer = this._inputBuffers[inIndex];
                    inputBuffer.clear();
                    inputBuffer.put(input);
                    this._mediaCodec.queueInputBuffer(inIndex, 0, input.length, pts, 0);
                }
            }
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int outIndex = 0;
            int nOutSize = 0;
            while ((outIndex = this._mediaCodec.dequeueOutputBuffer(bufferInfo, 0L)) >= 0) {
                if ((bufferInfo.flags & 4) != 0) {
                    this._mediaCodec.releaseOutputBuffer(outIndex, false);
                    break;
                }
                ByteBuffer outputBuffer = this._outputBuffers[outIndex];
                System.out.println("AVCEncoder_Frame Flag=" + bufferInfo.flags);
                if ((bufferInfo.flags & 2) != 0) {
                    this._spsbuffer = new byte[bufferInfo.size];
                    outputBuffer.get(this._spsbuffer);
                    System.out.println("AVCEncoder_Frame PPS Len=" + bufferInfo.size);
                    this._mediaCodec.releaseOutputBuffer(outIndex, false);
                    continue;
                }
                if (this._spsbuffer == null) {
                    this._mediaCodec.releaseOutputBuffer(outIndex, false);
                    continue;
                }
                if (this._output == null || this._output.length < this._spsbuffer.length + bufferInfo.size) {
                    this._output = new byte[this._spsbuffer.length + bufferInfo.size + 4096];
                    System.out.println("AVCEncoder_Frame NewBuffer=" + this._output.length);
                }
                if ((bufferInfo.flags & 1) != 0) {
                    nEncoderRet[1] = 1;
                    System.out.println("AVCEncoder_Frame IsKey");
                }
                if (nEncoderRet[1] == 1) {
                    System.arraycopy(this._spsbuffer, 0, this._output, nOutSize, this._spsbuffer.length);
                    outputBuffer.get(this._output, nOutSize += this._spsbuffer.length, bufferInfo.size);
                    nOutSize += bufferInfo.size;
                    System.out.println("AVCEncoder_Frame(Key)=" + bufferInfo.size);
                } else {
                    outputBuffer.get(this._output, 0, bufferInfo.size);
                    nOutSize += bufferInfo.size;
                    System.out.println("AVCEncoder_Frame=" + bufferInfo.size);
                }
                this._mediaCodec.releaseOutputBuffer(outIndex, false);
                break;
            }
            nEncoderRet[0] = nOutSize;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return this._output;
    }

    public static void YUV420_to_NV12(byte[] yuv420p, byte[] yuv420sp, int width, int height) {
        int y_size = width * height;
        System.arraycopy(yuv420p, 0, yuv420sp, 0, width * height);
        int j = 0;
        int i = 0;
        while (j < y_size / 2) {
            yuv420sp[y_size + j] = yuv420p[y_size + i];
            yuv420sp[y_size + j + 1] = yuv420p[y_size * 5 / 4 + i];
            j += 2;
            ++i;
        }
    }

    public static void YUV420_to_NV21(byte[] input, byte[] output1, int width, int height) {
        int frameSize = width * height;
        int qFrameSize = frameSize / 4;
        System.arraycopy(input, 0, output1, 0, frameSize);
        int i = 0;
        while (i < qFrameSize) {
            output1[frameSize + i * 2] = input[frameSize + i + qFrameSize];
            output1[frameSize + i * 2 + 1] = input[frameSize + i];
            ++i;
        }
    }

    public static void YUV420_to_YV12(byte[] input, byte[] output1, int width, int height) {
        int frameSize = width * height;
        int qFrameSize = frameSize / 4;
        System.arraycopy(input, 0, output1, 0, frameSize);
        System.arraycopy(input, frameSize, output1, frameSize + qFrameSize, qFrameSize);
        System.arraycopy(input, frameSize + qFrameSize, output1, frameSize, qFrameSize);
    }
}

