/*
 * Decompiled with CFR 0.152.
 */
package com.xmgl.vrsoft;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.core.view.GestureDetectorCompat;
import com.xmgl.vrsoft.TraceRebound;
import com.xmgl.vrsoft.VRSoftEvent;
import com.xmgl.vrsoft.VRSoftGLView;
import com.xmgl.vrsoft.VRSoftJNI;

public class VRSoftEvent180
extends VRSoftEvent {
    private Dewarper180VRGestureListener mGestureListener = null;
    private GestureDetectorCompat mDetector = null;
    private int mDrawMode = 0;
    private float mPreviousY;
    private float mPreviousX;
    private final double ZOOM_MIN = 0.25;
    private final double ZOOM_MAX = 20.0;
    private final double ZOOM_ONE = 1.0;
    private final double ZOOM_ONE_Z = 90.0;
    private final double ZOOM_MIN_Z = 100.0;
    private final double ZOOM_MAX_Z = 20.0;
    private final double ZOOM_MIN_FOR_DEWARPER = 10.0;
    private double mZoom;
    private double mCurZoom = this.mZoom = 1.0;
    private final double MIN_ANGLE_X = -60.0;
    private final double MAX_ANGLE_X = 60.0;
    private final double MIN_ANGLE_Y = -70.0;
    private final double MAX_ANGLE_Y = 70.0;
    private final double MIN_ANGLE_Z = -6.0;
    private final double MAX_ANGLE_Z = 6.0;
    private final double MIN_ANGLE_Y_DEWARPER_ZOOM_MIN = -40.0;
    private final double MAX_ANGLE_Y_DEWARPER_ZOOM_MIN = 40.0;
    private final double MIN_ANGLE_Y_DEWARPER_ZOOM_MAX = -60.0;
    private final double MAX_ANGLE_Y_DEWARPER_ZOOM_MAX = 60.0;
    private final double MIN_ANGLE_X_DEWARPER_ZOOM_MIN = -40.0;
    private final double MAX_ANGLE_X_DEWARPER_ZOOM_MIN = 40.0;
    private final double MIN_ANGLE_X_DEWARPER_ZOOM_MAX = -60.0;
    private final double MAX_ANGLE_X_DEWARPER_ZOOM_MAX = 60.0;
    private double mAngleX = 0.0;
    private double mAngleY = 0.0;
    private double mAngleZ = 0.0;
    private double mCurAngleX;
    private double mCurAngleY;
    private double mCurAngleZ;
    private boolean mAutoAdjust = false;
    private final double TOUCH_SCALE_FACTOR = 0.4444444477558136;
    private final int MESSAGE_ADJUST = 257;
    private final int MESSAGE_TOUCHABLE = 258;
    private TraceRebound mTraceX = null;
    private TraceRebound mTraceY = null;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 257: {
                    VRSoftEvent180.this.autoAdjust();
                    VRSoftEvent180.this.drawView();
                    break;
                }
                case 258: {
                    if (null == VRSoftEvent180.this.mGLSurfaceView) break;
                    VRSoftEvent180.this.mGLSurfaceView.setTouchable(true);
                }
            }
        }
    };

    public VRSoftEvent180(Context context, VRSoftGLView glView, int vrHandle) {
        super(context, glView, vrHandle);
        this.mGestureListener = new Dewarper180VRGestureListener();
        this.mDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)this.mGestureListener);
    }

    private void switchToDrawMode(int drawMode) {
        this.mGLSurfaceView.setTouchable(false);
        this.mGLSurfaceView.setDrawMode(drawMode);
        this.drawView();
        this.mHandler.sendEmptyMessageDelayed(258, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onTouchEvent(MotionEvent event) {
        float y = event.getY();
        float x = event.getX();
        VRSoftEvent180 vRSoftEvent180 = this;
        synchronized (vRSoftEvent180) {
            this.mTraceX = null;
            this.mTraceY = null;
        }
        if (null != this.mHandler) {
            this.mHandler.removeMessages(257);
        }
        this.mDetector.onTouchEvent(event);
        this.mPreviousY = y;
        this.mPreviousX = x;
        if (event.getAction() == 1 && null != this.mHandler) {
            this.mHandler.sendEmptyMessageDelayed(257, 120L);
            this.mGLSurfaceView.setTouchable(false);
            this.mHandler.sendEmptyMessageDelayed(258, 150L);
        }
        return true;
    }

    public boolean setDrawMode(int drawMode) {
        this.mDrawMode = drawMode;
        return true;
    }

    public int getDrawMode() {
        return this.mDrawMode;
    }

    public void setZoom(double zoom) {
        double zoomMin = 0.25;
        if (this.mDrawMode == 3) {
            zoomMin = 10.0;
        }
        this.mZoom = zoom <= zoomMin ? zoomMin : (zoom >= 20.0 ? 20.0 : zoom);
    }

    public double getZoom() {
        return this.mZoom;
    }

    public void setAngleDX(double dx) {
        double div = Math.max(this.mCurZoom, 2.0) / 2.0;
        double angle = this.mAngleX + (dx /= div);
        this.mAngleX = Math.max(angle, -60.0);
        this.mAngleX = Math.min(this.mAngleX, 60.0);
        this.mAutoAdjust = false;
    }

    public void setAngleDY(double dy) {
        double div = Math.max(this.mCurZoom, 2.0) / 2.0;
        double angle = this.mAngleY + (dy /= div);
        if (2 == this.mDrawMode) {
            this.mAngleY = angle;
        } else {
            this.mAngleY = Math.max(angle, -70.0);
            this.mAngleY = Math.min(this.mAngleY, 70.0);
        }
        this.mAutoAdjust = false;
    }

    public void setAngleDZ(float dz) {
        double angle = this.mAngleZ + (double)dz;
        this.mAngleZ = Math.max(angle, -6.0);
        this.mAngleZ = Math.min(this.mAngleZ, 6.0);
        this.mAutoAdjust = false;
    }

    public void setAngleDXSmooth(double dx) {
        this.setAngleDX(dx);
        this.mAutoAdjust = true;
    }

    public void setAngleDYSmooth(double dy) {
        this.setAngleDY(dy);
        this.mAutoAdjust = true;
    }

    private double getZoomStep(double zoomCur, double zoomTar) {
        if (zoomTar >= 1.0) {
            return 0.38;
        }
        return 0.0375;
    }

    private double getAngleStep(double f1, double f2) {
        double step = 0.0;
        double abs = Math.abs(f1 - f2);
        double MAX_STEP = 10.0;
        double MIN_STEP = 0.1f;
        double MAX_DIST = 50.0;
        step = abs > 50.0 ? 10.0 : 10.0 - (50.0 - abs) * 10.0 / 50.0;
        step = this.mAutoAdjust ? (step /= 3.0) : (step *= 2.0);
        step = Math.min(10.0, step);
        step = Math.max((double)0.1f, step);
        return step;
    }

    private double nextZoom() {
        if (this.mCurZoom > this.mZoom) {
            this.mCurZoom -= this.getZoomStep(this.mCurZoom, this.mZoom);
            if (this.mCurZoom < this.mZoom) {
                this.mCurZoom = this.mZoom;
            }
        } else if (this.mCurZoom < this.mZoom) {
            this.mCurZoom += this.getZoomStep(this.mCurZoom, this.mZoom);
            if (this.mCurZoom > this.mZoom) {
                this.mCurZoom = this.mZoom;
            }
        }
        return this.mCurZoom;
    }

    private double nextAngleX() {
        if (this.mCurAngleX > this.mAngleX) {
            this.mCurAngleX -= this.getAngleStep(this.mCurAngleX, this.mAngleX);
            if (this.mCurAngleX < this.mAngleX) {
                this.mCurAngleX = this.mAngleX;
            }
        } else if (this.mCurAngleX < this.mAngleX) {
            this.mCurAngleX += this.getAngleStep(this.mCurAngleX, this.mAngleX);
            if (this.mCurAngleX > this.mAngleX) {
                this.mCurAngleX = this.mAngleX;
            }
        }
        return this.mCurAngleX;
    }

    private double nextAngleY() {
        if (this.mCurAngleY > this.mAngleY) {
            this.mCurAngleY -= this.getAngleStep(this.mCurAngleY, this.mAngleY);
            if (this.mCurAngleY < this.mAngleY) {
                this.mCurAngleY = this.mAngleY;
            }
        } else if (this.mCurAngleY < this.mAngleY) {
            this.mCurAngleY += this.getAngleStep(this.mCurAngleY, this.mAngleY);
            if (this.mCurAngleY > this.mAngleY) {
                this.mCurAngleY = this.mAngleY;
            }
        }
        return this.mCurAngleY;
    }

    private double nextAngleZ() {
        if (this.mCurAngleZ > this.mAngleZ) {
            this.mCurAngleZ -= this.getAngleStep(this.mCurAngleZ, this.mAngleZ);
            if (this.mCurAngleZ < this.mAngleZ) {
                this.mCurAngleZ = this.mAngleZ;
            }
        } else if (this.mCurAngleZ < this.mAngleZ) {
            this.mCurAngleZ += this.getAngleStep(this.mCurAngleZ, this.mAngleZ);
            if (this.mCurAngleZ > this.mAngleZ) {
                this.mCurAngleZ = this.mAngleZ;
            }
        }
        return this.mCurAngleZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoAdjust() {
        if (this.mDrawMode == 3 && this.mZoom >= 10.0) {
            VRSoftEvent180 vRSoftEvent180 = this;
            synchronized (vRSoftEvent180) {
                double yMin = -40.0 + (this.mZoom - 10.0) * -20.0 / 10.0;
                double yMax = 40.0 + (this.mZoom - 10.0) * 20.0 / 10.0;
                this.mAngleY = Math.max(this.mAngleY, (double)((float)yMin));
                this.mAngleY = Math.min(this.mAngleY, (double)((float)yMax));
                double xMin = -40.0 + (this.mZoom - 10.0) * -20.0 / 10.0;
                double xMax = 40.0 + (this.mZoom - 10.0) * 20.0 / 10.0;
                this.mAngleX = Math.max(this.mAngleX, (double)((float)xMin));
                this.mAngleX = Math.min(this.mAngleX, (double)((float)xMax));
                if (Math.abs(this.mCurAngleX) > Math.abs(this.mAngleX) && Math.abs(this.mAngleX) >= Math.abs(xMax)) {
                    this.mTraceX = new TraceRebound(this.mCurAngleX, this.mAngleX, 700);
                }
                if (Math.abs(this.mCurAngleY) > Math.abs(this.mAngleY) && Math.abs(this.mAngleY) >= Math.abs(yMax)) {
                    this.mTraceY = new TraceRebound(this.mCurAngleY, this.mAngleY, 700);
                }
                this.mAutoAdjust = true;
            }
        } else if (this.mDrawMode == 0) {
            if (Math.abs(this.mAngleY) > 35.0 || Math.abs(this.mAngleX) > 30.0) {
                this.switchToDrawMode(3);
            } else {
                this.goToDefaultPosition();
                this.drawView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPTZs() {
        double zoom = 0.0;
        double rotateX = 0.0;
        double rotateY = 0.0;
        double rotateZ = 0.0;
        VRSoftEvent180 vRSoftEvent180 = this;
        synchronized (vRSoftEvent180) {
            zoom = this.nextZoom();
            rotateX = this.nextAngleX();
            rotateY = this.nextAngleY();
            rotateZ = this.nextAngleZ();
            if (null != this.mTraceX) {
                rotateX = this.mTraceX.getValue();
                if (this.mTraceX.isFinish()) {
                    this.mTraceX = null;
                }
                this.mCurAngleX = rotateX;
            }
            if (null != this.mTraceY) {
                rotateY = this.mTraceY.getValue();
                if (this.mTraceY.isFinish()) {
                    this.mTraceY = null;
                }
                this.mCurAngleY = rotateY;
            }
        }
        VRSoftJNI.setRotateZoom(this.mVRSoftHande, rotateX, rotateY, rotateZ, zoom);
    }

    @Override
    public boolean needContinue() {
        return this.mCurAngleX != this.mAngleX || this.mCurAngleY != this.mAngleY || this.mCurAngleZ != this.mAngleZ || this.mCurZoom != this.mZoom;
    }

    @Override
    public void goToDefaultPosition() {
        this.mAngleZ = 0.0;
        this.mAngleY = 0.0;
        this.mAngleX = 0.0;
        this.setZoom(1.0);
    }

    class Dewarper180VRGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private double startX = 0.0;
        private double startY = 0.0;
        private boolean zooming = false;
        private double zoomBaseValue;
        private double initialTwoFingerDistance = -1.0;
        private double lastTwoFingerDistance = -1.0;

        Dewarper180VRGestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            this.startX = e.getX();
            this.startY = e.getY();
            this.zooming = false;
            this.zoomBaseValue = VRSoftEvent180.this.getZoom();
            this.initialTwoFingerDistance = -1.0;
            this.lastTwoFingerDistance = -1.0;
            VRSoftEvent180.this.mPreviousX = e.getX();
            VRSoftEvent180.this.mPreviousY = e.getY();
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            float dx = velocityX / 100.0f;
            float dy = velocityY / 20.0f;
            VRSoftEvent180.this.setAngleDYSmooth((double)(-dx) * 0.4444444477558136);
            VRSoftEvent180.this.setAngleDXSmooth((double)(-dy) * 0.4444444477558136);
            VRSoftEvent180.this.drawView();
            return true;
        }

        @SuppressLint(value={"NewApi"})
        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (null != e2) {
                switch (e2.getPointerCount()) {
                    case 1: {
                        if (this.zooming) break;
                        float dy = e2.getY() - VRSoftEvent180.this.mPreviousY;
                        float dx = e2.getX() - VRSoftEvent180.this.mPreviousX;
                        if (Math.abs(dx) > Math.abs(dy)) {
                            VRSoftEvent180.this.setAngleDY((double)(-dx) * 0.4444444477558136);
                        } else {
                            VRSoftEvent180.this.setAngleDX((double)(-dy) * 0.4444444477558136);
                        }
                        VRSoftEvent180.this.drawView();
                        break;
                    }
                    case 2: {
                        double dValueDistance;
                        MotionEvent.PointerCoords localPointerCoords2 = new MotionEvent.PointerCoords();
                        MotionEvent.PointerCoords localPointerCoords1 = new MotionEvent.PointerCoords();
                        e2.getPointerCoords(0, localPointerCoords2);
                        e2.getPointerCoords(1, localPointerCoords1);
                        double dx = localPointerCoords1.x - localPointerCoords2.x;
                        double dy = localPointerCoords1.y - localPointerCoords2.y;
                        double distance = Math.sqrt(dx * dx + dy * dy);
                        if (this.initialTwoFingerDistance < 0.0) {
                            this.initialTwoFingerDistance = distance;
                            this.lastTwoFingerDistance = distance;
                            this.zooming = true;
                        }
                        if ((dValueDistance = distance - this.lastTwoFingerDistance) != 0.0) {
                            double zoomRate = distance / this.initialTwoFingerDistance;
                            zoomRate = (zoomRate - 1.0) / 2.0 + 1.0;
                            if (3 == VRSoftEvent180.this.getDrawMode()) {
                                VRSoftEvent180.this.setZoom(this.zoomBaseValue * zoomRate);
                                VRSoftEvent180.this.drawView();
                                if (zoomRate < 1.0 && this.zoomBaseValue <= 10.0 && dValueDistance < -30.0) {
                                    VRSoftEvent180.this.switchToDrawMode(0);
                                }
                            } else if (zoomRate > 1.0 && dValueDistance > 20.0) {
                                VRSoftEvent180.this.switchToDrawMode(3);
                            }
                        }
                        this.lastTwoFingerDistance = distance;
                    }
                }
                return true;
            }
            return false;
        }
    }
}

