/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.pullrefresh;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.OverScroller;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.xm.ui.widget.pullrefresh.PullRefreshHeader;
import demo.xm.com.libxmfunsdk.R;

public class PullRefreshLayout
extends LinearLayout
implements NestedScrollingParent {
    public static final int SCROLL_DURATION = 500;
    private PullRefreshHeader mPullRefreshHeader;
    private RecyclerView mRecyclerView;
    private int mHeaderViewHeight;
    private double rate = 0.6;
    private int freshHeight;
    private int headContentHeight;
    private int icseeLoadingSize;
    private boolean isOnTouch = false;
    private boolean isExcuting = false;
    private boolean isFirst = true;
    private int mState = 3;
    private boolean finishScrollLock = false;
    private OnRefreshListener mOnRefreshListener;
    private OverScroller mScroller;
    Handler myHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 1: {
                    PullRefreshLayout.this.scrollTo(PullRefreshLayout.this.mHeaderViewHeight, true);
                    PullRefreshLayout.this.mState = 3;
                    break;
                }
                case 4: {
                    PullRefreshLayout.this.scrollTo(PullRefreshLayout.this.mHeaderViewHeight - PullRefreshLayout.this.headContentHeight, true);
                    if (PullRefreshLayout.this.mOnRefreshListener != null) {
                        PullRefreshLayout.this.mOnRefreshListener.refresh();
                    }
                    PullRefreshLayout.this.mState = 4;
                    break;
                }
                case 2: {
                    PullRefreshLayout.this.mState = 2;
                    break;
                }
                case 3: {
                    PullRefreshLayout.this.mState = 3;
                    break;
                }
            }
            if (PullRefreshLayout.this.getScrollY() <= PullRefreshLayout.this.mHeaderViewHeight - PullRefreshLayout.this.freshHeight) {
                PullRefreshLayout.this.mPullRefreshHeader.setState(msg.what, 1.0f);
            } else {
                PullRefreshLayout.this.mPullRefreshHeader.setState(msg.what, (float)(PullRefreshLayout.this.mHeaderViewHeight - PullRefreshLayout.this.getScrollY()) * 1.0f / (float)PullRefreshLayout.this.freshHeight);
            }
        }
    };

    public PullRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(1);
        this.addView((View)new PullRefreshHeader(context), 0);
        this.mScroller = new OverScroller(context);
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.PullRefreshLayout);
        this.freshHeight = (int)params.getDimension(R.styleable.PullRefreshLayout_refresh_height, (float)this.getResources().getDimensionPixelSize(R.dimen.pullrefresh_fresh_height));
        this.headContentHeight = (int)params.getDimension(R.styleable.PullRefreshLayout_head_height, (float)this.getResources().getDimensionPixelSize(R.dimen.pullrefresh_head_content_height));
        this.icseeLoadingSize = (int)params.getDimension(R.styleable.PullRefreshLayout_icsee_loading_size, (float)this.getResources().getDimensionPixelSize(R.dimen.pullrefresh_icsee_loading_size));
        params.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mPullRefreshHeader = (PullRefreshHeader)this.getChildAt(0);
        this.mPullRefreshHeader.setLoadingViewSize(this.icseeLoadingSize);
        View view = this.getChildAt(1);
        if (!(view instanceof RecyclerView)) {
            throw new RuntimeException("\u53ea\u652f\u6301RecyclerView");
        }
        this.mRecyclerView = (RecyclerView)view;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.getChildAt(0).measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        ViewGroup.LayoutParams params = this.mRecyclerView.getLayoutParams();
        params.height = this.getMeasuredHeight();
        this.setMeasuredDimension(this.getMeasuredWidth(), this.mPullRefreshHeader.getMeasuredHeight() + this.mRecyclerView.getMeasuredHeight());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mHeaderViewHeight = this.mPullRefreshHeader.getMeasuredHeight();
        this.initView();
    }

    private void initView() {
        if (this.isFirst) {
            this.scrollTo(this.mHeaderViewHeight, false);
        }
        this.isFirst = false;
    }

    public void scrollTo(int x, int y) {
        if (y < 0) {
            y = 0;
        }
        if (y > this.mHeaderViewHeight) {
            y = this.mHeaderViewHeight;
        }
        if (y != this.getScrollY()) {
            super.scrollTo(x, y);
        }
        if (y >= this.mHeaderViewHeight) {
            this.finishScrollLock = false;
        }
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return true;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
    }

    public void onStopNestedScroll(View target) {
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        boolean showTop;
        boolean hiddenTop = dy > 0 && this.getScrollY() < this.mHeaderViewHeight;
        boolean bl = showTop = dy < 0 && this.getScrollY() >= 0 && !ViewCompat.canScrollVertically((View)target, (int)-1);
        if (!this.finishScrollLock && this.isOnTouch && this.isExcuting && (hiddenTop || showTop)) {
            if (dy < -1) {
                dy = (int)((double)dy * this.rate + 0.5);
            }
            this.scrollBy(0, dy);
            consumed[0] = 0;
            consumed[1] = dy;
        }
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.getScrollY() < this.mHeaderViewHeight;
    }

    public int getNestedScrollAxes() {
        return 0;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.finishScrollLock) {
            return super.dispatchTouchEvent(ev);
        }
        switch (ev.getAction()) {
            case 0: {
                this.isOnTouch = true;
                this.isExcuting = true;
                break;
            }
            case 2: {
                if (this.getScrollY() <= this.mHeaderViewHeight - this.freshHeight) {
                    this.execute(2);
                    break;
                }
                this.execute(3);
                break;
            }
            case 1: {
                if (this.getScrollY() < this.mHeaderViewHeight) {
                    if (this.mState == 4 || this.mPullRefreshHeader.getState() == 4) {
                        if (this.getScrollY() <= this.mHeaderViewHeight - this.freshHeight) {
                            this.scrollTo(this.mHeaderViewHeight - this.headContentHeight, true);
                        }
                    } else if (this.getScrollY() <= this.mHeaderViewHeight - this.freshHeight) {
                        this.execute(4);
                    } else {
                        this.execute(1);
                    }
                }
                this.isOnTouch = false;
                break;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private void execute(int state) {
        this.myHandler.sendEmptyMessage(state);
    }

    public void finishRefresh() {
        this.finishScrollLock = true;
        this.scrollTo(this.mHeaderViewHeight, true);
        this.mState = 3;
    }

    private void scrollTo(int endY, boolean isAnimation) {
        if (isAnimation) {
            this.mScroller.startScroll(0, this.getScrollY(), 0, endY - this.getScrollY(), 500);
            this.invalidate();
        } else {
            this.scrollTo(0, endY);
        }
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.scrollTo(0, this.mScroller.getCurrY());
            this.invalidate();
            if (this.mScroller.getCurrY() >= this.mHeaderViewHeight) {
                this.mPullRefreshHeader.initViewState();
                this.isExcuting = false;
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.myHandler != null) {
            this.myHandler.removeCallbacksAndMessages(null);
        }
    }

    public void setOnRefreshListener(OnRefreshListener mOnRefreshListener) {
        this.mOnRefreshListener = mOnRefreshListener;
    }

    public static interface OnRefreshListener {
        public void refresh();
    }
}

