/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.icseelogoview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.xm.ui.widget.drawgeometry.model.GeometryPoints;
import com.xm.ui.widget.drawgeometry.utils.GeometryUtils;
import demo.xm.com.libxmfunsdk.R;

public class ICSeeLogoView
extends View {
    private static final float ACCELERATION = 0.2f;
    private static final float DECELERATION = 0.25f;
    private static final int DRAW_BALL_MODE_ROTATE = 0;
    private static final int DRAW_BALL_MODE_DESCENT = 1;
    private float ballAngle;
    private float afterAccelerationAngle;
    private float afterAccelerationSpeed;
    private float afterRotateX;
    private float afterRotateY;
    private float runTimeByAcceleration;
    private float runTimeByDeceleration;
    private float acceleration = 0.2f;
    private float deceleration = 0.2f;
    private float distanceToCenter;
    private float ballDownMaxHeight;
    private boolean isDown = true;
    private boolean isOutRotate = true;
    private boolean isInit;
    private boolean isStartAnimation;
    private boolean isShake;
    private int showBackgroundStep;
    private int ballRadius;
    private int drawBallMode = 0;
    private GeometryPoints ballPoints;

    public ICSeeLogoView(Context context) {
        this(context, null);
    }

    public ICSeeLogoView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ICSeeLogoView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.ballRadius = this.getWidth() / 20;
        this.drawBackground(canvas);
    }

    private void drawBackground(Canvas canvas) {
        int radius = this.getWidth() / 2;
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        if (this.showBackgroundStep >= 4) {
            paint.setColor(this.getResources().getColor(R.color.icsee_waiting_color_1));
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), (float)radius, paint);
        }
        if (this.showBackgroundStep >= 3) {
            radius = this.isShake && this.drawBallMode == 1 ? (int)((double)(this.getWidth() / 2) - (double)this.getWidth() * (Math.random() * 0.021999999999999992 + 0.158)) : (int)((double)(this.getWidth() / 2) - (double)this.getWidth() * 0.158);
            paint.setColor(this.getResources().getColor(R.color.icsee_waiting_color_2));
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), (float)radius, paint);
        }
        if (this.showBackgroundStep >= 2) {
            radius = (int)((double)(this.getWidth() / 2) - (double)this.getWidth() * 0.209);
            paint.setColor(this.getResources().getColor(R.color.icsee_waiting_color_3));
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), (float)radius, paint);
        }
        if (this.showBackgroundStep >= 1) {
            radius = (int)((double)(this.getWidth() / 2) - (double)this.getWidth() * 0.323);
            paint.setColor(this.getResources().getColor(R.color.icsee_waiting_color_4));
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), (float)radius, paint);
        }
        if (this.showBackgroundStep >= 0) {
            radius = (int)((double)(this.getWidth() / 2) - (double)this.getWidth() * 0.411);
            paint.setColor(this.getResources().getColor(R.color.icsee_waiting_color_5));
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), (float)radius, paint);
            paint.setColor(this.getResources().getColor(R.color.icsee_waiting_color_6));
            canvas.drawCircle((float)((double)(this.getWidth() / 2) + (Math.random() * -3.0 + 3.0)), (float)((double)((this.getWidth() - this.getWidth() / 25) / 2) + (Math.random() * -4.0 + 3.0)), (float)(this.getWidth() / 25), paint);
        }
        if (this.isStartAnimation) {
            switch (this.drawBallMode) {
                case 0: {
                    this.drawBallRotate(canvas);
                    break;
                }
                case 1: {
                    this.drawBallDescent(canvas);
                    break;
                }
            }
        }
    }

    private void drawBallRotate(Canvas canvas) {
        this.isShake = false;
        if (this.ballAngle <= 360.0f && this.ballAngle >= 0.0f) {
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setColor(-1);
            GeometryPoints centerPoints = new GeometryPoints((float)(this.getWidth() / 2), (float)(this.getWidth() / 2));
            this.ballPoints = GeometryUtils.getSameAngleDifferRadius((float)this.ballAngle, (float)this.distanceToCenter, (GeometryPoints)centerPoints);
            canvas.drawCircle(this.ballPoints.x, this.ballPoints.y, (float)this.ballRadius, paint);
        }
        if (this.isDown) {
            this.runTimeByDeceleration = 0.0f;
            this.afterAccelerationSpeed = 0.0f;
            this.afterAccelerationAngle = 0.0f;
            this.ballAngle = (float)((double)0.2f * Math.pow(this.runTimeByAcceleration += 1.0f, 2.0)) / 2.0f;
            if (this.ballAngle > 180.0f) {
                this.isDown = false;
                this.afterAccelerationSpeed = 0.2f * this.runTimeByAcceleration;
                this.afterAccelerationAngle = this.ballAngle;
                this.runTimeByAcceleration = 0.0f;
            }
        } else {
            this.runTimeByDeceleration += 1.0f;
            this.ballAngle = this.afterAccelerationAngle + (float)((double)(this.afterAccelerationSpeed * this.runTimeByDeceleration) - (double)this.deceleration * Math.pow(this.runTimeByDeceleration, 2.0) / 2.0);
            if (this.afterAccelerationAngle > 180.0f && this.ballAngle < 360.0f - this.afterAccelerationAngle || this.afterAccelerationAngle < 180.0f && this.ballAngle > 360.0f - this.afterAccelerationAngle) {
                this.afterAccelerationSpeed = this.deceleration * this.runTimeByDeceleration - this.afterAccelerationSpeed + 1.0f;
                this.afterAccelerationAngle = this.ballAngle;
                this.runTimeByDeceleration = 0.0f;
            }
        }
        if (this.ballAngle > 360.0f) {
            this.drawBallMode = 1;
            this.ballDownMaxHeight = this.isOutRotate ? (float)this.getWidth() : (float)((double)this.getWidth() - (double)this.getWidth() * 0.15);
            this.afterRotateX = this.ballPoints.x;
            this.afterRotateY = this.ballPoints.y;
            this.isOutRotate = !this.isOutRotate;
            this.isDown = true;
            this.drawBallDescent(canvas);
            return;
        }
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                ICSeeLogoView.this.postInvalidate();
            }
        }, 10L);
    }

    private void drawBallDescent(Canvas canvas) {
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(-1);
        canvas.drawCircle(this.ballPoints.x, this.ballPoints.y, (float)this.ballRadius, paint);
        if (this.isDown) {
            this.runTimeByDeceleration = 0.0f;
            this.afterAccelerationSpeed = 0.0f;
            this.afterAccelerationAngle = 0.0f;
            this.ballPoints.y = this.afterRotateY + (float)((double)0.2f * Math.pow(this.runTimeByAcceleration += 1.0f, 2.0)) / 2.0f;
            if (this.ballPoints.y + (float)this.ballRadius >= this.ballDownMaxHeight) {
                this.isDown = false;
                this.afterAccelerationSpeed = 0.2f * this.runTimeByAcceleration;
                this.afterAccelerationAngle = this.ballAngle;
                this.runTimeByAcceleration = 0.0f;
            }
        } else {
            this.runTimeByDeceleration += 1.0f;
            this.ballPoints.y = (float)(this.getWidth() - this.ballRadius) - (float)((double)(this.afterAccelerationSpeed * this.runTimeByDeceleration) - 0.25 * Math.pow(this.runTimeByDeceleration, 2.0) / 2.0);
            if (this.ballPoints.y + (float)this.ballRadius >= this.ballDownMaxHeight) {
                this.afterAccelerationSpeed = 0.25f * this.runTimeByDeceleration - this.afterAccelerationSpeed - 1.0f;
                this.runTimeByDeceleration = 0.0f;
                if (this.afterAccelerationSpeed <= 0.0f) {
                    this.deceleration = 0.25f;
                    this.drawBallMode = 0;
                    this.distanceToCenter = this.ballDownMaxHeight - (float)(this.getWidth() / 2) - (float)this.ballRadius;
                    this.afterAccelerationAngle = 185.0f;
                    this.isDown = false;
                    this.drawBallRotate(canvas);
                } else {
                    this.isShake = true;
                }
            } else if (this.ballPoints.y + (float)this.ballRadius <= this.ballDownMaxHeight / 2.0f) {
                this.isShake = false;
            }
        }
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                ICSeeLogoView.this.postInvalidate();
            }
        }, 10L);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus && !this.isInit) {
            this.distanceToCenter = (float)((double)(this.getWidth() / 2) - (double)this.getWidth() * 0.158 - (double)this.ballRadius);
            this.ballDownMaxHeight = this.getWidth();
            this.isInit = true;
        }
    }

    public void setBackgroundStep(float stepProgress) {
        this.showBackgroundStep = (int)(stepProgress * 4.0f);
        this.postInvalidate();
        System.out.println("showBackgroundStep:" + this.showBackgroundStep);
    }

    public void startAnimation() {
        this.isStartAnimation = true;
        this.postInvalidate();
    }

    public void stopAnimation() {
        this.isStartAnimation = false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private int measureWidth(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = this.getWidth() + this.getPaddingLeft() + this.getPaddingRight();
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    private int measureHeight(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = this.getHeight() + this.getPaddingTop() + this.getPaddingBottom();
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }
}

