/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.xm.ui.base.APP;
import com.xm.ui.widget.IXList;
import com.xm.ui.widget.adapter.IXListOnShow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class XListAdapter
extends BaseAdapter {
    public static final int ITEM_TEXT_VIEW = 0;
    public static final int ITEM_IMAGE_VIEW = 1;
    public static final int ITEM_LAYOUT_VIEW = 2;
    private LayoutInflater mInflater;
    int layoutId;
    int[] itemType;
    int[] itemId;
    ListView listView;
    private List<Map<Integer, Object>> Data = new ArrayList<Map<Integer, Object>>();
    IXList _user;
    IXListOnShow _showListener = null;
    ListItem holder = null;

    public XListAdapter(Context context, IXList user, View listView, int layoutId, int[] itemType, int[] itemId) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.listView = (ListView)listView;
        this._user = user;
        this.layoutId = layoutId;
        int count = itemType.length;
        this.itemType = new int[count];
        System.arraycopy(itemType, 0, this.itemType, 0, count);
        this.itemId = new int[count];
        System.arraycopy(itemId, 0, this.itemId, 0, count);
        this.listView.setAdapter((ListAdapter)this);
    }

    public ListView GetView() {
        return this.listView;
    }

    public void Clear() {
        this.Data.clear();
    }

    public void InsertItem(int nItemId, Object value, int nIndex, Object pObj) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        map.put(nItemId, value);
        if (nIndex >= 0) {
            this.Data.add(nIndex, map);
        } else {
            this.Data.add(map);
        }
        if (pObj != null) {
            map.put(this.layoutId, pObj);
        }
    }

    public void AddItem(Map<Integer, Object> map, Object obj) {
        map.put(this.layoutId, obj);
        this.Data.add(map);
    }

    public void AddItem(Map<Integer, Object> map) {
        this.Data.add(map);
    }

    public int getCount() {
        return this.Data.size();
    }

    public Map<Integer, Object> getItem(int postion) {
        if (postion < 0 || postion >= this.Data.size()) {
            return null;
        }
        Map<Integer, Object> map = this.Data.get(postion);
        return map;
    }

    public Map<Integer, Object> GetItemByObj(Object obj) {
        Iterator<Map<Integer, Object>> itr = this.Data.iterator();
        Map<Integer, Object> item = null;
        while (itr.hasNext()) {
            item = itr.next();
            Object objItem = item.get(this.layoutId);
            if (objItem == null || !objItem.equals(obj)) continue;
            return item;
        }
        return null;
    }

    public Object getMapItem(int postion, Integer key) {
        if (postion < 0 || postion >= this.Data.size()) {
            return null;
        }
        Map<Integer, Object> map = this.Data.get(postion);
        return map.get(key);
    }

    public Object getItemData(int postion) {
        if (postion < 0 || postion >= this.Data.size()) {
            return null;
        }
        Map<Integer, Object> map = this.Data.get(postion);
        return map.get(this.layoutId);
    }

    public long getItemId(int postion) {
        return 0L;
    }

    public void SetOnShowListener(IXListOnShow listener) {
        this._showListener = listener;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.mInflater.inflate(this.layoutId, null);
            this.holder = new ListItem(convertView, position);
            convertView.setTag((Object)this.holder);
        } else {
            this.holder = (ListItem)convertView.getTag();
        }
        this.holder.SetPosition(convertView, position);
        if (this._showListener != null) {
            this._showListener.OnShow(this, convertView, position, this.getItemData(position));
        }
        return convertView;
    }

    class ListItem
    implements View.OnClickListener {
        int position = 0;

        ListItem(View convertView, int position) {
            this.position = position;
            if (convertView instanceof ViewGroup) {
                APP.ListenAllBtns((ViewGroup)convertView, (View.OnClickListener)this);
            } else {
                int count = XListAdapter.this.itemType.length;
                for (int i = 0; i < count; ++i) {
                    convertView.findViewById(XListAdapter.this.itemId[i]).setOnClickListener((View.OnClickListener)this);
                }
            }
            convertView.setOnClickListener((View.OnClickListener)this);
        }

        void SetPosition(View convertView, int position) {
            this.position = position;
            int count = XListAdapter.this.itemType.length;
            block4: for (int i = 0; i < count; ++i) {
                switch (XListAdapter.this.itemType[i]) {
                    case 0: {
                        TextView tv = (TextView)convertView.findViewById(XListAdapter.this.itemId[i]);
                        String sText = (String)((Map)XListAdapter.this.Data.get(position)).get(XListAdapter.this.itemId[i]);
                        if (sText == null) continue block4;
                        tv.setText((CharSequence)sText);
                        continue block4;
                    }
                    case 1: {
                        ImageView iv = (ImageView)convertView.findViewById(XListAdapter.this.itemId[i]);
                        Integer imageId = (Integer)((Map)XListAdapter.this.Data.get(position)).get(XListAdapter.this.itemId[i]);
                        if (imageId == null || imageId == 0) continue block4;
                        iv.setImageResource(imageId.intValue());
                        continue block4;
                    }
                }
            }
        }

        public void onClick(View v) {
            XListAdapter.this._user.OnClickedItem(XListAdapter.this, v, this.position, ((Map)XListAdapter.this.Data.get(this.position)).get(XListAdapter.this.layoutId));
        }
    }
}

