/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import com.xm.ui.widget.listener.OnSelectedImageListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;

public class XImagesAdapter
extends BaseAdapter
implements View.OnClickListener {
    static final int N_IMAGE_SIZE = 8;
    ImageView[] _images = new ImageView[8];
    ArrayList<String> _fileList = new ArrayList();
    int _index = 0;
    ImageView _lastImage = null;
    final int SELECTED_ALPHA = 196;
    OnSelectedImageListener _listener;
    Context _context;
    Bitmap _defBmp = null;

    public XImagesAdapter(Context context) {
        this._context = context;
        for (int i = 0; i < 8; ++i) {
            this._images[i] = new ImageView(context);
            this._images[i].setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
            this._images[i].setAdjustViewBounds(true);
            this._images[i].setScaleType(ImageView.ScaleType.FIT_XY);
        }
        this._lastImage = this._images[1];
    }

    public void SetSelectedListener(OnSelectedImageListener listener) {
        this._listener = listener;
    }

    String GetSelectedImagePath() {
        return (String)this._lastImage.getTag();
    }

    public void SetDefultBmp(Bitmap defBmp) {
        this._defBmp = defBmp;
    }

    public boolean DeleteSeletect() {
        String path = this.GetSelectedImagePath();
        if (path == "") {
            return false;
        }
        File file = new File(path);
        try {
            if (file.isFile() && file.exists() && file.delete()) {
                this._lastImage.setImageBitmap(null);
                this._lastImage.setTag((Object)"");
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int UpdateList(String dir, String type, String query) {
        File[] file;
        this._fileList.clear();
        File baseFile = new File(dir);
        if (baseFile != null && baseFile.exists() && (file = baseFile.listFiles()) != null) {
            for (int i = file.length - 1; i > -1; --i) {
                String path = file[i].getPath();
                if (!file[i].isFile() || !path.endsWith(type) || !query.equals("") && !file[i].getName().contains(query)) continue;
                this._fileList.add(path);
            }
        }
        this.notifyDataSetChanged();
        if (this._fileList.size() > 0) {
            this._images[0].setTag((Object)this._fileList.get(0));
            this.OnSelected(this._images[0]);
        }
        return this._fileList.size();
    }

    public static Bitmap LoadImage(String url) {
        try {
            FileInputStream fis = new FileInputStream(url);
            return BitmapFactory.decodeStream((InputStream)fis);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap LoadImage(String pathName, int reqWidth, int reqHeight) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)opts);
        opts.inSampleSize = XImagesAdapter.GetSampleSize(opts.outWidth, opts.outHeight, reqWidth, reqHeight);
        opts.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)opts);
    }

    public static int GetSampleSize(int srcWidth, int srcHeight, int reqWidth, int reqHeight) {
        int inSampleSize = 1;
        if (srcHeight > reqHeight || srcWidth > reqWidth) {
            inSampleSize = srcWidth > srcHeight ? Math.round((float)srcHeight / (float)reqHeight) : Math.round((float)srcWidth / (float)reqWidth);
        }
        return inSampleSize;
    }

    public int getCount() {
        return this._fileList.size();
    }

    public Object getItem(int position) {
        return position;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View view, ViewGroup viewgroup) {
        File file;
        ImageView iv = this._images[position % 8];
        Bitmap bmp = null;
        String fileName = this._fileList.get(position);
        iv.setTag((Object)fileName);
        if (!fileName.endsWith(".bmp") && !fileName.endsWith(".jpg")) {
            fileName = fileName.substring(0, fileName.length() - 3) + "bmp";
        }
        bmp = (file = new File(fileName)).isFile() ? XImagesAdapter.LoadImage(fileName, 200, 200) : this._defBmp;
        iv.setImageBitmap(bmp);
        iv.setOnClickListener((View.OnClickListener)this);
        return iv;
    }

    void OnSelected(ImageView iv) {
        if (!iv.equals(this._lastImage)) {
            this._lastImage.setAlpha(255);
            this._lastImage = iv;
        }
        iv.setAlpha(196);
        if (this._listener != null) {
            this._listener.OnSelectedImage((View)iv);
        }
    }

    public void onClick(View v) {
        this.OnSelected((ImageView)v);
    }
}

