/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.xm.ui.widget.data.RecordInfo;
import demo.xm.com.libxmfunsdk.R;

public class XMRecordView
extends View {
    private static final int BOTTOM_LINE_HEIGHT = 40;
    private int mTimeUnit;
    private char[][] mRecordInfos;
    private Paint mPaint = new Paint();
    private Paint mLinePaint = new Paint();
    private String mShowTime;
    private boolean mbShow = false;
    private boolean mbLast = false;
    private int mLineColor;
    private float mTimeLineSize;
    private int mTimeTextColor;
    private float mTimeTextSize;
    private float mTimeBottomPadding;
    private int mAlpha;

    public XMRecordView(Context context) {
        super(context);
        this.initData();
    }

    public XMRecordView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.TimeAxis);
        this.mLineColor = params.getColor(R.styleable.TimeAxis_TimeLineColor, -7829368);
        this.mTimeTextColor = params.getColor(R.styleable.TimeAxis_TimeLineColor, -7829368);
        this.mTimeTextSize = params.getDimension(R.styleable.TimeAxis_TimeTextSize, 25.0f);
        this.mTimeBottomPadding = params.getDimension(R.styleable.TimeAxis_TimeTextSize, 5.0f);
        this.mTimeLineSize = params.getDimension(R.styleable.TimeAxis_TimeLineSize, 1.5f);
        this.mAlpha = params.getInteger(R.styleable.TimeAxis_TimeAxisAlpha, 204);
        params.recycle();
        this.initData();
    }

    private void initData() {
        this.mPaint.setStrokeWidth(this.mTimeLineSize);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setAlpha(this.mAlpha);
        this.mLinePaint.setStrokeWidth(this.mTimeLineSize);
        this.mLinePaint.setAntiAlias(true);
        this.mLinePaint.setColor(this.mLineColor);
        this.mLinePaint.setTextSize(this.mTimeTextSize);
    }

    public void setData(char[][] infos) {
        this.mRecordInfos = infos;
    }

    public void setTimeUnit(int unit) {
        this.mTimeUnit = unit;
    }

    public int getTimeUnit() {
        return this.mTimeUnit;
    }

    public void setShowTime(String showTime) {
        this.mShowTime = showTime;
    }

    public void setShow(boolean bShow) {
        this.mbShow = bShow;
    }

    public void setLastTime(boolean bLast) {
        this.mbLast = bLast;
    }

    protected void onDraw(Canvas canvas) {
        if (!this.mbShow) {
            return;
        }
        int count = 0;
        if (null != this.mRecordInfos && this.mRecordInfos.length > 0) {
            for (char[] recordInfos : this.mRecordInfos) {
                if (recordInfos == null) continue;
                for (char recordInfo : recordInfos) {
                    int type = recordInfo & 0xF;
                    if (type < RecordInfo.color_type.length && type > 0) {
                        this.mPaint.setColor(RecordInfo.color_type[type]);
                        canvas.drawRect((float)(count * 60 * this.getWidth() / this.mTimeUnit), 0.0f, (float)((count + 1) * 60 * this.getWidth() / this.mTimeUnit), (float)(this.getHeight() - 40), this.mPaint);
                    }
                    ++count;
                    type = recordInfo >> 4 & 0xF;
                    if (type < RecordInfo.color_type.length && type > 0) {
                        this.mPaint.setColor(RecordInfo.color_type[type]);
                        canvas.drawRect((float)(count * 60 * this.getWidth() / this.mTimeUnit), 0.0f, (float)((count + 1) * 60 * this.getWidth() / this.mTimeUnit), (float)(this.getHeight() - 40), this.mPaint);
                    }
                    ++count;
                }
            }
        }
        canvas.drawLine(0.0f, 1.0f, (float)this.getWidth(), 1.0f, this.mLinePaint);
        canvas.drawLine(0.0f, (float)(this.getHeight() - 40), (float)this.getWidth(), (float)(this.getHeight() - 40), this.mLinePaint);
        canvas.drawLine(1.0f, (float)(this.getHeight() - 40), 1.0f, (float)this.getHeight(), this.mLinePaint);
        for (int i = 1; i < 6; ++i) {
            canvas.drawLine((float)(i * this.getWidth() / 6), (float)(this.getHeight() - 40), (float)(i * this.getWidth() / 6), (float)(this.getHeight() - 20), this.mLinePaint);
        }
        if (this.mShowTime != null && this.mShowTime.length() > 0) {
            canvas.drawText(this.mShowTime, 0.0f, (float)this.getHeight() - this.mTimeBottomPadding, this.mLinePaint);
        }
        super.onDraw(canvas);
    }
}

