/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.XImages;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.media.ThumbnailUtils;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.utils.PathUtils;
import com.utils.XUtils;
import com.xm.ui.base.APP;
import com.xm.ui.widget.XImages.IImagesAdapter;
import com.xm.ui.widget.XImages.IOnFileThumbnail;
import com.xm.ui.widget.XImages.XImagesGridViewAdt;
import com.xm.ui.widget.XImages.XImagesItemData;
import demo.xm.com.libxmfunsdk.R;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@SuppressLint(value={"UseSparseArrays"})
public class XImagesListAdapter
extends BaseAdapter {
    static final int N_BUF_PAGE_COUNT = 3;
    static final int N_COLUM_COUNT = 4;
    LayoutInflater mInflater;
    ListView mListView;
    Context mContext;
    boolean mRunning = true;
    Handler mHandler;
    IImagesAdapter mImagesAdt;
    int N_IMAGE_SIZE = 0;
    ImageItem[] mBufViews = null;
    int mOnePageCount = 0;
    int mDealBmpCount = 0;
    int mStartPosition = 0;
    int mEndPosition = 0;
    int mLastPostion = -1;
    int mCurPostion = 0;
    int mItemSize = 180;
    int mImageSize = 180;
    Bitmap mDefBmp = null;
    List<XImagesGroupData> mDatas = new ArrayList<XImagesGroupData>();
    List<XImagesItemData> mFilesList = new ArrayList<XImagesItemData>();
    PreImageThread[] mImageLoad = new PreImageThread[2];
    static String thumbnailPath;
    List<ViewHolder> mHolderList = new ArrayList<ViewHolder>();
    Map<Integer, ImageItem> mTasks = new HashMap<Integer, ImageItem>();
    @SuppressLint(value={"UseSparseArrays"})
    Map<Integer, ImageItem> mTasking = new HashMap<Integer, ImageItem>();
    static IOnFileThumbnail _onFileThumbnail;

    public XImagesListAdapter(Context context, View listView, IImagesAdapter adapter) {
        this.mContext = context;
        this.mImagesAdt = adapter;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mListView = (ListView)listView;
        this.mListView.setAdapter((ListAdapter)this);
        thumbnailPath = PathUtils.getAndroidPath(context);
        this.mItemSize = (APP.GetScreenWidth() - 10 - 4) / 4;
        this.mImageSize = this.mItemSize - 1;
        this.mOnePageCount = (APP.GetScreenHeight() + this.mItemSize / 2) / this.mItemSize * 4;
        this.N_IMAGE_SIZE = 3 * this.mOnePageCount;
        System.out.println("N_IMAGE_SIZE:" + this.N_IMAGE_SIZE);
        this.mBufViews = new ImageItem[this.N_IMAGE_SIZE];
        for (int i = 0; i < this.N_IMAGE_SIZE; ++i) {
            this.mBufViews[i] = new ImageItem();
            this.mBufViews[i].mView = adapter.NewView(context);
            this.mBufViews[i].mView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(this.mItemSize, this.mItemSize));
        }
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (msg.what == 1) {
                    --XImagesListAdapter.this.mDealBmpCount;
                    ImageItem item = (ImageItem)msg.obj;
                    ImageItem curitem = XImagesListAdapter.this.mBufViews[item.mImageIndex];
                    if (curitem.mObj != item.mObj) {
                        XImagesListAdapter.this.PopTask(item);
                        return;
                    }
                    ImageView iv = XImagesListAdapter.this.mImagesAdt.GetImageView(curitem.mView);
                    if (iv != null) {
                        if (curitem.mBmp != item.mBmp) {
                            iv.setImageBitmap(item.mBmp);
                            if (curitem.mBmp != null) {
                                if (!curitem.mBmp.equals(XImagesListAdapter.this.mDefBmp)) {
                                    curitem.mBmp.recycle();
                                }
                                curitem.mBmp = null;
                            }
                            curitem.mBmp = item.mBmp;
                        }
                        item.mBmp = null;
                        System.gc();
                    }
                    XImagesListAdapter.this.PopTask(item);
                }
            }
        };
        this.StartLoadThread();
    }

    public int GetOnPageCount() {
        return this.mOnePageCount;
    }

    public View[] GetShowItems() {
        View[] vs = new View[this.mBufViews.length];
        for (int i = 0; i < this.mBufViews.length; ++i) {
            vs[i] = this.mBufViews[i].mView;
        }
        return vs;
    }

    public List<XImagesItemData> GetItemsData() {
        return this.mFilesList;
    }

    public void StartLoadThread() {
        this.mRunning = true;
        for (int i = 0; i < this.mImageLoad.length; ++i) {
            this.mImageLoad[i] = new PreImageThread(this.mHandler);
            this.mImageLoad[i].Start();
        }
    }

    public void StopLoadThread() {
        this.mRunning = false;
        for (int i = 0; i < this.mImageLoad.length; ++i) {
            if (this.mImageLoad[i] == null) continue;
            this.mImageLoad[i] = null;
        }
    }

    public ListView GetView() {
        return this.mListView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Clear() {
        List<XImagesGroupData> list = this.mDatas;
        synchronized (list) {
            this.mDatas.clear();
            this.mFilesList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AddItem(String path, int[] times, Object obj) {
        XImagesGroupData groupItem = null;
        String title = times[0] + "/" + times[1] + "/" + times[2];
        int nInsert = 0;
        int seconds = times[3] * 3600 + times[4] * 60 + times[5];
        int days = times[0] * 480 + times[1] * 40 + times[2];
        List<XImagesGroupData> list = this.mDatas;
        synchronized (list) {
            int i;
            for (i = 0; i < this.mDatas.size(); ++i) {
                XImagesGroupData item = this.mDatas.get(i);
                if (item.mDays != days) continue;
                groupItem = item;
                break;
            }
            if (groupItem == null) {
                groupItem = new XImagesGroupData();
                groupItem.mTitle = title;
                groupItem.mDays = days;
                nInsert = this.mDatas.size();
                for (i = 0; i < this.mDatas.size(); ++i) {
                    if (this.mDatas.get((int)i).mDays > days) continue;
                    nInsert = i;
                    break;
                }
                this.mDatas.add(nInsert, groupItem);
            }
            ++groupItem.mCount;
            XImagesItemData newItem = new XImagesItemData();
            newItem.mDays = days;
            newItem.mSeconds = (long)seconds + (long)newItem.mDays * 86400L;
            newItem.mFilePath = path;
            newItem.mUserObj = obj;
            newItem.parent = groupItem;
            int i2 = 0;
            for (i2 = 0; i2 < this.mFilesList.size(); ++i2) {
                XImagesItemData item = this.mFilesList.get(i2);
                if (item.mSeconds <= newItem.mSeconds) break;
            }
            this.mFilesList.add(i2, newItem);
            return i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RemoveItem(String path) {
        int nIndex = this.GetIndexByPath(path);
        if (nIndex != -1) {
            List<XImagesGroupData> list = this.mDatas;
            synchronized (list) {
                this.RemoveItemByIndex(nIndex);
            }
        }
    }

    private void RemoveItemByIndex(int nIndex) {
        if (nIndex < 0 || nIndex >= this.mFilesList.size()) {
            return;
        }
        XImagesItemData item = this.mFilesList.get(nIndex);
        this.mFilesList.remove(nIndex);
        XImagesGroupData itemGroup = item.parent;
        --itemGroup.mCount;
        if (itemGroup.mCount == 0) {
            this.mDatas.remove(itemGroup);
        }
        item = null;
    }

    private int GetIndexByPath(String path) {
        for (int i = 0; i < this.mFilesList.size(); ++i) {
            XImagesItemData item = this.mFilesList.get(i);
            if (!item.mFilePath.equals(path)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Update() {
        XImagesListAdapter xImagesListAdapter = this;
        synchronized (xImagesListAdapter) {
            for (int i = 0; i < this.mBufViews.length; ++i) {
                this.RecyClyBmp(this.mBufViews[i]);
            }
            this.notifyDataSetChanged();
            this.mCurPostion = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ImageUpdate(String filePath) {
        XImagesListAdapter xImagesListAdapter = this;
        synchronized (xImagesListAdapter) {
            for (int i = 0; i < this.mBufViews.length; ++i) {
                if (this.mBufViews[i].mPath == null || !this.mBufViews[i].mPath.equals(filePath)) continue;
                this.RecyClyBmp(this.mBufViews[i]);
                this.PushTask(this.mBufViews[i].mPosition);
                break;
            }
        }
    }

    void RecyClyBmp(ImageItem item) {
        ImageView iv = this.mImagesAdt.GetImageView(item.mView);
        if (item.mBmp != null) {
            iv.setImageBitmap(null);
            if (!item.mBmp.equals(this.mDefBmp)) {
                item.mBmp.recycle();
            }
            item.mBmp = null;
        }
    }

    public int getDaysPosition(int[] times) {
        int nDays = times[0] * 480 + times[1] * 40 + times[2];
        for (int i = 0; i < this.mFilesList.size(); ++i) {
            if (this.mFilesList.get((int)i).mDays != nDays) continue;
            return i;
        }
        return -1;
    }

    public Object getItem(int position) {
        if (position > 0 && position < this.mFilesList.size()) {
            return this.mFilesList.get((int)position).mUserObj;
        }
        return null;
    }

    public long getItemId(int arg0) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        int nStartPos = 0;
        int nFilesIndex = 0;
        List<XImagesGroupData> list = this.mDatas;
        synchronized (list) {
            for (int i = 0; i < this.mDatas.size(); ++i) {
                XImagesGroupData item = this.mDatas.get(i);
                int nGroupCount = (item.mCount + 3) / 4;
                item.mStartGroup = nStartPos;
                item.mEndGroup = nStartPos + nGroupCount;
                item.mFilesIndex = nFilesIndex;
                nStartPos += nGroupCount;
                nFilesIndex += item.mCount;
            }
        }
        return nStartPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int GetStartIndex(int nPosition) {
        List<XImagesGroupData> list = this.mDatas;
        synchronized (list) {
            int nStartIndex = 0;
            for (int i = 0; i < nPosition; ++i) {
                nStartIndex += this.mDatas.get((int)i).mCount;
            }
            return nStartIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XImagesGroupData GetGroud(int nPosition) {
        int nStartPos = 0;
        int nFilesIndex = 0;
        List<XImagesGroupData> list = this.mDatas;
        synchronized (list) {
            for (int i = 0; i < this.mDatas.size(); ++i) {
                XImagesGroupData item = this.mDatas.get(i);
                int nGroupCount = (item.mCount + 3) / 4;
                if (nStartPos + nGroupCount > nPosition) {
                    item.mStartGroup = nStartPos;
                    item.mEndGroup = nStartPos + nGroupCount;
                    item.mFilesIndex = nFilesIndex;
                    return item;
                }
                nStartPos += nGroupCount;
                nFilesIndex += item.mCount;
            }
        }
        return null;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        System.out.println("TEST_CC:" + position);
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.funsdk_item_images, null);
            holder = new ViewHolder();
            this.mHolderList.add(holder);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        XImagesGroupData item = this.GetGroud(position);
        holder.InitParams(position, (TextView)convertView.findViewById(R.id.tvTitle), convertView.findViewById(R.id.img_line), (GridView)convertView.findViewById(R.id.gvImages));
        if (item.mStartGroup != position) {
            holder.mTextView.setVisibility(8);
            holder.mLine.setVisibility(8);
        } else {
            holder.mTextView.setVisibility(0);
            holder.mLine.setVisibility(0);
            holder.mTextView.setText((CharSequence)item.mTitle);
        }
        if (item.mEndGroup - 1 == position) {
            convertView.setPadding(0, 0, 0, XUtils.dp2px(this.mContext, 6));
        } else {
            convertView.setPadding(0, 0, 0, 0);
        }
        int nStartIndex = item.mFilesIndex + (position - item.mStartGroup) * 4;
        int nCount = 4;
        if (position == item.mEndGroup - 1 && item.mCount % 4 > 0) {
            nCount = item.mCount % 4;
        }
        holder.mImagesAdt.Update(nStartIndex, nCount);
        return convertView;
    }

    public View getView(int nStartIndex, int nPosition, View view, ViewGroup viewgroup) {
        int nCurPostion = nStartIndex + nPosition;
        System.out.println("TEST_AA:" + nStartIndex + "/" + nPosition + "/" + nCurPostion);
        View iv = this.mBufViews[nCurPostion % this.N_IMAGE_SIZE].mView;
        this.mLastPostion = nCurPostion;
        this.mImagesAdt.OnShow(iv, this.mFilesList.get((int)nCurPostion).mUserObj);
        return iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void PopTask(ImageItem item) {
        XImagesListAdapter xImagesListAdapter = this;
        synchronized (xImagesListAdapter) {
            if (this.mTasking.containsKey(item.mPosition)) {
                if (item.mBmp != null) {
                    if (!item.mBmp.equals(this.mDefBmp)) {
                        item.mBmp.recycle();
                    }
                    item.mBmp = null;
                }
                this.mTasking.remove(item.mPosition);
            }
        }
    }

    void PushTask(int i) {
        ImageItem taskItem;
        if (i < this.mStartPosition || i >= this.mEndPosition) {
            return;
        }
        int j = i % this.N_IMAGE_SIZE;
        ImageItem item = this.mBufViews[j];
        if (item.mPosition == i && item.mBmp != null) {
            return;
        }
        item.mPosition = i;
        item.mImageIndex = j;
        item.mObj = this.mFilesList.get(i);
        item.mPath = this.mFilesList.get((int)item.mPosition).mFilePath;
        this.RecyClyBmp(item);
        if (this.mTasks.containsKey(i)) {
            ImageItem taskItem2 = this.mTasks.get(i);
            taskItem2.mImageIndex = j;
            taskItem2.mPosition = i;
            taskItem2.mObj = item.mObj;
            taskItem2.mPath = item.mPath;
            return;
        }
        if (this.mTasking.containsKey(i)) {
            taskItem = this.mTasking.get(i);
            if (taskItem.mObj == item.mObj) {
                return;
            }
            if (taskItem.mBmp != null) {
                if (!taskItem.mBmp.equals(this.mDefBmp)) {
                    taskItem.mBmp.recycle();
                }
                taskItem.mBmp = null;
            }
            this.mTasking.remove(i);
        }
        taskItem = new ImageItem();
        taskItem.mImageIndex = j;
        taskItem.mPosition = i;
        taskItem.mObj = item.mObj;
        taskItem.mBmp = null;
        this.mTasks.put(i, taskItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImageItem GetTask() {
        XImagesListAdapter xImagesListAdapter = this;
        synchronized (xImagesListAdapter) {
            if (this.mLastPostion != this.mCurPostion) {
                this.mCurPostion = this.mLastPostion;
                this.mStartPosition = this.mCurPostion - this.N_IMAGE_SIZE / 2;
                if (this.mStartPosition < 0) {
                    this.mStartPosition = 0;
                }
                this.mEndPosition = this.mStartPosition + this.N_IMAGE_SIZE - 4;
                if (this.mEndPosition > this.mFilesList.size()) {
                    this.mEndPosition = this.mFilesList.size();
                }
                for (int i = this.mStartPosition; i < this.mEndPosition; ++i) {
                    this.PushTask(i);
                }
            }
            Iterator<Integer> it = this.mTasks.keySet().iterator();
            while (it.hasNext()) {
                int key = it.next();
                if (key >= this.mStartPosition && key <= this.mEndPosition) {
                    ImageItem item = this.mTasks.get(key);
                    this.mTasks.remove(key);
                    this.mTasking.put(key, item);
                    if (item != null) {
                        // empty if block
                    }
                    return item;
                }
                this.mTasks.remove(key);
                it = this.mTasks.keySet().iterator();
            }
            return null;
        }
    }

    public static void saveBitmap(Bitmap bm, String path) {
        File f = new File(path);
        if (f.exists()) {
            f.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(f);
            bm.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static boolean isFolderExists(String strFolder) {
        File file = new File(strFolder);
        if (!file.exists()) {
            return file.mkdir();
        }
        return true;
    }

    public static Bitmap getImageThumbnail(String thumbnailPath, String imagePath, int width, int height) {
        int nT = imagePath.lastIndexOf(46);
        if (nT == -1) {
            return null;
        }
        int nP = imagePath.lastIndexOf(47, nT);
        if (nP == -1) {
            return null;
        }
        File f = new File(imagePath);
        if (f == null || !f.exists()) {
            return null;
        }
        String type = imagePath.substring(nT, imagePath.length());
        String path = thumbnailPath + File.separator;
        String name = imagePath.substring(nP + 1, nT);
        String temp = path + "ximages_temp/" + name + "_" + width + "_" + height + "_" + f.lastModified() + ".png";
        Bitmap bitmap = null;
        bitmap = XImagesListAdapter.getImageThumbnail2(imagePath, width, height);
        return bitmap;
    }

    public static Bitmap getImageThumbnail2(String imagePath, int width, int height) {
        if (null == imagePath) {
            return null;
        }
        if (!(imagePath.endsWith(".mp4") || imagePath.endsWith(".jpg") || imagePath.endsWith(".jpeg") || imagePath.endsWith(".bmp") || imagePath.endsWith(".png"))) {
            if (_onFileThumbnail != null) {
                String file2 = _onFileThumbnail.Thumbnail(imagePath);
                if (file2.endsWith(".jpg") || file2.endsWith(".jpeg")) {
                    return XImagesListAdapter.getImageThumbnail2(file2, width, height);
                }
                return null;
            }
            return null;
        }
        Bitmap bitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        int h = options.outHeight;
        int w = options.outWidth;
        if (width <= 0) {
            width = w;
        }
        if (height <= 0) {
            height = h;
        }
        int beWidth = w / width;
        int beHeight = h / height;
        int be = 1;
        be = beWidth < beHeight ? beWidth : beHeight;
        if (be <= 0) {
            be = 1;
        }
        options.inSampleSize = be;
        bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        if (null != bitmap) {
            bitmap = ThumbnailUtils.extractThumbnail((Bitmap)bitmap, (int)width, (int)height, (int)2);
        }
        return bitmap;
    }

    public static Bitmap getThumbnail(String thumbnailPath, String path, int width, int height) {
        if (path.endsWith(".mp4")) {
            return XImagesListAdapter.getVideoThumbnail(thumbnailPath, path, width, height, 1);
        }
        return XImagesListAdapter.getImageThumbnail(thumbnailPath, path, width, height);
    }

    static Bitmap getVideoThumbnail(String thumbnailPath, String videoPath, int width, int height, int kind) {
        int nT = videoPath.lastIndexOf(46);
        if (nT == -1) {
            return null;
        }
        int nP = videoPath.lastIndexOf(47, nT);
        if (nP == -1) {
            return null;
        }
        String type = videoPath.substring(nT, videoPath.length());
        String path = thumbnailPath + File.separator;
        String name = videoPath.substring(nP + 1, nT);
        String temp = path + "ximages_temp/" + name + "_" + width + "_" + height + ".png";
        Bitmap bitmap = XImagesListAdapter.getVideoThumbnail2(videoPath, width, height, kind);
        return bitmap;
    }

    static Bitmap getVideoThumbnail2(String videoPath, int width, int height, int kind) {
        Bitmap bitmap = null;
        bitmap = ThumbnailUtils.createVideoThumbnail((String)videoPath, (int)kind);
        bitmap = ThumbnailUtils.extractThumbnail((Bitmap)bitmap, (int)width, (int)height, (int)2);
        return bitmap;
    }

    public void SetDefBitmap(int nResId) {
        if (nResId != 0) {
            Resources r = this.mContext.getResources();
            InputStream is = r.openRawResource(nResId);
            BitmapDrawable bmpDraw = new BitmapDrawable(is);
            this.mDefBmp = bmpDraw.getBitmap();
        }
    }

    public static void SetOnFileTypeThumbnail(IOnFileThumbnail obj) {
        _onFileThumbnail = obj;
    }

    static {
        _onFileThumbnail = null;
    }

    class XImagesGroupData {
        public String mTitle;
        public int mDays;
        public int mCount;
        public int mFilesIndex;
        public int mStartGroup;
        public int mEndGroup;

        XImagesGroupData() {
        }
    }

    class PreImageThread
    extends Thread {
        Handler mHandler;

        public PreImageThread(Handler handler) {
            this.mHandler = handler;
        }

        public void Start() {
            this.start();
        }

        @Override
        public void run() {
            while (XImagesListAdapter.this.mRunning) {
                ImageItem item = XImagesListAdapter.this.GetTask();
                if (item == null) {
                    try {
                        Thread.sleep(4L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                String path = XImagesListAdapter.this.mFilesList.get((int)item.mPosition).mFilePath;
                if (path.startsWith("/")) {
                    File file = new File(path);
                    if (file.isFile()) {
                        item.mBmp = XImagesListAdapter.getThumbnail(thumbnailPath, path, XImagesListAdapter.this.mImageSize, XImagesListAdapter.this.mImageSize);
                    }
                    file = null;
                }
                if (item.mBmp == null) {
                    item.mBmp = XImagesListAdapter.this.mDefBmp;
                }
                ++XImagesListAdapter.this.mDealBmpCount;
                Message message = new Message();
                message.what = 1;
                message.obj = item;
                this.mHandler.sendMessage(message);
            }
        }
    }

    class ImageItem {
        View mView = null;
        Bitmap mBmp = null;
        Object mObj = null;
        String mPath = "";
        int mImageIndex = 0;
        int mPosition = 0;

        ImageItem() {
        }
    }

    class ViewHolder {
        int mPosition;
        TextView mTextView;
        View mLine;
        GridView mGridView;
        XImagesGridViewAdt mImagesAdt = null;
        int mDays;

        ViewHolder() {
        }

        public void InitParams(int nPosition, TextView tvTitle, View line, GridView images) {
            this.mPosition = nPosition;
            this.mTextView = tvTitle;
            this.mLine = line;
            this.mGridView = images;
            if (this.mImagesAdt == null) {
                this.mImagesAdt = new XImagesGridViewAdt(this.mGridView, XImagesListAdapter.this, XImagesListAdapter.this.mContext, 4, XImagesListAdapter.this.mItemSize);
            }
            this.mGridView.setAdapter((ListAdapter)this.mImagesAdt);
        }
    }
}

