/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.utils.TimeUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TimeTextView
extends TextView {
    public static final int PERIOD = 1000;
    public static final int SHOW_DATE = 0;
    public static final int SHOW_TIMES = 1;
    private Timer mTimer;
    private ScheduledExecutorService mService;
    private long mDevSysTime = System.currentTimeMillis();
    private int mShowTimeFormat = 0;

    public TimeTextView(Context context) {
        super(context);
    }

    public TimeTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TimeTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setShowTimeFormat(int showTimeFormat) {
        this.mShowTimeFormat = showTimeFormat;
    }

    public long getDevSysTime() {
        return this.mDevSysTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDevSysTime(long devSysTime) {
        TimeTextView timeTextView = this;
        synchronized (timeTextView) {
            this.mDevSysTime = devSysTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer() {
        TimeTextView timeTextView = this;
        synchronized (timeTextView) {
            if (this.mTimer != null && this.mService != null) {
                this.mService.shutdown();
                this.mService = null;
                this.mTimer = null;
            }
            this.mTimer = new Timer();
            this.mService = Executors.newScheduledThreadPool(1);
            this.mService.scheduleAtFixedRate(this.mTimer, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        TimeTextView timeTextView = this;
        synchronized (timeTextView) {
            if (this.mTimer != null && this.mService != null) {
                this.mService.shutdown();
                this.mService = null;
                this.mTimer = null;
            }
        }
    }

    protected void onDetachedFromWindow() {
        this.stopTimer();
        super.onDetachedFromWindow();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility != 0) {
            this.stopTimer();
            this.mDevSysTime = System.currentTimeMillis();
        }
    }

    class Timer
    implements Runnable {
        Timer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Timer timer = this;
            synchronized (timer) {
                if (TimeTextView.this.mShowTimeFormat == 0) {
                    TimeTextView.this.mDevSysTime += 1000L;
                } else if (TimeTextView.this.mShowTimeFormat == 1) {
                    TimeTextView.this.mDevSysTime += 1L;
                }
                TimeTextView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (TimeTextView.this.mShowTimeFormat == 0) {
                            TimeTextView.this.setText(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(TimeTextView.this.mDevSysTime)));
                        } else if (TimeTextView.this.mShowTimeFormat == 1) {
                            TimeTextView.this.setText(TimeUtils.formatTimes((int)((int)TimeTextView.this.mDevSysTime)));
                        }
                    }
                });
            }
        }
    }
}

