/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.LinearLayout;
import demo.xm.com.libxmfunsdk.R;
import java.util.ArrayList;

public class RevealLayout
extends LinearLayout
implements Runnable {
    private Paint mPaint = new Paint(1);
    private int mTargetWidth;
    private int mTargetHeight;
    private int mMinBetweenWidthAndHeight;
    private int mMaxBetweenWidthAndHeight;
    private int mMaxRevealRadius;
    private int mRevealRadiusGap;
    private int mRevealRadius = 0;
    private float mCenterX;
    private float mCenterY;
    private int[] mLocationInScreen = new int[2];
    private boolean mShouldDoAnimation = false;
    private boolean mIsPressed = false;
    private int INVALIDATE_DURATION = 50;
    private View mTouchTarget;
    private DispatchUpTouchEventRunnable mDispatchUpTouchEventRunnable = new DispatchUpTouchEventRunnable();

    public RevealLayout(Context context) {
        super(context);
        this.init();
    }

    public RevealLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    @TargetApi(value=11)
    public RevealLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        this.mPaint.setColor(this.getResources().getColor(R.color.reveal_color));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.getLocationOnScreen(this.mLocationInScreen);
    }

    private void initParametersForChild(MotionEvent event, View view) {
        this.mCenterX = event.getX();
        this.mCenterY = event.getY();
        this.mTargetWidth = view.getMeasuredWidth();
        this.mTargetHeight = view.getMeasuredHeight();
        this.mMinBetweenWidthAndHeight = Math.min(this.mTargetWidth, this.mTargetHeight);
        this.mMaxBetweenWidthAndHeight = Math.max(this.mTargetWidth, this.mTargetHeight);
        this.mRevealRadius = 0;
        this.mShouldDoAnimation = true;
        this.mIsPressed = true;
        this.mRevealRadiusGap = this.mMinBetweenWidthAndHeight / 8;
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int left = location[0] - this.mLocationInScreen[0];
        int transformedCenterX = (int)this.mCenterX - left;
        this.mMaxRevealRadius = Math.max(transformedCenterX, this.mTargetWidth - transformedCenterX);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (!this.mShouldDoAnimation || this.mTargetWidth <= 0 || this.mTouchTarget == null) {
            return;
        }
        this.mRevealRadius = this.mRevealRadius > this.mMinBetweenWidthAndHeight / 2 ? (this.mRevealRadius += this.mRevealRadiusGap * 4) : (this.mRevealRadius += this.mRevealRadiusGap);
        this.getLocationOnScreen(this.mLocationInScreen);
        int[] location = new int[2];
        this.mTouchTarget.getLocationOnScreen(location);
        int left = location[0] - this.mLocationInScreen[0];
        int top = location[1] - this.mLocationInScreen[1];
        int right = left + this.mTouchTarget.getMeasuredWidth();
        int bottom = top + this.mTouchTarget.getMeasuredHeight();
        canvas.save();
        canvas.clipRect(left, top, right, bottom);
        canvas.drawCircle(this.mCenterX, this.mCenterY, (float)this.mRevealRadius, this.mPaint);
        canvas.restore();
        if (this.mRevealRadius <= this.mMaxRevealRadius) {
            this.postInvalidateDelayed(this.INVALIDATE_DURATION, left, top, right, bottom);
        } else if (!this.mIsPressed) {
            this.mShouldDoAnimation = false;
            this.postInvalidateDelayed(this.INVALIDATE_DURATION, left, top, right, bottom);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        int x = (int)event.getRawX();
        int y = (int)event.getRawY();
        int action = event.getAction();
        if (action == 0) {
            View touchTarget = this.getTouchTarget((View)this, x, y);
            if (touchTarget != null && touchTarget.isClickable() && touchTarget.isEnabled()) {
                this.mTouchTarget = touchTarget;
                this.initParametersForChild(event, touchTarget);
                this.postInvalidateDelayed(this.INVALIDATE_DURATION);
            }
        } else {
            if (action == 1) {
                this.mIsPressed = false;
                this.postInvalidateDelayed(this.INVALIDATE_DURATION);
                this.mDispatchUpTouchEventRunnable.event = event;
                this.postDelayed(this.mDispatchUpTouchEventRunnable, 40L);
                return true;
            }
            if (action == 3) {
                this.mIsPressed = false;
                this.postInvalidateDelayed(this.INVALIDATE_DURATION);
            }
        }
        return super.dispatchTouchEvent(event);
    }

    private View getTouchTarget(View view, int x, int y) {
        View target = null;
        ArrayList TouchableViews = view.getTouchables();
        for (View child : TouchableViews) {
            if (!this.isTouchPointInView(child, x, y)) continue;
            target = child;
            break;
        }
        return target;
    }

    private boolean isTouchPointInView(View view, int x, int y) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int left = location[0];
        int top = location[1];
        int right = left + view.getMeasuredWidth();
        int bottom = top + view.getMeasuredHeight();
        return view.isClickable() && y >= top && y <= bottom && x >= left && x <= right;
    }

    public boolean performClick() {
        this.postDelayed(this, 400L);
        return true;
    }

    @Override
    public void run() {
        super.performClick();
    }

    private class DispatchUpTouchEventRunnable
    implements Runnable {
        public MotionEvent event;

        private DispatchUpTouchEventRunnable() {
        }

        @Override
        public void run() {
            if (RevealLayout.this.mTouchTarget == null || !RevealLayout.this.mTouchTarget.isEnabled()) {
                return;
            }
            if (RevealLayout.this.isTouchPointInView(RevealLayout.this.mTouchTarget, (int)this.event.getRawX(), (int)this.event.getRawY())) {
                RevealLayout.this.mTouchTarget.performClick();
            }
        }
    }
}

