/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.Scroller;
import com.xm.ui.widget.listener.OnCurrPosListener;
import java.util.LinkedList;
import java.util.Queue;

public class HorizontalListView
extends AdapterView<ListAdapter>
implements View.OnTouchListener {
    public boolean mAlwaysOverrideTouch = true;
    protected ListAdapter mAdapter;
    protected int mCurrentX;
    protected int mNextX;
    protected Scroller mScroller;
    private int mLeftViewIndex = -1;
    private int mRightViewIndex = 0;
    private int mMaxX = Integer.MAX_VALUE;
    private int mDisplayOffset = 0;
    private GestureDetector mGesture;
    private Queue<View> mRemovedViewQueue = new LinkedList<View>();
    private AdapterView.OnItemSelectedListener mOnItemSelected;
    private AdapterView.OnItemClickListener mOnItemClicked;
    private AdapterView.OnItemLongClickListener mOnItemLongClicked;
    private OnCurrPosListener mSPosListener = null;
    private boolean mDataChanged = false;
    private int mScreenWidth;
    private int mGestureType = 0;
    private int mOldMoveX = 0;
    private int mDownPos = 0;
    private boolean isScroll = true;
    private byte[] mLock = new byte[1];
    private DataSetObserver mDataObserver = new DataSetObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChanged() {
            byte[] byArray = HorizontalListView.this.mLock;
            synchronized (byArray) {
                HorizontalListView.this.mDataChanged = true;
                HorizontalListView.this.requestLayout();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onInvalidated() {
            byte[] byArray = HorizontalListView.this.mLock;
            synchronized (byArray) {
                HorizontalListView.this.reset();
            }
        }
    };
    private GestureDetector.OnGestureListener mOnGesture = new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent e) {
            HorizontalListView.this.mGestureType = 1;
            if (HorizontalListView.this.mSPosListener != null) {
                HorizontalListView.this.mDownPos = HorizontalListView.this.getCurrX();
                HorizontalListView.this.mSPosListener.onDown(HorizontalListView.this.mDownPos);
                HorizontalListView.this.mSPosListener.onPos(HorizontalListView.this.mDownPos);
            }
            return HorizontalListView.this.onDown(e);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!HorizontalListView.this.isScroll) {
                return true;
            }
            byte[] byArray = HorizontalListView.this.mLock;
            synchronized (byArray) {
                HorizontalListView.this.mGestureType = 5;
                HorizontalListView.this.mNextX += (int)distanceX;
                HorizontalListView.this.mScroller.setFinalX(HorizontalListView.this.mNextX);
                if (HorizontalListView.this.mSPosListener != null) {
                    HorizontalListView.this.mSPosListener.onPos(HorizontalListView.this.getCurrX());
                }
                HorizontalListView.this.requestLayout();
            }
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            HorizontalListView.this.mGestureType = 4;
            for (int i = 0; i < HorizontalListView.this.getChildCount(); ++i) {
                View child = HorizontalListView.this.getChildAt(i);
                if (!this.isEventWithinView(e, child)) continue;
                int x = (int)e.getX() - HorizontalListView.this.mScreenWidth / 2 + HorizontalListView.this.getCurrX();
                HorizontalListView.this.scrollTo(x);
                if (HorizontalListView.this.mOnItemClicked != null) {
                    HorizontalListView.this.mOnItemClicked.onItemClick((AdapterView)HorizontalListView.this, child, HorizontalListView.this.mLeftViewIndex + 1 + i, HorizontalListView.this.mAdapter.getItemId(HorizontalListView.this.mLeftViewIndex + 1 + i));
                }
                if (HorizontalListView.this.mOnItemSelected == null) break;
                HorizontalListView.this.mOnItemSelected.onItemSelected((AdapterView)HorizontalListView.this, child, HorizontalListView.this.mLeftViewIndex + 1 + i, HorizontalListView.this.mAdapter.getItemId(HorizontalListView.this.mLeftViewIndex + 1 + i));
                break;
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
            int childCount = HorizontalListView.this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = HorizontalListView.this.getChildAt(i);
                if (!this.isEventWithinView(e, child)) continue;
                if (HorizontalListView.this.mOnItemLongClicked == null) break;
                HorizontalListView.this.mOnItemLongClicked.onItemLongClick((AdapterView)HorizontalListView.this, child, HorizontalListView.this.mLeftViewIndex + 1 + i, HorizontalListView.this.mAdapter.getItemId(HorizontalListView.this.mLeftViewIndex + 1 + i));
                break;
            }
        }

        public boolean onSingleTapUp(MotionEvent e) {
            HorizontalListView.this.mGestureType = 3;
            if (HorizontalListView.this.mSPosListener != null) {
                int nUpPos = HorizontalListView.this.getCurrX();
                HorizontalListView.this.mSPosListener.onPos(nUpPos);
                HorizontalListView.this.mSPosListener.onUp(HorizontalListView.this.mDownPos, nUpPos);
            }
            System.out.println("zzz123");
            return super.onSingleTapUp(e);
        }

        private boolean isEventWithinView(MotionEvent e, View child) {
            Rect viewRect = new Rect();
            int[] childPosition = new int[2];
            child.getLocationOnScreen(childPosition);
            int left = childPosition[0];
            int right = left + child.getWidth();
            int top = childPosition[1];
            int bottom = top + child.getHeight();
            viewRect.set(left, top, right, bottom);
            return viewRect.contains((int)e.getRawX(), (int)e.getRawY());
        }
    };

    public HorizontalListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    private synchronized void initView() {
        this.mLeftViewIndex = -1;
        this.mRightViewIndex = 0;
        this.mDisplayOffset = 0;
        this.mCurrentX = 0;
        this.mNextX = 0;
        this.mMaxX = Integer.MAX_VALUE;
        this.mScroller = new Scroller(this.getContext());
        this.mGesture = new GestureDetector(this.getContext(), this.mOnGesture);
        this.setOnTouchListener(this);
    }

    public void setScroll(boolean b) {
        this.isScroll = b;
    }

    public void setWndWidth(int width) {
        this.mScreenWidth = width;
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener listener) {
        this.mOnItemSelected = listener;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.mOnItemClicked = listener;
    }

    public void setOnItemLongClickListener(AdapterView.OnItemLongClickListener listener) {
        this.mOnItemLongClicked = listener;
    }

    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    public View getSelectedView() {
        return null;
    }

    public void setAdapter(ListAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataObserver);
        }
        this.mAdapter = adapter;
        this.mAdapter.registerDataSetObserver(this.mDataObserver);
        this.reset();
    }

    private synchronized void reset() {
        this.initView();
        this.removeAllViewsInLayout();
        this.requestLayout();
    }

    public void setSelection(int position) {
    }

    private void addAndMeasureChild(View child, int viewPos) {
        ViewGroup.LayoutParams params = child.getLayoutParams();
        if (params == null) {
            params = new ViewGroup.LayoutParams(-1, -1);
        }
        this.addViewInLayout(child, viewPos, params, true);
        child.measure(View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)this.getHeight(), (int)Integer.MIN_VALUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mAdapter == null) {
            return;
        }
        byte[] byArray = this.mLock;
        synchronized (this.mLock) {
            if (this.mDataChanged) {
                int oldCurrentX = this.mCurrentX;
                this.initView();
                this.removeAllViewsInLayout();
                this.mNextX = oldCurrentX;
                this.mDataChanged = false;
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (this.mScroller.computeScrollOffset()) {
                int scrollx;
                this.mNextX = scrollx = this.mScroller.getCurrX();
            }
            if (this.mNextX <= 0) {
                this.mNextX = 0;
                this.mScroller.forceFinished(true);
            }
            if (this.mNextX >= this.mMaxX) {
                this.mNextX = this.mMaxX;
                this.mScroller.forceFinished(true);
            }
            int dx = this.mCurrentX - this.mNextX;
            this.removeNonVisibleItems(dx);
            this.fillList(dx);
            this.positionItems(dx);
            this.mCurrentX = this.mNextX;
            if (!this.mScroller.isFinished()) {
                this.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        byte[] byArray = HorizontalListView.this.mLock;
                        synchronized (byArray) {
                            HorizontalListView.this.requestLayout();
                        }
                    }
                });
            } else if (this.mGestureType == 4) {
                if (this.mSPosListener != null) {
                    this.mSPosListener.onPos(this.getCurrX());
                }
                this.mGestureType = 2;
            }
            return;
        }
    }

    private void fillList(int dx) {
        int edge = 0;
        View child = this.getChildAt(this.getChildCount() - 1);
        if (child != null) {
            edge = child.getRight();
        }
        this.fillListRight(edge, dx);
        edge = 0;
        child = this.getChildAt(0);
        if (child != null) {
            edge = child.getLeft();
        }
        this.fillListLeft(edge, dx);
    }

    private void fillListRight(int rightEdge, int dx) {
        while (rightEdge + dx < this.getWidth() && this.mRightViewIndex < this.mAdapter.getCount()) {
            View child = this.mAdapter.getView(this.mRightViewIndex, this.mRemovedViewQueue.poll(), (ViewGroup)this);
            this.addAndMeasureChild(child, -1);
            rightEdge += child.getMeasuredWidth();
            if (this.mRightViewIndex == this.mAdapter.getCount() - 1) {
                this.mMaxX = this.mCurrentX + rightEdge - this.getWidth();
            }
            if (this.mMaxX < 0) {
                this.mMaxX = 0;
            }
            ++this.mRightViewIndex;
        }
    }

    private void fillListLeft(int leftEdge, int dx) {
        while (leftEdge + dx > 0 && this.mLeftViewIndex >= 0) {
            View child = this.mAdapter.getView(this.mLeftViewIndex, this.mRemovedViewQueue.poll(), (ViewGroup)this);
            this.addAndMeasureChild(child, 0);
            leftEdge -= child.getMeasuredWidth();
            --this.mLeftViewIndex;
            this.mDisplayOffset -= child.getMeasuredWidth();
        }
    }

    private void removeNonVisibleItems(int dx) {
        View child = this.getChildAt(0);
        while (child != null && child.getRight() + dx <= 0) {
            this.mDisplayOffset += child.getMeasuredWidth();
            this.mRemovedViewQueue.offer(child);
            this.removeViewInLayout(child);
            ++this.mLeftViewIndex;
            child = this.getChildAt(0);
        }
        child = this.getChildAt(this.getChildCount() - 1);
        while (child != null && child.getLeft() + dx >= this.getWidth()) {
            this.mRemovedViewQueue.offer(child);
            this.removeViewInLayout(child);
            --this.mRightViewIndex;
            child = this.getChildAt(this.getChildCount() - 1);
        }
    }

    private void positionItems(int dx) {
        if (this.getChildCount() > 0) {
            this.mDisplayOffset += dx;
            int left = this.mDisplayOffset;
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                int childWidth = child.getMeasuredWidth();
                child.layout(left, 0, left + childWidth, child.getMeasuredHeight());
                left += childWidth + child.getPaddingRight();
            }
        }
    }

    public synchronized int getCurrX() {
        return this.mScroller.getCurrX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scrollTo(int x) {
        byte[] byArray = this.mLock;
        synchronized (this.mLock) {
            this.mScroller.startScroll(this.mNextX, 0, x - this.mNextX, 0);
            this.requestLayout();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        boolean handled = super.dispatchTouchEvent(ev);
        return handled |= this.mGesture.onTouchEvent(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        byte[] byArray = this.mLock;
        synchronized (this.mLock) {
            this.mScroller.fling(this.mNextX, 0, (int)(-velocityX), 0, 0, this.mMaxX, 0, 0);
            this.requestLayout();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    protected boolean onDown(MotionEvent e) {
        this.mScroller.forceFinished(true);
        return true;
    }

    public boolean onTouch(View arg0, MotionEvent arg1) {
        if (arg1.getAction() == 0) {
            switch (this.mGestureType) {
                case 5: {
                    if (this.mSPosListener == null) break;
                    this.mSPosListener.onPos(-100);
                    break;
                }
            }
        }
        if (arg1.getAction() == 1) {
            switch (this.mGestureType) {
                case 5: {
                    if (this.mSPosListener != null) {
                        int nUpPos = this.getCurrX();
                        this.mSPosListener.onPos(nUpPos);
                        this.mSPosListener.onUp(this.mDownPos, nUpPos);
                    }
                    this.mGestureType = 2;
                    if (this.mSPosListener == null) break;
                    this.mSPosListener.onPos(this.getCurrX());
                    break;
                }
            }
        }
        return false;
    }

    public int getGestureType() {
        return this.mGestureType;
    }

    public void setOnCurrPosListener(OnCurrPosListener ls) {
        this.mSPosListener = ls;
    }
}

