/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import demo.xm.com.libxmfunsdk.R;
import io.reactivex.annotations.Nullable;

public class DeleteToTrashView
extends View
implements View.OnTouchListener {
    private static final int TRASH_CLOSE = 0;
    private static final int TRASH_OEPN = 1;
    private int trashCloseId;
    private int trashOpenId;
    private Bitmap[] trashBitmaps;
    private Paint paint;
    private int trashState = 0;
    private Point trashPoint;
    private long oldTouchTimes;
    private boolean isInit;
    private Bitmap moveBitmap;
    private Point movePoint;
    private OnDeleteTrashListener onDeleteTrashListener;

    public DeleteToTrashView(Context context) {
        super(context);
    }

    public DeleteToTrashView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public DeleteToTrashView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyle) {
        this.initAttributes(attrs, defStyle);
    }

    private void initAttributes(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.DeleteToTrashView, defStyle, 0);
        this.trashCloseId = typedArray.getResourceId(R.styleable.DeleteToTrashView_trashClose, R.drawable.trash_close);
        this.trashOpenId = typedArray.getResourceId(R.styleable.DeleteToTrashView_trashOpen, R.drawable.trash_open);
        typedArray.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.paint = new Paint();
        this.trashPoint = new Point();
        this.movePoint = new Point();
        this.trashBitmaps = new Bitmap[2];
        this.setOnTouchListener(this);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInit) {
            this.trashPoint.set((this.getWidth() - this.trashBitmaps[0].getWidth()) / 2, (this.getHeight() - this.trashBitmaps[this.trashState].getHeight()) / 2);
            canvas.drawBitmap(this.trashBitmaps[this.trashState], (float)this.trashPoint.x, (float)this.trashPoint.y, this.paint);
            if (this.moveBitmap != null) {
                canvas.drawBitmap(this.moveBitmap, (float)this.movePoint.x, (float)this.movePoint.y, this.paint);
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.trashBitmaps[0] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.trashCloseId);
        this.trashBitmaps[1] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.trashOpenId);
        this.moveBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.trashCloseId);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.trashBitmaps[0] != null) {
            this.trashBitmaps[0].recycle();
            this.trashBitmaps[0] = null;
        }
        if (this.trashBitmaps[1] != null) {
            this.trashBitmaps[1].recycle();
            this.trashBitmaps[1] = null;
        }
        if (this.moveBitmap != null) {
            this.moveBitmap.recycle();
            this.moveBitmap = null;
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus && !this.isInit) {
            this.trashPoint.set((this.getWidth() - this.trashBitmaps[0].getWidth()) / 2, (this.getHeight() - this.trashBitmaps[this.trashState].getHeight()) / 2);
            this.isInit = true;
            this.postInvalidate();
        }
    }

    private float spacing(MotionEvent event) {
        float x = event.getX() - (float)this.trashPoint.x - (float)(this.trashBitmaps[0].getWidth() / 2);
        float y = event.getY() - (float)this.trashPoint.y - (float)(this.trashBitmaps[0].getHeight() / 2);
        return (float)Math.sqrt(x * x + y * y);
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: 
            case 2: {
                this.trashState = this.spacing(motionEvent) <= (float)this.trashBitmaps[0].getWidth() ? 1 : 0;
                if (this.moveBitmap != null) {
                    this.movePoint.set((int)motionEvent.getX() - this.moveBitmap.getWidth() / 2, (int)motionEvent.getY() - this.moveBitmap.getHeight() / 2);
                }
                if (System.currentTimeMillis() - this.oldTouchTimes <= 100L) break;
                this.postInvalidate();
                this.oldTouchTimes = System.currentTimeMillis();
                break;
            }
            case 1: 
            case 3: {
                if (this.trashState == 1) {
                    if (this.onDeleteTrashListener != null) {
                        this.onDeleteTrashListener.onDelete(true);
                    }
                } else if (this.onDeleteTrashListener != null) {
                    this.onDeleteTrashListener.onDelete(false);
                }
                this.trashState = 0;
                this.postInvalidate();
            }
        }
        return true;
    }

    public void setMoveBitmap(Bitmap bitmap) {
        this.moveBitmap = bitmap;
    }

    public void setOnDeleteTrashListener(OnDeleteTrashListener ls) {
        this.onDeleteTrashListener = ls;
    }

    public static interface OnDeleteTrashListener {
        public void onDelete(boolean var1);
    }
}

