/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;

public class AnimationsMoveView
extends ImageView {
    private AnimatorSet mAnimatorSet;
    private boolean mIsSupportAnimation;

    public AnimationsMoveView(Context context) {
        super(context);
    }

    public AnimationsMoveView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AnimationsMoveView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.initAnimation();
    }

    private void initAnimation() {
        if (null == this.mAnimatorSet) {
            this.mAnimatorSet = new AnimatorSet();
            float parentX = ((ViewGroup)this.getParent()).getWidth();
            float parentY = ((ViewGroup)this.getParent()).getHeight();
            float translationX = parentX / 2.0f - this.getX();
            float translationY = parentY / 2.0f - this.getY();
            ObjectAnimator moveX = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationX", (float[])new float[]{translationX, 0.0f});
            ObjectAnimator moveY = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{translationY, 0.0f});
            ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            moveX.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    AnimationsMoveView.this.setVisibility(0);
                }

                public void onAnimationEnd(Animator animation) {
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mAnimatorSet.playTogether(new Animator[]{alpha, moveX, moveY});
            this.mAnimatorSet.setStartDelay(1000L);
            this.mAnimatorSet.setDuration(1500L);
        }
        if (this.mIsSupportAnimation) {
            this.mAnimatorSet.start();
        }
    }

    public void startAnimation() {
        this.mIsSupportAnimation = true;
        if (null != this.mAnimatorSet) {
            this.mAnimatorSet.start();
        }
    }

    public void resetAnimation() {
        this.setVisibility(4);
    }
}

