/*
 * Decompiled with CFR 0.152.
 */
package com.xm.base;

import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xm.base.code.ErrorCodeManager;
import com.xm.base.code.SuccessCode;
import java.net.URLDecoder;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class OkHttpManager {
    public static final int TIME_OUT = 30;

    public static <T> T createOkHttp(String baseUrl, Class<T> _class) {
        return OkHttpManager.createOkHttp(baseUrl, _class, 30);
    }

    public static <T> T createOkHttp(String baseUrl, Class<T> _class, int timeout) {
        OkHttpClient.Builder httpBuilder = new OkHttpClient.Builder();
        OkHttpClient client = httpBuilder.readTimeout((long)timeout, TimeUnit.SECONDS).connectTimeout((long)timeout, TimeUnit.SECONDS).writeTimeout((long)timeout, TimeUnit.SECONDS).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(client).build();
        return (T)retrofit.create(_class);
    }

    public static Callback<ResponseBody> createCallbackForJson(final OnOkHttpListener onOkHttpListener, final Class<?> _class) {
        return new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                block16: {
                    ResponseBody responseBody = (ResponseBody)response.body();
                    if (responseBody != null) {
                        try {
                            String jsonResult = URLDecoder.decode(responseBody.string(), "UTF-8");
                            if (!TextUtils.isEmpty((CharSequence)jsonResult)) {
                                JSONObject jsonObject = JSON.parseObject((String)jsonResult);
                                if (jsonObject != null) {
                                    Integer code;
                                    if (jsonObject.containsKey((Object)"code") && !ErrorCodeManager.isSuccessCode(code = jsonObject.getInteger("code"), SuccessCode.class)) {
                                        String defaultError = "failed";
                                        if (jsonObject.containsKey((Object)"msg")) {
                                            defaultError = jsonObject.getString("msg");
                                        }
                                        if (onOkHttpListener != null) {
                                            onOkHttpListener.onFailed(code, ErrorCodeManager.parseErrorCode(code, defaultError, _class));
                                        }
                                        return;
                                    }
                                    if (jsonObject.containsKey((Object)"data")) {
                                        String data = jsonObject.getString("data");
                                        if (onOkHttpListener != null) {
                                            onOkHttpListener.onSuccess(jsonResult, data);
                                        }
                                    } else if (onOkHttpListener != null) {
                                        onOkHttpListener.onSuccess(jsonResult, null);
                                    }
                                }
                            } else if (onOkHttpListener != null) {
                                onOkHttpListener.onSuccess("\u4ea4\u4e92\u6210\u529f", null);
                            }
                            break block16;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (onOkHttpListener != null) {
                                onOkHttpListener.onFailed(-1, "\u89e3\u6790\u5931\u8d25");
                            }
                            break block16;
                        }
                    }
                    if (onOkHttpListener != null) {
                        onOkHttpListener.onFailed(-1, "\u89e3\u6790\u5931\u8d25");
                    }
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                if (onOkHttpListener != null) {
                    onOkHttpListener.onFailed(-2, throwable.getMessage());
                }
            }
        };
    }

    public static interface OnOkHttpListener<T> {
        public void onSuccess(String var1, T var2);

        public void onFailed(int var1, String var2);
    }
}

