/*
 * Decompiled with CFR 0.152.
 */
package com.xm.activity.main.devlist.view;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.xm.activity.base.XMBaseFragment;
import com.xm.activity.device.monitor.view.XMMonitorActivity;
import com.xm.activity.main.devlist.adapter.XMDeviceListAdapter;
import com.xm.activity.main.devlist.contract.XMDeviceListContract;
import com.xm.activity.main.devlist.presenter.XMDeviceListPresenter;
import demo.xm.com.libxmfunsdk.R;

public class XMDeviceListFragment
extends XMBaseFragment<XMDeviceListPresenter>
implements XMDeviceListContract.IXMDeviceListView {
    private RecyclerView rvDevList;
    private XMDeviceListAdapter xmDeviceListAdapter;

    @Override
    public XMDeviceListPresenter getPresenter() {
        return new XMDeviceListPresenter(this);
    }

    @Override
    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.rootLayout = inflater.inflate(R.layout.funsdk_xm_fragment_dev_list, null);
        this.initView();
        this.initData();
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    private void initView() {
        this.rvDevList = (RecyclerView)this.rootLayout.findViewById(R.id.rv_dev_list);
    }

    private void initData() {
        this.xmDeviceListAdapter = new XMDeviceListAdapter(this);
        this.rvDevList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.rvDevList.setAdapter((RecyclerView.Adapter)this.xmDeviceListAdapter);
        this.xmDeviceListAdapter.setData(((XMDeviceListPresenter)this.presenter).getDevList());
        this.showLoadingDlg();
        ((XMDeviceListPresenter)this.presenter).updateDevState();
    }

    @Override
    public void onUpdateDevStateResult() {
        this.hideLoadingDlg();
        this.xmDeviceListAdapter.notifyDataSetChanged();
    }

    @Override
    public void onDevItemClick(View view, String devId, int position) {
        ((XMDeviceListPresenter)this.presenter).setDevId(devId);
        this.turnToActivity(XMMonitorActivity.class);
    }
}

